/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.util.ObjectUtil;
import com.restfb.util.ReflectionUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;

public class BinaryAttachment {
    private static final String FIELD_NAME_CANNOT_BE_NULL = "Field name cannot be null.";
    private String filename;
    private byte[] data;
    private InputStream dataStream;
    private String contentType;
    private String fieldName;

    @Deprecated
    protected BinaryAttachment(String filename, InputStream data) {
        ObjectUtil.requireNotEmpty(filename, "Binary attachment filename cannot be blank.");
        ObjectUtil.verifyParameterPresence("data", data);
        this.filename = filename;
        this.dataStream = data;
    }

    @Deprecated
    protected BinaryAttachment(String fieldName, String filename, InputStream data) {
        this(filename, data);
        ObjectUtil.requireNotEmpty(fieldName, FIELD_NAME_CANNOT_BE_NULL);
        this.fieldName = fieldName;
    }

    @Deprecated
    protected BinaryAttachment(String filename, InputStream data, String contentType) {
        this(filename, data);
        ObjectUtil.requireNotEmpty(contentType, "ContentType cannot be null.");
        this.contentType = contentType;
    }

    @Deprecated
    protected BinaryAttachment(String fieldName, String filename, InputStream data, String contentType) {
        this(filename, data, contentType);
        ObjectUtil.requireNotEmpty(fieldName, FIELD_NAME_CANNOT_BE_NULL);
        this.fieldName = fieldName;
    }

    protected BinaryAttachment(String filename, byte[] data) {
        ObjectUtil.requireNotEmpty(filename, "Binary attachment filename cannot be blank.");
        ObjectUtil.verifyParameterPresence("data", data);
        this.filename = filename;
        this.data = data;
    }

    protected BinaryAttachment(String fieldName, String filename, byte[] data) {
        this(filename, data);
        ObjectUtil.requireNotEmpty(fieldName, FIELD_NAME_CANNOT_BE_NULL);
        this.fieldName = fieldName;
    }

    protected BinaryAttachment(String filename, byte[] data, String contentType) {
        this(filename, data);
        ObjectUtil.requireNotEmpty(contentType, "ContentType cannot be null.");
        this.contentType = contentType;
    }

    protected BinaryAttachment(String fieldName, String filename, byte[] data, String contentType) {
        this(filename, data, contentType);
        ObjectUtil.requireNotEmpty(fieldName, FIELD_NAME_CANNOT_BE_NULL);
        this.fieldName = fieldName;
    }

    @Deprecated
    public static BinaryAttachment with(String filename, InputStream data) {
        return new BinaryAttachment(filename, data);
    }

    @Deprecated
    public static BinaryAttachment with(String fieldName, String filename, InputStream data) {
        return new BinaryAttachment(fieldName, filename, data);
    }

    @Deprecated
    public static BinaryAttachment with(String filename, InputStream data, String contentType) {
        return new BinaryAttachment(filename, data, contentType);
    }

    @Deprecated
    public static BinaryAttachment with(String fieldName, String filename, InputStream data, String contentType) {
        return new BinaryAttachment(fieldName, filename, data, contentType);
    }

    public static BinaryAttachment with(String filename, byte[] data) {
        return new BinaryAttachment(filename, data);
    }

    public static BinaryAttachment with(String fieldName, String filename, byte[] data) {
        return new BinaryAttachment(fieldName, filename, data);
    }

    public static BinaryAttachment with(String filename, byte[] data, String contentType) {
        return new BinaryAttachment(filename, data, contentType);
    }

    public static BinaryAttachment with(String fieldName, String filename, byte[] data, String contentType) {
        return new BinaryAttachment(fieldName, filename, data, contentType);
    }

    public int hashCode() {
        return ReflectionUtils.hashCode(this);
    }

    public boolean equals(Object that) {
        return ReflectionUtils.equals(this, that);
    }

    public String toString() {
        return String.format("[filename=%s]", this.getFilename());
    }

    public InputStream getData() {
        if (this.data != null) {
            return new ByteArrayInputStream(this.data);
        }
        if (this.dataStream != null) {
            return this.dataStream;
        }
        throw new IllegalStateException("Either the byte[] or the stream mustn't be null at this point.");
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        if (this.dataStream != null) {
            try {
                this.contentType = URLConnection.guessContentTypeFromStream(this.dataStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.data != null) {
            this.contentType = URLConnection.guessContentTypeFromName(this.filename);
        }
        if (this.contentType == null) {
            this.contentType = "application/octet-stream";
        }
        return this.contentType;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

