/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.BaseFacebookClient;
import com.restfb.BinaryAttachment;
import com.restfb.Connection;
import com.restfb.DefaultJsonMapper;
import com.restfb.DefaultWebRequestor;
import com.restfb.FacebookClient;
import com.restfb.FacebookEndpoints;
import com.restfb.JsonMapper;
import com.restfb.Parameter;
import com.restfb.Version;
import com.restfb.WebRequestor;
import com.restfb.batch.BatchRequest;
import com.restfb.batch.BatchResponse;
import com.restfb.exception.FacebookErrorMessageException;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.exception.FacebookNetworkException;
import com.restfb.exception.FacebookOAuthException;
import com.restfb.exception.FacebookResponseContentException;
import com.restfb.exception.FacebookSignedRequestParsingException;
import com.restfb.exception.FacebookSignedRequestVerificationException;
import com.restfb.exception.devicetoken.DeviceTokenExceptionFactory;
import com.restfb.exception.devicetoken.FacebookDeviceTokenCodeExpiredException;
import com.restfb.exception.devicetoken.FacebookDeviceTokenDeclinedException;
import com.restfb.exception.devicetoken.FacebookDeviceTokenPendingException;
import com.restfb.exception.devicetoken.FacebookDeviceTokenSlowdownException;
import com.restfb.exception.generator.DefaultFacebookExceptionGenerator;
import com.restfb.exception.generator.FacebookExceptionGenerator;
import com.restfb.json.Json;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonObject;
import com.restfb.json.JsonValue;
import com.restfb.json.ParseException;
import com.restfb.logging.RestFBLogger;
import com.restfb.scope.ScopeBuilder;
import com.restfb.types.DeviceCode;
import com.restfb.util.EncodingUtils;
import com.restfb.util.ObjectUtil;
import com.restfb.util.StringUtils;
import com.restfb.util.UrlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DefaultFacebookClient
extends BaseFacebookClient
implements FacebookClient {
    public static final String CLIENT_ID = "client_id";
    public static final String APP_ID = "appId";
    public static final String APP_SECRET = "appSecret";
    public static final String SCOPE = "scope";
    public static final String CANNOT_EXTRACT_ACCESS_TOKEN_MESSAGE = "Unable to extract access token from response.";
    protected String accessToken;
    private String appSecret;
    private FacebookExceptionGenerator graphFacebookExceptionGenerator;
    private FacebookEndpoints facebookEndpointUrls = new FacebookEndpoints(){};
    protected static final String IDS_PARAM_NAME = "ids";
    protected Version apiVersion = Version.UNVERSIONED;
    protected boolean httpDeleteFallback;

    protected DefaultFacebookClient() {
        this(Version.LATEST);
    }

    public DefaultFacebookClient(Version apiVersion) {
        this(null, null, new DefaultWebRequestor(), new DefaultJsonMapper(), apiVersion);
    }

    public DefaultFacebookClient(String accessToken, Version apiVersion) {
        this(accessToken, null, new DefaultWebRequestor(), new DefaultJsonMapper(), apiVersion);
    }

    public DefaultFacebookClient(String accessToken, String appSecret, Version apiVersion) {
        this(accessToken, appSecret, new DefaultWebRequestor(), new DefaultJsonMapper(), apiVersion);
    }

    public DefaultFacebookClient(String accessToken, WebRequestor webRequestor, JsonMapper jsonMapper, Version apiVersion) {
        this(accessToken, null, webRequestor, jsonMapper, apiVersion);
    }

    public DefaultFacebookClient(String accessToken, String appSecret, WebRequestor webRequestor, JsonMapper jsonMapper, Version apiVersion) {
        ObjectUtil.verifyParameterPresence("jsonMapper", jsonMapper);
        ObjectUtil.verifyParameterPresence("webRequestor", webRequestor);
        this.accessToken = StringUtils.trimToNull(accessToken);
        this.appSecret = StringUtils.trimToNull(appSecret);
        this.webRequestor = webRequestor;
        this.jsonMapper = jsonMapper;
        this.jsonMapper.setFacebookClient(this);
        this.apiVersion = Optional.ofNullable(apiVersion).orElse(Version.UNVERSIONED);
        this.graphFacebookExceptionGenerator = new DefaultFacebookExceptionGenerator();
    }

    public void setFacebookExceptionGenerator(FacebookExceptionGenerator exceptionGenerator) {
        this.graphFacebookExceptionGenerator = exceptionGenerator;
    }

    public FacebookExceptionGenerator getFacebookExceptionGenerator() {
        return this.graphFacebookExceptionGenerator;
    }

    @Override
    public boolean deleteObject(String object, Parameter ... parameters) {
        ObjectUtil.verifyParameterPresence("object", object);
        String responseString = this.makeRequest(object, true, true, null, parameters);
        try {
            JsonValue jObj = Json.parse(responseString);
            boolean success = false;
            if (jObj.isObject()) {
                if (jObj.asObject().contains("success")) {
                    success = jObj.asObject().get("success").asBoolean();
                }
                if (jObj.asObject().contains("result")) {
                    success = jObj.asObject().get("result").asString().contains("Successfully deleted");
                }
            } else {
                success = jObj.asBoolean();
            }
            return success;
        }
        catch (ParseException jex) {
            RestFBLogger.CLIENT_LOGGER.trace("no valid JSON returned while deleting a object, using returned String instead", jex);
            return "true".equals(responseString);
        }
    }

    @Override
    public <T> Connection<T> fetchConnection(String connection, Class<T> connectionType, Parameter ... parameters) {
        ObjectUtil.verifyParameterPresence("connection", connection);
        ObjectUtil.verifyParameterPresence("connectionType", connectionType);
        return new Connection<T>(this, this.makeRequest(connection, parameters), connectionType);
    }

    @Override
    public <T> Connection<T> fetchConnectionPage(String connectionPageUrl, Class<T> connectionType) {
        String connectionJson = !StringUtils.isBlank(this.accessToken) && !StringUtils.isBlank(this.appSecret) ? this.makeRequestAndProcessResponse(() -> this.webRequestor.executeGet(String.format("%s&%s=%s", connectionPageUrl, UrlUtils.urlEncode("appsecret_proof"), this.obtainAppSecretProof(this.accessToken, this.appSecret)))) : this.makeRequestAndProcessResponse(() -> this.webRequestor.executeGet(connectionPageUrl));
        return new Connection<T>(this, connectionJson, connectionType);
    }

    @Override
    public <T> T fetchObject(String object, Class<T> objectType, Parameter ... parameters) {
        ObjectUtil.verifyParameterPresence("object", object);
        ObjectUtil.verifyParameterPresence("objectType", objectType);
        return this.jsonMapper.toJavaObject(this.makeRequest(object, parameters), objectType);
    }

    @Override
    public FacebookClient createClientWithAccessToken(String accessToken) {
        return new DefaultFacebookClient(accessToken, this.appSecret, this.apiVersion);
    }

    @Override
    public <T> T fetchObjects(List<String> ids, Class<T> objectType, Parameter ... parameters) {
        ObjectUtil.verifyParameterPresence(IDS_PARAM_NAME, ids);
        ObjectUtil.verifyParameterPresence("connectionType", objectType);
        if (ids.isEmpty()) {
            throw new IllegalArgumentException("The list of IDs cannot be empty.");
        }
        if (Stream.of(parameters).anyMatch(p -> IDS_PARAM_NAME.equals(p.name))) {
            throw new IllegalArgumentException("You cannot specify the 'ids' URL parameter yourself - RestFB will populate this for you with the list of IDs you passed to this method.");
        }
        JsonArray idArray = new JsonArray();
        for (String id : ids) {
            if (StringUtils.isBlank(id)) {
                throw new IllegalArgumentException("The list of IDs cannot contain blank strings.");
            }
            idArray.add(id.trim());
        }
        try {
            String jsonString = this.makeRequest("", this.parametersWithAdditionalParameter(Parameter.with(IDS_PARAM_NAME, idArray.toString()), parameters));
            return this.jsonMapper.toJavaObject(jsonString, objectType);
        }
        catch (ParseException e) {
            throw new FacebookJsonMappingException("Unable to map connection JSON to Java objects", e);
        }
    }

    @Override
    public <T> T publish(String connection, Class<T> objectType, List<BinaryAttachment> binaryAttachments, Parameter ... parameters) {
        ObjectUtil.verifyParameterPresence("connection", connection);
        return this.jsonMapper.toJavaObject(this.makeRequest(connection, true, false, binaryAttachments, parameters), objectType);
    }

    @Override
    public <T> T publish(String connection, Class<T> objectType, BinaryAttachment binaryAttachment, Parameter ... parameters) {
        List attachments = Optional.ofNullable(binaryAttachment).map(Collections::singletonList).orElse(null);
        return this.publish(connection, objectType, attachments, parameters);
    }

    @Override
    public <T> T publish(String connection, Class<T> objectType, Parameter ... parameters) {
        return this.publish(connection, objectType, (List<BinaryAttachment>)null, parameters);
    }

    @Override
    public String getLogoutUrl(String next) {
        String parameterString;
        if (next != null) {
            Parameter p = Parameter.with("next", next);
            parameterString = this.toParameterString(false, p);
        } else {
            parameterString = this.toParameterString(false, new Parameter[0]);
        }
        String fullEndPoint = this.createEndpointForApiCall("logout.php", false);
        return fullEndPoint + "?" + parameterString;
    }

    @Override
    public List<BatchResponse> executeBatch(BatchRequest ... batchRequests) {
        return this.executeBatch(Arrays.asList(batchRequests), Collections.emptyList());
    }

    @Override
    public List<BatchResponse> executeBatch(List<BatchRequest> batchRequests) {
        return this.executeBatch(batchRequests, Collections.emptyList());
    }

    @Override
    public List<BatchResponse> executeBatch(List<BatchRequest> batchRequests, List<BinaryAttachment> binaryAttachments) {
        ObjectUtil.verifyParameterPresence("binaryAttachments", binaryAttachments);
        if (batchRequests == null || batchRequests.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least one batch request.");
        }
        return this.jsonMapper.toJavaList(this.makeRequest("", true, false, binaryAttachments, Parameter.with("batch", this.jsonMapper.toJson(batchRequests, true))), BatchResponse.class);
    }

    @Override
    public List<FacebookClient.AccessToken> convertSessionKeysToAccessTokens(String appId, String secretKey, String ... sessionKeys) {
        ObjectUtil.verifyParameterPresence(APP_ID, appId);
        ObjectUtil.verifyParameterPresence("secretKey", secretKey);
        if (sessionKeys == null || sessionKeys.length == 0) {
            return Collections.emptyList();
        }
        String json = this.makeRequest("/oauth/exchange_sessions", true, false, null, Parameter.with(CLIENT_ID, appId), Parameter.with("client_secret", secretKey), Parameter.with("sessions", String.join((CharSequence)",", sessionKeys)));
        return this.jsonMapper.toJavaList(json, FacebookClient.AccessToken.class);
    }

    @Override
    public FacebookClient.AccessToken obtainAppAccessToken(String appId, String appSecret) {
        ObjectUtil.verifyParameterPresence(APP_ID, appId);
        ObjectUtil.verifyParameterPresence(APP_SECRET, appSecret);
        String response = this.makeRequest("oauth/access_token", Parameter.with("grant_type", "client_credentials"), Parameter.with(CLIENT_ID, appId), Parameter.with("client_secret", appSecret));
        try {
            return this.getAccessTokenFromResponse(response);
        }
        catch (Exception t) {
            throw new FacebookResponseContentException(CANNOT_EXTRACT_ACCESS_TOKEN_MESSAGE, t);
        }
    }

    @Override
    public DeviceCode fetchDeviceCode(ScopeBuilder scope) {
        ObjectUtil.verifyParameterPresence(SCOPE, scope);
        ObjectUtil.requireNotNull(this.accessToken, () -> new IllegalStateException("access token is required to fetch a device access token"));
        String response = this.makeRequest("device/login", true, false, null, Parameter.with("type", "device_code"), Parameter.with(SCOPE, scope.toString()));
        return this.jsonMapper.toJavaObject(response, DeviceCode.class);
    }

    @Override
    public FacebookClient.AccessToken obtainDeviceAccessToken(String code) throws FacebookDeviceTokenCodeExpiredException, FacebookDeviceTokenPendingException, FacebookDeviceTokenDeclinedException, FacebookDeviceTokenSlowdownException {
        ObjectUtil.verifyParameterPresence("code", code);
        ObjectUtil.requireNotNull(this.accessToken, () -> new IllegalStateException("access token is required to fetch a device access token"));
        try {
            String response = this.makeRequest("device/login_status", true, false, null, Parameter.with("type", "device_token"), Parameter.with("code", code));
            return this.getAccessTokenFromResponse(response);
        }
        catch (FacebookOAuthException foae) {
            DeviceTokenExceptionFactory.createFrom(foae);
            return null;
        }
    }

    @Override
    public FacebookClient.AccessToken obtainUserAccessToken(String appId, String appSecret, String redirectUri, String verificationCode) {
        ObjectUtil.verifyParameterPresence(APP_ID, appId);
        ObjectUtil.verifyParameterPresence(APP_SECRET, appSecret);
        ObjectUtil.verifyParameterPresence("verificationCode", verificationCode);
        String response = this.makeRequest("oauth/access_token", Parameter.with(CLIENT_ID, appId), Parameter.with("client_secret", appSecret), Parameter.with("code", verificationCode), Parameter.with("redirect_uri", redirectUri));
        try {
            return this.getAccessTokenFromResponse(response);
        }
        catch (Exception t) {
            throw new FacebookResponseContentException(CANNOT_EXTRACT_ACCESS_TOKEN_MESSAGE, t);
        }
    }

    @Override
    public FacebookClient.AccessToken obtainExtendedAccessToken(String appId, String appSecret) {
        ObjectUtil.requireNotNull(this.accessToken, () -> new IllegalStateException(String.format("You cannot call this method because you did not construct this instance of %s with an access token.", this.getClass().getSimpleName())));
        return this.obtainExtendedAccessToken(appId, appSecret, this.accessToken);
    }

    @Override
    public FacebookClient.AccessToken obtainExtendedAccessToken(String appId, String appSecret, String accessToken) {
        ObjectUtil.verifyParameterPresence(APP_ID, appId);
        ObjectUtil.verifyParameterPresence(APP_SECRET, appSecret);
        ObjectUtil.verifyParameterPresence("accessToken", accessToken);
        String response = this.makeRequest("/oauth/access_token", false, false, null, Parameter.with(CLIENT_ID, appId), Parameter.with("client_secret", appSecret), Parameter.with("grant_type", "fb_exchange_token"), Parameter.with("fb_exchange_token", accessToken));
        try {
            return this.getAccessTokenFromResponse(response);
        }
        catch (Exception t) {
            throw new FacebookResponseContentException(CANNOT_EXTRACT_ACCESS_TOKEN_MESSAGE, t);
        }
    }

    private FacebookClient.AccessToken getAccessTokenFromResponse(String response) {
        FacebookClient.AccessToken token;
        try {
            token = this.getJsonMapper().toJavaObject(response, FacebookClient.AccessToken.class);
        }
        catch (FacebookJsonMappingException fjme) {
            RestFBLogger.CLIENT_LOGGER.trace("could not map response to access token class try to fetch directly from String", fjme);
            token = FacebookClient.AccessToken.fromQueryString(response);
        }
        token.setClient(this.createClientWithAccessToken(token.getAccessToken()));
        return token;
    }

    @Override
    public <T> T parseSignedRequest(String signedRequest, String appSecret, Class<T> objectType) {
        ObjectUtil.verifyParameterPresence("signedRequest", signedRequest);
        ObjectUtil.verifyParameterPresence(APP_SECRET, appSecret);
        ObjectUtil.verifyParameterPresence("objectType", objectType);
        String[] signedRequestTokens = signedRequest.split("[.]");
        if (signedRequestTokens.length != 2) {
            throw new FacebookSignedRequestParsingException(String.format("Signed request '%s' is expected to be signature and payload strings separated by a '.'", signedRequest));
        }
        String encodedSignature = signedRequestTokens[0];
        String urlDecodedSignature = this.urlDecodeSignedRequestToken(encodedSignature);
        byte[] signature = EncodingUtils.decodeBase64(urlDecodedSignature);
        String encodedPayload = signedRequestTokens[1];
        String urlDecodedPayload = this.urlDecodeSignedRequestToken(encodedPayload);
        String payload = StringUtils.toString(EncodingUtils.decodeBase64(urlDecodedPayload));
        JsonObject payloadObject = this.getJsonMapper().toJavaObject(payload, JsonObject.class);
        if (!payloadObject.contains("algorithm")) {
            throw new FacebookSignedRequestParsingException("Unable to detect algorithm used for signed request");
        }
        String algorithm = payloadObject.getString("algorithm", null);
        if (!this.verifySignedRequest(appSecret, algorithm, encodedPayload, signature)) {
            throw new FacebookSignedRequestVerificationException("Signed request verification failed. Are you sure the request was made for the app identified by the app secret you provided?");
        }
        return (T)(objectType.equals(JsonObject.class) ? payloadObject : this.getJsonMapper().toJavaObject(payload, objectType));
    }

    protected String urlDecodeSignedRequestToken(String signedRequestToken) {
        ObjectUtil.verifyParameterPresence("signedRequestToken", signedRequestToken);
        return signedRequestToken.replace("-", "+").replace("_", "/").trim();
    }

    @Override
    public String getLoginDialogUrl(String appId, String redirectUri, ScopeBuilder scope, Parameter ... parameters) {
        ObjectUtil.verifyParameterPresence(APP_ID, appId);
        ObjectUtil.verifyParameterPresence("redirectUri", redirectUri);
        ObjectUtil.verifyParameterPresence(SCOPE, scope);
        String dialogUrl = this.getFacebookEndpointUrls().getFacebookEndpoint() + "/dialog/oauth";
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        parameterList.add(Parameter.with(CLIENT_ID, appId));
        parameterList.add(Parameter.with("redirect_uri", redirectUri));
        parameterList.add(Parameter.with(SCOPE, scope.toString()));
        Collections.addAll(parameterList, parameters);
        return dialogUrl + "?" + this.toParameterString(false, (Parameter[])parameterList.stream().toArray(Parameter[]::new));
    }

    protected boolean verifySignedRequest(String appSecret, String algorithm, String encodedPayload, byte[] signature) {
        ObjectUtil.verifyParameterPresence(APP_SECRET, appSecret);
        ObjectUtil.verifyParameterPresence("algorithm", algorithm);
        ObjectUtil.verifyParameterPresence("encodedPayload", encodedPayload);
        ObjectUtil.verifyParameterPresence("signature", signature);
        if ("HMAC-SHA256".equalsIgnoreCase(algorithm)) {
            algorithm = "HMACSHA256";
        }
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(StringUtils.toBytes(appSecret), algorithm));
            byte[] payloadSignature = mac.doFinal(StringUtils.toBytes(encodedPayload));
            return Arrays.equals(signature, payloadSignature);
        }
        catch (Exception e) {
            throw new FacebookSignedRequestVerificationException("Unable to perform signed request verification", e);
        }
    }

    @Override
    public FacebookClient.DebugTokenInfo debugToken(String inputToken) {
        ObjectUtil.verifyParameterPresence("inputToken", inputToken);
        String response = this.makeRequest("/debug_token", Parameter.with("input_token", inputToken));
        try {
            JsonObject json = Json.parse(response).asObject();
            JsonObject data = json.get("data").asObject();
            return this.getJsonMapper().toJavaObject(data.toString(), FacebookClient.DebugTokenInfo.class);
        }
        catch (Exception t) {
            throw new FacebookResponseContentException("Unable to parse JSON from response.", t);
        }
    }

    @Override
    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    @Override
    public WebRequestor getWebRequestor() {
        return this.webRequestor;
    }

    protected String makeRequest(String endpoint, Parameter ... parameters) {
        return this.makeRequest(endpoint, false, false, null, parameters);
    }

    protected String makeRequest(String endpoint, boolean executeAsPost, boolean executeAsDelete, List<BinaryAttachment> binaryAttachments, Parameter ... parameters) {
        this.verifyParameterLegality(parameters);
        if (executeAsDelete && this.isHttpDeleteFallback()) {
            parameters = this.parametersWithAdditionalParameter(Parameter.with("method", "delete"), parameters);
        }
        if (!endpoint.startsWith("/")) {
            endpoint = "/" + endpoint;
        }
        String fullEndpoint = this.createEndpointForApiCall(endpoint, binaryAttachments != null && !binaryAttachments.isEmpty());
        String parameterString = this.toParameterString(parameters);
        return this.makeRequestAndProcessResponse(() -> {
            if (executeAsDelete && !this.isHttpDeleteFallback()) {
                return this.webRequestor.executeDelete(fullEndpoint + "?" + parameterString);
            }
            if (executeAsPost) {
                return this.webRequestor.executePost(fullEndpoint, parameterString, binaryAttachments);
            }
            return this.webRequestor.executeGet(fullEndpoint + "?" + parameterString);
        });
    }

    @Override
    public String obtainAppSecretProof(String accessToken, String appSecret) {
        ObjectUtil.verifyParameterPresence("accessToken", accessToken);
        ObjectUtil.verifyParameterPresence(APP_SECRET, appSecret);
        return EncodingUtils.encodeAppSecretProof(appSecret, accessToken);
    }

    public boolean isHttpDeleteFallback() {
        return this.httpDeleteFallback;
    }

    public void setHttpDeleteFallback(boolean httpDeleteFallback) {
        this.httpDeleteFallback = httpDeleteFallback;
    }

    protected String makeRequestAndProcessResponse(Requestor requestor) {
        WebRequestor.Response response;
        try {
            response = requestor.makeRequest();
        }
        catch (Exception t) {
            throw new FacebookNetworkException(t);
        }
        if (200 != response.getStatusCode() && 400 != response.getStatusCode() && 401 != response.getStatusCode() && 404 != response.getStatusCode() && 500 != response.getStatusCode() && 403 != response.getStatusCode() && 304 != response.getStatusCode()) {
            throw new FacebookNetworkException(response.getStatusCode());
        }
        String json = response.getBody();
        try {
            this.getFacebookExceptionGenerator().throwFacebookResponseStatusExceptionIfNecessary(json, response.getStatusCode());
        }
        catch (FacebookErrorMessageException feme) {
            Optional.ofNullable(this.getWebRequestor()).map(WebRequestor::getDebugHeaderInfo).ifPresent(feme::setDebugHeaderInfo);
            throw feme;
        }
        if (500 == response.getStatusCode() || 401 == response.getStatusCode()) {
            throw new FacebookNetworkException(response.getStatusCode());
        }
        return json;
    }

    protected String toParameterString(Parameter ... parameters) {
        return this.toParameterString(true, parameters);
    }

    protected String toParameterString(boolean withJsonParameter, Parameter ... parameters) {
        if (!StringUtils.isBlank(this.accessToken)) {
            parameters = this.parametersWithAdditionalParameter(Parameter.with("access_token", this.accessToken), parameters);
        }
        if (!StringUtils.isBlank(this.accessToken) && !StringUtils.isBlank(this.appSecret)) {
            parameters = this.parametersWithAdditionalParameter(Parameter.with("appsecret_proof", this.obtainAppSecretProof(this.accessToken, this.appSecret)), parameters);
        }
        if (withJsonParameter) {
            parameters = this.parametersWithAdditionalParameter(Parameter.with("format", "json"), parameters);
        }
        return Stream.of(parameters).map(p -> UrlUtils.urlEncode(p.name) + "=" + this.urlEncodedValueForParameterName(p.name, p.value)).collect(Collectors.joining("&"));
    }

    @Override
    protected String createEndpointForApiCall(String apiCall, boolean hasAttachment) {
        while (apiCall.startsWith("/")) {
            apiCall = apiCall.substring(1);
        }
        String baseUrl = this.getFacebookGraphEndpointUrl();
        if (hasAttachment && (apiCall.endsWith("/videos") || apiCall.endsWith("/advideos"))) {
            baseUrl = this.getFacebookGraphVideoEndpointUrl();
        } else if (apiCall.endsWith("logout.php")) {
            baseUrl = this.getFacebookEndpointUrls().getFacebookEndpoint();
        }
        return String.format("%s/%s", baseUrl, apiCall);
    }

    protected String getFacebookGraphEndpointUrl() {
        if (this.apiVersion.isUrlElementRequired()) {
            return this.getFacebookEndpointUrls().getGraphEndpoint() + '/' + this.apiVersion.getUrlElement();
        }
        return this.getFacebookEndpointUrls().getGraphEndpoint();
    }

    protected String getFacebookGraphVideoEndpointUrl() {
        if (this.apiVersion.isUrlElementRequired()) {
            return this.getFacebookEndpointUrls().getGraphVideoEndpoint() + '/' + this.apiVersion.getUrlElement();
        }
        return this.getFacebookEndpointUrls().getGraphVideoEndpoint();
    }

    public FacebookEndpoints getFacebookEndpointUrls() {
        return this.facebookEndpointUrls;
    }

    public void setFacebookEndpointUrls(FacebookEndpoints facebookEndpointUrls) {
        this.facebookEndpointUrls = facebookEndpointUrls;
    }

    protected static interface Requestor {
        public WebRequestor.Response makeRequest() throws IOException;
    }
}

