/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.DefaultWebRequestor;
import com.restfb.WebRequestor;
import com.restfb.util.SoftHashMap;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;

public class ETagWebRequestor
extends DefaultWebRequestor {
    private static Supplier<Map<String, ETagResponse>> mapBuilder = SoftHashMap::new;
    final Map<String, ETagResponse> etagCache = Collections.synchronizedMap(mapBuilder.get());
    private final ThreadLocal<ETagResponse> currentETagRespThreadLocal = new ThreadLocal();
    private volatile boolean useCache = true;

    @Override
    protected void customizeConnection(HttpURLConnection connection) {
        ETagResponse resp;
        if (this.isUseCache() && connection.getRequestMethod().equals(DefaultWebRequestor.HttpMethod.GET.name()) && (resp = this.etagCache.get(connection.getURL().toString())) != null) {
            this.currentETagRespThreadLocal.set(resp);
            connection.addRequestProperty("If-None-Match", resp.getEtag());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected WebRequestor.Response fetchResponse(HttpURLConnection httpUrlConnection) throws IOException {
        try {
            if (httpUrlConnection.getRequestMethod().equals(DefaultWebRequestor.HttpMethod.GET.name())) {
                if (httpUrlConnection.getResponseCode() == 304 && this.currentETagRespThreadLocal.get() != null) {
                    ETagResponse etagResp = this.currentETagRespThreadLocal.get();
                    WebRequestor.Response response = new WebRequestor.Response(httpUrlConnection.getResponseCode(), etagResp.getBody());
                    return response;
                }
                WebRequestor.Response resp = super.fetchResponse(httpUrlConnection);
                if (httpUrlConnection.getHeaderField("ETag") != null) {
                    this.etagCache.put(httpUrlConnection.getURL().toString(), new ETagResponse(httpUrlConnection.getHeaderField("ETag"), resp.getBody()));
                }
                WebRequestor.Response response = resp;
                return response;
            }
            WebRequestor.Response response = super.fetchResponse(httpUrlConnection);
            return response;
        }
        finally {
            this.currentETagRespThreadLocal.remove();
        }
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public static void setMapSupplier(Supplier<Map<String, ETagResponse>> mapSupplier) {
        mapBuilder = mapSupplier;
    }

    static class ETagResponse {
        private final String etag;
        private final String body;

        public ETagResponse(String etag, String body) {
            this.etag = etag;
            this.body = body;
        }

        public String getEtag() {
            return this.etag;
        }

        public String getBody() {
            return this.body;
        }
    }
}

