/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.BinaryAttachment;
import com.restfb.Connection;
import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.Parameter;
import com.restfb.WebRequestor;
import com.restfb.batch.BatchRequest;
import com.restfb.batch.BatchResponse;
import com.restfb.exception.devicetoken.FacebookDeviceTokenCodeExpiredException;
import com.restfb.exception.devicetoken.FacebookDeviceTokenDeclinedException;
import com.restfb.exception.devicetoken.FacebookDeviceTokenPendingException;
import com.restfb.exception.devicetoken.FacebookDeviceTokenSlowdownException;
import com.restfb.json.JsonObject;
import com.restfb.scope.ScopeBuilder;
import com.restfb.types.AbstractFacebookType;
import com.restfb.types.DeviceCode;
import com.restfb.util.ReflectionUtils;
import com.restfb.util.UrlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface FacebookClient {
    public <T> T fetchObject(String var1, Class<T> var2, Parameter ... var3);

    public FacebookClient createClientWithAccessToken(String var1);

    public <T> T fetchObjects(List<String> var1, Class<T> var2, Parameter ... var3);

    public <T> Connection<T> fetchConnection(String var1, Class<T> var2, Parameter ... var3);

    public <T> Connection<T> fetchConnectionPage(String var1, Class<T> var2);

    public List<BatchResponse> executeBatch(BatchRequest ... var1);

    public List<BatchResponse> executeBatch(List<BatchRequest> var1);

    public List<BatchResponse> executeBatch(List<BatchRequest> var1, List<BinaryAttachment> var2);

    public <T> T publish(String var1, Class<T> var2, Parameter ... var3);

    public <T> T publish(String var1, Class<T> var2, List<BinaryAttachment> var3, Parameter ... var4);

    public <T> T publish(String var1, Class<T> var2, BinaryAttachment var3, Parameter ... var4);

    public boolean deleteObject(String var1, Parameter ... var2);

    public List<AccessToken> convertSessionKeysToAccessTokens(String var1, String var2, String ... var3);

    public AccessToken obtainUserAccessToken(String var1, String var2, String var3, String var4);

    public AccessToken obtainAppAccessToken(String var1, String var2);

    public AccessToken obtainExtendedAccessToken(String var1, String var2, String var3);

    public String obtainAppSecretProof(String var1, String var2);

    public AccessToken obtainExtendedAccessToken(String var1, String var2);

    public <T> T parseSignedRequest(String var1, String var2, Class<T> var3);

    public DeviceCode fetchDeviceCode(ScopeBuilder var1);

    public AccessToken obtainDeviceAccessToken(String var1) throws FacebookDeviceTokenCodeExpiredException, FacebookDeviceTokenPendingException, FacebookDeviceTokenDeclinedException, FacebookDeviceTokenSlowdownException;

    public DebugTokenInfo debugToken(String var1);

    public JsonMapper getJsonMapper();

    public WebRequestor getWebRequestor();

    public String getLogoutUrl(String var1);

    public String getLoginDialogUrl(String var1, String var2, ScopeBuilder var3, Parameter ... var4);

    public static class DebugTokenError
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private Integer code;
        @Facebook
        private String message;
        @Facebook
        private Integer subcode;

        public Integer getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public Integer getSubcode() {
            return this.subcode;
        }
    }

    public static class DebugTokenInfo
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook(value="app_id")
        private String appId;
        @Facebook
        private String application;
        @Facebook(value="expires_at")
        private Date expiresAt;
        @Facebook(value="data_access_expires_at")
        private Date dataAccessExpiresAt;
        @Facebook(value="issued_at")
        private Date issuedAt;
        @Facebook(value="is_valid")
        private Boolean isValid;
        @Facebook(value="user_id")
        private String userId;
        @Facebook(value="profile_id")
        private String profileId;
        @Facebook
        private JsonObject metadata;
        @Facebook
        private DebugTokenError error;
        @Facebook
        private List<String> scopes = new ArrayList<String>();
        @Facebook
        private String type;

        public String getAppId() {
            return this.appId;
        }

        public String getApplication() {
            return this.application;
        }

        public Date getExpiresAt() {
            return this.expiresAt;
        }

        public Date getDataAccessExpiresAt() {
            return this.dataAccessExpiresAt;
        }

        public Date getIssuedAt() {
            return this.issuedAt;
        }

        public Boolean isValid() {
            return this.isValid;
        }

        public String getUserId() {
            return this.userId;
        }

        public List<String> getScopes() {
            return Collections.unmodifiableList(this.scopes);
        }

        public JsonObject getMetaData() {
            return this.metadata;
        }

        public DebugTokenError getDebugTokenError() {
            return this.error;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class AccessToken {
        @Facebook(value="access_token")
        private String accessToken;
        @Facebook(value="expires_in")
        private Long rawExpires;
        private Long expires;
        @Facebook(value="token_type")
        private String tokenType;
        private FacebookClient client;

        public void setClient(FacebookClient client) {
            this.client = client;
        }

        public FacebookClient getClient() {
            return Optional.ofNullable(this.client).orElse(null);
        }

        public static AccessToken fromQueryString(String queryString) {
            Map<String, List<String>> urlParameters = UrlUtils.extractParametersFromQueryString(queryString);
            String extendedAccessToken = null;
            String tokenType = null;
            if (urlParameters.containsKey("access_token")) {
                extendedAccessToken = urlParameters.get("access_token").get(0);
            }
            if (urlParameters.containsKey("token_type")) {
                tokenType = urlParameters.get("token_type").get(0);
            }
            if (extendedAccessToken == null) {
                throw new IllegalArgumentException(String.format("Was expecting a query string of the form 'access_token=XXX' or 'access_token=XXX&expires=YYY'. Instead, the query string was '%s'", queryString));
            }
            Long expires = null;
            String rawExpires = null;
            if (urlParameters.containsKey("expires")) {
                rawExpires = urlParameters.get("expires").get(0);
            }
            if (urlParameters.containsKey("expires_in")) {
                rawExpires = urlParameters.get("expires_in").get(0);
            }
            if (rawExpires != null) {
                try {
                    expires = Long.valueOf(rawExpires);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (expires != null) {
                    expires = new Date().getTime() + 1000L * expires;
                }
            }
            AccessToken accessToken = new AccessToken();
            accessToken.accessToken = extendedAccessToken;
            accessToken.expires = expires;
            accessToken.tokenType = tokenType;
            return accessToken;
        }

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object that) {
            return ReflectionUtils.equals(this, that);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Date getExpires() {
            return this.expires == null ? null : new Date(this.expires);
        }

        public String getTokenType() {
            return this.tokenType;
        }

        @JsonMapper.JsonMappingCompleted
        void convertExpires() {
            if (this.rawExpires != null) {
                this.expires = new Date().getTime() + 1000L * this.rawExpires;
            }
        }
    }
}

