/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;

class JsonHelper {
    JsonHelper() {
    }

    public boolean getBooleanFrom(JsonValue json) {
        if (json.isBoolean()) {
            return json.asBoolean();
        }
        if (json.isNumber()) {
            if (json.asInt() == 0) {
                return Boolean.FALSE;
            }
            if (json.asInt() == 1) {
                return Boolean.TRUE;
            }
        }
        if (json.isString()) {
            String value = json.asString();
            if (value.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            if (value.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
        }
        throw new UnsupportedOperationException("Json is not a boolean: " + json);
    }

    public Double getDoubleFrom(JsonValue json) {
        if (json.isNumber()) {
            return json.asDouble();
        }
        return Double.valueOf(json.asString());
    }

    public Integer getIntegerFrom(JsonValue json) {
        if (json.isNumber()) {
            return json.asInt();
        }
        return Integer.valueOf(json.asString());
    }

    public String getStringFrom(JsonValue json) {
        if (json.isString()) {
            return json.asString();
        }
        return json.toString();
    }

    public Float getFloatFrom(JsonValue json) {
        if (json.isNumber()) {
            return Float.valueOf(json.asFloat());
        }
        return Float.valueOf(new BigDecimal(json.asString()).floatValue());
    }

    public BigInteger getBigIntegerFrom(JsonValue json) {
        if (json.isString()) {
            return new BigInteger(json.asString());
        }
        return new BigInteger(json.toString());
    }

    public Long getLongFrom(JsonValue json) {
        if (json.isNumber()) {
            return json.asLong();
        }
        return Long.valueOf(json.asString());
    }

    public BigDecimal getBigDecimalFrom(JsonValue json) {
        if (json.isString()) {
            return new BigDecimal(json.asString());
        }
        return new BigDecimal(json.toString());
    }

    public String cleanString(String jsonInput) {
        if (jsonInput.length() > 1 && jsonInput.startsWith("\"") && jsonInput.endsWith("\"")) {
            return jsonInput.substring(1, jsonInput.length() - 1);
        }
        return jsonInput;
    }
}

