/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import java.util.stream.Stream;

public enum Version {
    UNVERSIONED(null),
    VERSION_3_1("v3.1"),
    VERSION_3_2("v3.2"),
    VERSION_3_3("v3.3"),
    VERSION_4_0("v4.0"),
    VERSION_5_0("v5.0"),
    VERSION_6_0("v6.0"),
    VERSION_7_0("v7.0"),
    VERSION_8_0("v8.0"),
    LATEST("v8.0");

    private final String urlElement;

    private Version(String urlElement) {
        this.urlElement = urlElement;
    }

    public String getUrlElement() {
        return this.urlElement;
    }

    public boolean isUrlElementRequired() {
        return null != this.urlElement;
    }

    public static Version getVersionFromString(String urlElementStr) {
        if (urlElementStr != null) {
            return Stream.of(Version.values()).filter(v -> urlElementStr.equals(v.getUrlElement())).findFirst().orElse(UNVERSIONED);
        }
        return UNVERSIONED;
    }
}

