/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.exception;

import com.restfb.exception.FacebookErrorMessageException;
import com.restfb.json.JsonObject;

public class FacebookGraphException
extends FacebookErrorMessageException {
    private static final long serialVersionUID = 1L;
    private final String errorType;
    private final String errorMessage;
    private final String errorUserTitle;
    private final String errorUserMessage;
    private final Integer errorCode;
    private final Integer errorSubcode;
    private final Integer httpStatusCode;
    private final Boolean isTransient;

    public FacebookGraphException(String errorType, String errorMessage, Integer errorCode, Integer errorSubcode, Integer httpStatusCode, String errorUserTitle, String errorUserMessage, Boolean isTransient, JsonObject rawError) {
        super(String.format("Received Facebook error response of type %s: %s (code %s, subcode %s) '%s - %s'", errorType, errorMessage, errorCode, errorSubcode, errorUserTitle, errorUserMessage));
        this.errorType = errorType;
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
        this.errorSubcode = errorSubcode;
        this.httpStatusCode = httpStatusCode;
        this.errorUserTitle = errorUserTitle;
        this.errorUserMessage = errorUserMessage;
        this.isTransient = isTransient;
        this.setRawErrorJson(rawError);
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public Integer getErrorSubcode() {
        return this.errorSubcode;
    }

    public Integer getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getErrorUserTitle() {
        return this.errorUserTitle;
    }

    public String getErrorUserMessage() {
        return this.errorUserMessage;
    }

    public Boolean getIsTransient() {
        return this.isTransient;
    }

    public String getFbtraceId() {
        if (this.getRawErrorJson() != null && this.getRawErrorJson().get("error").isObject()) {
            JsonObject errorJson = this.getRawErrorJson().get("error").asObject();
            return errorJson.getString("fbtrace_id", "");
        }
        return "";
    }
}

