/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.exception;

import com.restfb.exception.FacebookException;

public class FacebookNetworkException
extends FacebookException {
    private final Integer httpStatusCode;
    private static final long serialVersionUID = 1L;
    private static final String MESSAGE = "Facebook request failed";

    public FacebookNetworkException(Throwable cause) {
        this(cause, null);
    }

    public FacebookNetworkException(Integer httpStatusCode) {
        this(null, httpStatusCode);
    }

    public FacebookNetworkException(Throwable cause, Integer httpStatusCode) {
        super(String.format("A network error occurred while trying to communicate with Facebook: %s (HTTP status code %d)", MESSAGE, httpStatusCode), cause);
        this.httpStatusCode = httpStatusCode;
    }

    public Integer getHttpStatusCode() {
        return this.httpStatusCode;
    }
}

