/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.json;

import com.restfb.json.JsonValue;
import com.restfb.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

class JsonNumber
extends JsonValue {
    private final String numberStr;

    JsonNumber(String numberStr) {
        Objects.requireNonNull(numberStr, "string is null");
        this.numberStr = numberStr;
    }

    @Override
    public String toString() {
        return this.numberStr;
    }

    @Override
    void write(JsonWriter writer) throws IOException {
        writer.writeNumber(this.numberStr);
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public int asInt() {
        return Integer.parseInt(this.numberStr, 10);
    }

    @Override
    public long asLong() {
        return Long.parseLong(this.numberStr, 10);
    }

    @Override
    public float asFloat() {
        return Float.parseFloat(this.numberStr);
    }

    @Override
    public double asDouble() {
        return Double.parseDouble(this.numberStr);
    }

    @Override
    public int hashCode() {
        return this.numberStr.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JsonNumber other = (JsonNumber)object;
        return this.numberStr.equals(other.numberStr);
    }
}

