/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.json;

import com.restfb.json.JsonWriter;
import com.restfb.json.WriterConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PrettyPrint
implements WriterConfig {
    private final char[] indentChars;

    protected PrettyPrint(char[] indentChars) {
        this.indentChars = indentChars;
    }

    public static PrettyPrint singleLine() {
        return new PrettyPrint(null);
    }

    public static PrettyPrint indentWithSpaces(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("number is negative");
        }
        char[] chars = new char[number];
        Arrays.fill(chars, ' ');
        return new PrettyPrint(chars);
    }

    public static PrettyPrint indentWithTabs() {
        return new PrettyPrint(new char[]{'\t'});
    }

    @Override
    public JsonWriter createWriter(Writer writer) {
        return new PrettyPrintWriter(writer, this.indentChars);
    }

    private static class PrettyPrintWriter
    extends JsonWriter {
        private final char[] indentChars;
        private int indent;

        private PrettyPrintWriter(Writer writer, char[] indentChars) {
            super(writer);
            this.indentChars = indentChars;
        }

        @Override
        protected void writeArrayOpen() throws IOException {
            ++this.indent;
            this.writer.write(91);
            this.writeNewLine();
        }

        @Override
        protected void writeArrayClose() throws IOException {
            --this.indent;
            this.writeNewLine();
            this.writer.write(93);
        }

        @Override
        protected void writeArraySeparator() throws IOException {
            this.writeCommaSeparator();
        }

        @Override
        protected void writeObjectOpen() throws IOException {
            ++this.indent;
            this.writer.write(123);
            this.writeNewLine();
        }

        @Override
        protected void writeObjectClose() throws IOException {
            --this.indent;
            this.writeNewLine();
            this.writer.write(125);
        }

        @Override
        protected void writeMemberSeparator() throws IOException {
            this.writer.write(58);
            this.writer.write(32);
        }

        @Override
        protected void writeObjectSeparator() throws IOException {
            this.writeCommaSeparator();
        }

        protected void writeCommaSeparator() throws IOException {
            this.writer.write(44);
            if (!this.writeNewLine()) {
                this.writer.write(32);
            }
        }

        private boolean writeNewLine() throws IOException {
            if (this.indentChars == null) {
                return false;
            }
            this.writer.write(10);
            this.writer.write(Stream.generate(() -> String.valueOf(this.indentChars)).limit(this.indent).collect(Collectors.joining()));
            return true;
        }
    }
}

