/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.logging;

import com.restfb.logging.JulMessage;
import com.restfb.logging.RestFBLogger;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JulLogger
extends RestFBLogger {
    private final Logger logger;

    public JulLogger(String logName) {
        this.logger = Logger.getLogger(logName);
    }

    @Override
    public void trace(String msg, Object ... args) {
        this.createLogMessage(Level.FINER, msg, args);
    }

    @Override
    public void debug(String msg, Object ... args) {
        this.createLogMessage(Level.FINE, msg, args);
    }

    @Override
    public void info(String msg, Object ... args) {
        this.createLogMessage(Level.INFO, msg, args);
    }

    @Override
    public void warn(String msg, Object ... args) {
        this.createLogMessage(Level.WARNING, msg, args);
    }

    @Override
    public void error(String msg, Object ... args) {
        this.createLogMessage(Level.SEVERE, msg, args);
    }

    @Override
    public void fatal(String msg, Object ... args) {
        this.createLogMessage(Level.SEVERE, msg, args);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    private void createLogMessage(Level level, String msg, Object[] args) {
        if (this.logger.isLoggable(level)) {
            JulMessage.MessageTuple tuple = JulMessage.convertMessageString(msg, args);
            LogRecord logRecord = new LogRecord(level, tuple.getMessage());
            Optional.ofNullable(tuple.getThrowable()).ifPresent(logRecord::setThrown);
            logRecord.setSourceClassName(null);
            logRecord.setSourceMethodName(null);
            logRecord.setLoggerName(this.logger.getName());
            this.logger.log(logRecord);
        }
    }
}

