/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.logging;

import com.restfb.exception.FacebookLoggerException;
import com.restfb.logging.JulLogger;
import com.restfb.logging.SLF4JLogger;
import java.lang.reflect.Constructor;

public abstract class RestFBLogger {
    private static Class<? extends RestFBLogger> usedLoggerClass;
    public static final RestFBLogger HTTP_LOGGER;
    public static final RestFBLogger MAPPER_LOGGER;
    public static final RestFBLogger UTILS_LOGGER;
    public static final RestFBLogger CLIENT_LOGGER;
    public static final RestFBLogger VALUE_FACTORY_LOGGER;

    public static RestFBLogger getLoggerInstance(String logCategory) {
        RestFBLogger obj;
        Class[] ctrTypes = new Class[]{String.class};
        Object[] ctrArgs = new Object[]{logCategory};
        try {
            Constructor<? extends RestFBLogger> loggerClassConstructor = usedLoggerClass.getConstructor(ctrTypes);
            obj = loggerClassConstructor.newInstance(ctrArgs);
        }
        catch (Exception e) {
            throw new FacebookLoggerException("cannot create logger: " + logCategory);
        }
        return obj;
    }

    public abstract void trace(String var1, Object ... var2);

    public abstract void debug(String var1, Object ... var2);

    public abstract void info(String var1, Object ... var2);

    public abstract void warn(String var1, Object ... var2);

    public abstract void error(String var1, Object ... var2);

    public abstract void fatal(String var1, Object ... var2);

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isTraceEnabled();

    static {
        Class loggerClass;
        usedLoggerClass = null;
        String forceJUL = System.getProperty("com.restfb.forceJUL", "false");
        if (!Boolean.parseBoolean(forceJUL)) {
            try {
                RestFBLogger.class.getClassLoader().loadClass("org.slf4j.Logger");
                loggerClass = SLF4JLogger.class;
            }
            catch (Exception e) {
                loggerClass = JulLogger.class;
            }
        } else {
            loggerClass = JulLogger.class;
        }
        usedLoggerClass = loggerClass;
        HTTP_LOGGER = RestFBLogger.getLoggerInstance("com.restfb.HTTP");
        MAPPER_LOGGER = RestFBLogger.getLoggerInstance("com.restfb.JSON_MAPPER");
        UTILS_LOGGER = RestFBLogger.getLoggerInstance("com.restfb.UTILITY");
        CLIENT_LOGGER = RestFBLogger.getLoggerInstance("com.restfb.CLIENT");
        VALUE_FACTORY_LOGGER = RestFBLogger.getLoggerInstance("com.restfb.types.CHANGE_VALUE_FACTORY");
    }
}

