/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.annotation.GraphAPI;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.json.JsonObject;
import com.restfb.types.CategorizedFacebookType;
import com.restfb.types.Comments;
import com.restfb.types.Conversation;
import com.restfb.types.FacebookType;
import com.restfb.types.Likes;
import com.restfb.types.MessageTag;
import com.restfb.types.NamedFacebookType;
import com.restfb.types.Reactions;
import com.restfb.types.StoryAttachment;
import com.restfb.types.features.HasComments;
import com.restfb.types.features.HasCreatedTime;
import com.restfb.types.features.HasMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Comment
extends FacebookType
implements HasComments,
HasCreatedTime,
HasMessage {
    @Facebook
    private CategorizedFacebookType from;
    @Facebook
    private String message;
    @Facebook(value="created_time")
    private Date createdTime;
    @Facebook
    private Likes likes;
    @Facebook
    private Reactions reactions;
    @Facebook(value="like_count")
    private Long likeCount;
    @Facebook(value="comment_count")
    private long commentCount;
    @Facebook(value="can_remove")
    private Boolean canRemove;
    @Facebook(value="user_likes")
    private Boolean userLikes;
    @Facebook
    private Comment parent;
    @Facebook(value="can_comment")
    private Boolean canComment;
    @Facebook(value="can_hide")
    private Boolean canHide;
    @Facebook(value="can_reply_privately")
    @GraphAPI(since="2.5")
    private Boolean canReplyPrivately;
    @Facebook(value="private_reply_conversation")
    @GraphAPI(since="2.5")
    private Conversation privateReplyConversation;
    @Facebook(value="is_hidden")
    private Boolean isHidden;
    @Facebook(value="can_like")
    private Boolean canLike;
    @Facebook
    private NamedFacebookType object;
    @Facebook(value="permalink_url")
    private String permalinkUrl;
    @Facebook(value="comments")
    private Comments comments;
    @Facebook
    private StoryAttachment attachment;
    @Facebook(value="message_tags")
    private transient String rawMessageTags;
    private List<MessageTag> messageTags = new ArrayList<MessageTag>();
    private static final long serialVersionUID = 2L;

    @JsonMapper.JsonMappingCompleted
    protected void jsonMappingCompleted(JsonMapper jsonMapper) {
        if (this.rawMessageTags == null) {
            return;
        }
        try {
            this.messageTags = jsonMapper.toJavaList(this.rawMessageTags, MessageTag.class);
            return;
        }
        catch (FacebookJsonMappingException facebookJsonMappingException) {
            try {
                JsonObject rawMessageTagsObject = jsonMapper.toJavaObject(this.rawMessageTags, JsonObject.class);
                for (String key : rawMessageTagsObject.names()) {
                    String tagArrayString = rawMessageTagsObject.get(key).toString();
                    this.messageTags.addAll(jsonMapper.toJavaList(tagArrayString, MessageTag.class));
                }
            }
            catch (FacebookJsonMappingException facebookJsonMappingException2) {
                // empty catch block
            }
            return;
        }
    }

    public List<MessageTag> getMessageTags() {
        return Collections.unmodifiableList(this.messageTags);
    }

    public void addMessageTag(MessageTag messageTag) {
        this.messageTags.add(messageTag);
    }

    public void removeMessageTag(MessageTag messageTag) {
        this.messageTags.remove(messageTag);
    }

    public CategorizedFacebookType getFrom() {
        return this.from;
    }

    public void setFrom(CategorizedFacebookType from) {
        this.from = from;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Likes getLikes() {
        return this.likes;
    }

    public void setLikes(Likes likes) {
        this.likes = likes;
    }

    public Reactions getReactions() {
        return this.reactions;
    }

    public void setReactions(Reactions reactions) {
        this.reactions = reactions;
    }

    public Long getLikeCount() {
        return this.likeCount;
    }

    public void setLikeCount(Long likeCount) {
        this.likeCount = likeCount;
    }

    public long getCommentCount() {
        return this.commentCount;
    }

    public void setCommentCount(long commentCount) {
        this.commentCount = commentCount;
    }

    public Boolean getCanRemove() {
        return this.canRemove;
    }

    public void setCanRemove(Boolean canRemove) {
        this.canRemove = canRemove;
    }

    public Boolean getUserLikes() {
        return this.userLikes;
    }

    public void setUserLikes(Boolean userLikes) {
        this.userLikes = userLikes;
    }

    public Comment getParent() {
        return this.parent;
    }

    public void setParent(Comment parent) {
        this.parent = parent;
    }

    public Boolean getCanComment() {
        return this.canComment;
    }

    public void setCanComment(Boolean canComment) {
        this.canComment = canComment;
    }

    public Boolean getCanHide() {
        return this.canHide;
    }

    public void setCanHide(Boolean canHide) {
        this.canHide = canHide;
    }

    @GraphAPI(since="2.5")
    public Boolean getCanReplyPrivately() {
        return this.canReplyPrivately;
    }

    public void setCanReplyPrivately(Boolean canReplyPrivately) {
        this.canReplyPrivately = canReplyPrivately;
    }

    @GraphAPI(since="2.5")
    public Conversation getPrivateReplyConversation() {
        return this.privateReplyConversation;
    }

    public void setPrivateReplyConversation(Conversation privateReplyConversation) {
        this.privateReplyConversation = privateReplyConversation;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public void setIsHidden(Boolean isHidden) {
        this.isHidden = isHidden;
    }

    public Boolean getCanLike() {
        return this.canLike;
    }

    public void setCanLike(Boolean canLike) {
        this.canLike = canLike;
    }

    public NamedFacebookType getObject() {
        return this.object;
    }

    public void setObject(NamedFacebookType object) {
        this.object = object;
    }

    public String getPermalinkUrl() {
        return this.permalinkUrl;
    }

    public void setPermalinkUrl(String permalinkUrl) {
        this.permalinkUrl = permalinkUrl;
    }

    @Override
    public Comments getComments() {
        return this.comments;
    }

    public void setComments(Comments comments) {
        this.comments = comments;
    }

    public StoryAttachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(StoryAttachment attachment) {
        this.attachment = attachment;
    }
}

