/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.annotation.GraphAPI;
import com.restfb.types.AbstractFacebookType;
import com.restfb.types.CoverPhoto;
import com.restfb.types.Group;
import com.restfb.types.Location;
import com.restfb.types.NamedFacebookType;
import com.restfb.types.Place;
import com.restfb.types.ProfilePictureSource;
import com.restfb.types.features.HasCover;
import com.restfb.types.features.HasProfilePicture;
import com.restfb.util.DateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Event
extends NamedFacebookType
implements HasProfilePicture,
HasCover {
    @Facebook
    private Owner owner;
    @Facebook
    @GraphAPI(since="2.4")
    private String category;
    @Facebook(value="can_guests_invite")
    private Boolean canGuestsInvite;
    @Facebook(value="guest_list_enabled")
    private Boolean guestListEnabled;
    @Facebook
    private String description;
    @Facebook(value="start_time")
    private transient String rawStartTime;
    @Facebook(value="end_time")
    private transient String rawEndTime;
    private Date startTime;
    private Date endTime;
    @Facebook
    @GraphAPI(until="2.2")
    @Deprecated
    private String location;
    @Facebook(value="is_canceled")
    private Boolean isCanceled;
    @Facebook(value="rsvp_status")
    private String rsvpStatus;
    @Facebook(value="venue")
    @Deprecated
    @GraphAPI(until="2.2")
    private List<Location> venueList;
    @Facebook
    @GraphAPI(until="2.2")
    @Deprecated
    private Location venue;
    @Facebook(value="interested_count")
    @GraphAPI(since="2.1")
    private Long interestedCount;
    @Facebook(value="is_page_owned")
    private Boolean isPageOwned;
    @Deprecated
    @Facebook(value="is_viewer_admin")
    private Boolean isViewerAdmin;
    @Facebook
    private String privacy;
    @Facebook(value="updated_time")
    private Date updatedTime;
    @Facebook(value="ticket_uri")
    private String ticketUri;
    private ProfilePictureSource picture;
    @Facebook(value="picture")
    private transient String rawPicture;
    @Facebook(value="parent_group")
    private Group parentGroup;
    @Facebook
    @GraphAPI(since="2.3")
    private Place place;
    @Facebook(value="is_date_only")
    private Boolean isDateOnly;
    @Facebook
    private String timezone;
    @Facebook
    private CoverPhoto cover;
    @Facebook(value="attending_count")
    @GraphAPI(since="2.1")
    private Integer attendingCount;
    @Facebook(value="declined_count")
    @GraphAPI(since="2.1")
    private Integer declinedCount;
    @Facebook(value="maybe_count")
    @GraphAPI(since="2.1")
    private Integer maybeCount;
    @Facebook(value="noreply_count")
    @GraphAPI(since="2.1")
    private Integer noreplyCount;
    private static final long serialVersionUID = 2L;

    @JsonMapper.JsonMappingCompleted
    void convertTime() {
        Date dateEnd = DateUtils.toDateFromLongFormat(this.rawEndTime);
        this.endTime = dateEnd == null ? DateUtils.toDateFromShortFormat(this.rawEndTime) : dateEnd;
        Date dateStart = DateUtils.toDateFromLongFormat(this.rawStartTime);
        this.startTime = dateStart == null ? DateUtils.toDateFromShortFormat(this.rawStartTime) : dateStart;
    }

    @JsonMapper.JsonMappingCompleted
    protected void fillProfilePicture(JsonMapper jsonMapper) {
        this.picture = this.convertPicture(jsonMapper, this.rawPicture);
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    @GraphAPI(since="2.4")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Boolean getCanGuestsInvite() {
        return this.canGuestsInvite;
    }

    public void setCanGuestsInvite(Boolean canGuestsInvite) {
        this.canGuestsInvite = canGuestsInvite;
    }

    public Boolean getGuestListEnabled() {
        return this.guestListEnabled;
    }

    public void setGuestListEnabled(Boolean guestListEnabled) {
        this.guestListEnabled = guestListEnabled;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Deprecated
    @GraphAPI(until="2.2")
    public String getLocation() {
        return this.location;
    }

    @Deprecated
    public void setLocation(String location) {
        this.location = location;
    }

    public Boolean getIsCanceled() {
        return this.isCanceled;
    }

    public void setIsCanceled(Boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public String getRsvpStatus() {
        return this.rsvpStatus;
    }

    public void setRsvpStatus(String rsvpStatus) {
        this.rsvpStatus = rsvpStatus;
    }

    @Deprecated
    @GraphAPI(until="2.2")
    public List<Location> getVenueList() {
        return this.venueList;
    }

    @Deprecated
    public void setVenueList(List<Location> venueList) {
        this.venueList = venueList;
    }

    @Deprecated
    @GraphAPI(until="2.2")
    public Location getVenue() {
        return this.venue;
    }

    @Deprecated
    public void setVenue(Location venue) {
        this.venue = venue;
    }

    @GraphAPI(since="2.1")
    public Long getInterestedCount() {
        return this.interestedCount;
    }

    public void setInterestedCount(Long interestedCount) {
        this.interestedCount = interestedCount;
    }

    public Boolean getIsPageOwned() {
        return this.isPageOwned;
    }

    public void setIsPageOwned(Boolean isPageOwned) {
        this.isPageOwned = isPageOwned;
    }

    @Deprecated
    public Boolean getIsViewerAdmin() {
        return this.isViewerAdmin;
    }

    @Deprecated
    public void setIsViewerAdmin(Boolean isViewerAdmin) {
        this.isViewerAdmin = isViewerAdmin;
    }

    public String getPrivacy() {
        return this.privacy;
    }

    public void setPrivacy(String privacy) {
        this.privacy = privacy;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Date updatedTime) {
        this.updatedTime = updatedTime;
    }

    public String getTicketUri() {
        return this.ticketUri;
    }

    public void setTicketUri(String ticketUri) {
        this.ticketUri = ticketUri;
    }

    @Override
    public ProfilePictureSource getPicture() {
        return this.picture;
    }

    public void setPicture(ProfilePictureSource picture) {
        this.picture = picture;
    }

    public Group getParentGroup() {
        return this.parentGroup;
    }

    public void setParentGroup(Group parentGroup) {
        this.parentGroup = parentGroup;
    }

    @GraphAPI(since="2.3")
    public Place getPlace() {
        return this.place;
    }

    public void setPlace(Place place) {
        this.place = place;
    }

    public Boolean getIsDateOnly() {
        return this.isDateOnly;
    }

    public void setIsDateOnly(Boolean isDateOnly) {
        this.isDateOnly = isDateOnly;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Override
    public CoverPhoto getCover() {
        return this.cover;
    }

    public void setCover(CoverPhoto cover) {
        this.cover = cover;
    }

    @GraphAPI(since="2.1")
    public Integer getAttendingCount() {
        return this.attendingCount;
    }

    public void setAttendingCount(Integer attendingCount) {
        this.attendingCount = attendingCount;
    }

    @GraphAPI(since="2.1")
    public Integer getDeclinedCount() {
        return this.declinedCount;
    }

    public void setDeclinedCount(Integer declinedCount) {
        this.declinedCount = declinedCount;
    }

    @GraphAPI(since="2.1")
    public Integer getMaybeCount() {
        return this.maybeCount;
    }

    public void setMaybeCount(Integer maybeCount) {
        this.maybeCount = maybeCount;
    }

    @GraphAPI(since="2.1")
    public Integer getNoreplyCount() {
        return this.noreplyCount;
    }

    public void setNoreplyCount(Integer noreplyCount) {
        this.noreplyCount = noreplyCount;
    }

    public static class Owner
    extends AbstractFacebookType {
        @Facebook
        private String id;
        @Facebook
        private String name;
        @Facebook
        private String category;
        @Facebook(value="category_list")
        private List<Category> categoryList = new ArrayList<Category>();
        private static final long serialVersionUID = 1L;

        public boolean addCategory(Category category) {
            return this.categoryList.add(category);
        }

        public boolean removeCategory(Category category) {
            return this.categoryList.remove(category);
        }

        public List<Category> getCategoryList() {
            return Collections.unmodifiableList(this.categoryList);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }
    }

    public static class Category
    extends AbstractFacebookType {
        @Facebook
        private String id;
        @Facebook
        private String name;
        private static final long serialVersionUID = 1L;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

