/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.json.Json;
import com.restfb.json.JsonObject;
import com.restfb.types.AbstractFacebookType;
import com.restfb.types.NamedFacebookType;
import com.restfb.types.features.HasCreatedTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Likes
extends AbstractFacebookType {
    @Facebook
    private Long totalCount = 0L;
    private Boolean canLike;
    private Boolean hasLiked;
    @Facebook(value="can_like")
    private Boolean openGraphCanLike;
    @Facebook(value="user_likes")
    private Boolean openGraphUserLikes;
    @Facebook(value="count")
    private Long openGraphCount = 0L;
    @Facebook
    private String summary;
    @Facebook
    private List<LikeItem> data = new ArrayList<LikeItem>();
    private static final long serialVersionUID = 1L;

    public List<LikeItem> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public boolean addData(LikeItem like) {
        return this.data.add(like);
    }

    public boolean removeData(LikeItem like) {
        return this.data.remove(like);
    }

    @JsonMapper.JsonMappingCompleted
    private void fillFields() {
        JsonObject summaryObject = null;
        if (this.summary != null) {
            summaryObject = Json.parse(this.summary).asObject();
        }
        this.fillTotalCount(summaryObject);
        this.fillHasLiked(summaryObject);
        this.fillCanLike(summaryObject);
    }

    private void fillTotalCount(JsonObject summary) {
        if (this.totalCount == 0L && summary != null && summary.get("total_count") != null) {
            this.totalCount = summary.getLong("total_count", this.totalCount);
        }
        if (this.openGraphCount != 0L) {
            this.totalCount = this.openGraphCount;
        }
    }

    private void fillHasLiked(JsonObject summary) {
        if (summary != null && summary.get("has_liked") != null) {
            this.hasLiked = summary.get("has_liked").asBoolean();
        }
        if (this.hasLiked == null && this.openGraphUserLikes != null) {
            this.hasLiked = this.openGraphUserLikes;
        }
    }

    private void fillCanLike(JsonObject summary) {
        if (summary != null && summary.get("can_like") != null) {
            this.canLike = summary.get("can_like").asBoolean();
        }
        if (this.canLike == null && this.openGraphCanLike != null) {
            this.canLike = this.openGraphCanLike;
        }
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public Boolean getCanLike() {
        return this.canLike;
    }

    public void setCanLike(Boolean canLike) {
        this.canLike = canLike;
    }

    public Boolean getHasLiked() {
        return this.hasLiked;
    }

    public void setHasLiked(Boolean hasLiked) {
        this.hasLiked = hasLiked;
    }

    public static class LikeItem
    extends NamedFacebookType
    implements HasCreatedTime {
        @Facebook(value="created_time")
        private Date createdTime;

        @Override
        public Date getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(Date createdTime) {
            this.createdTime = createdTime;
        }
    }
}

