/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.json.Json;
import com.restfb.json.JsonObject;
import com.restfb.types.Application;
import com.restfb.types.Comments;
import com.restfb.types.FacebookType;
import com.restfb.types.Likes;
import com.restfb.types.NamedFacebookType;
import com.restfb.types.Place;
import com.restfb.types.RecommendationType;
import com.restfb.types.features.HasComments;
import com.restfb.types.features.HasFrom;
import com.restfb.types.features.HasMessage;
import java.util.Date;

public class PageRating
extends FacebookType
implements HasComments,
HasFrom,
HasMessage {
    private static final long serialVersionUID = 1L;
    @Facebook(value="start_time")
    private Date startTime;
    @Facebook(value="publish_time")
    private Date publishTime;
    @Facebook
    private NamedFacebookType from;
    @Facebook
    private String message;
    @Facebook
    private Application application;
    @Facebook(value="no_feed_story")
    private Boolean noFeedStory;
    @Facebook
    private Comments comments;
    @Facebook
    private Likes likes;
    @Facebook
    private String data;
    private Double ratingValue;
    private Long ratingScale;
    private String reviewText;
    private Boolean isDraft;
    private String language;
    private Place place;
    private RecommendationType recommendationType;

    public boolean isRecommendation() {
        return this.ratingValue == null;
    }

    @JsonMapper.JsonMappingCompleted
    void fillAdditionalValues(JsonMapper mapper) {
        if (this.data != null) {
            JsonObject rating;
            JsonObject dataObject = Json.parse(this.data).asObject();
            if (dataObject.get("rating") != null && (rating = dataObject.get("rating").asObject()) != null) {
                this.ratingValue = rating.get("value").asDouble();
                this.ratingScale = rating.get("scale").asLong();
            }
            if (dataObject.get("language") != null) {
                this.language = dataObject.get("language").asString();
            }
            if (dataObject.get("is_draft") != null) {
                this.isDraft = dataObject.get("is_draft").asBoolean();
            }
            if (dataObject.get("review_text") != null) {
                this.reviewText = dataObject.get("review_text").asString();
            }
            if (dataObject.get("generic_place") != null) {
                this.place = mapper.toJavaObject(dataObject.get("generic_place").toString(), Place.class);
            } else if (dataObject.get("seller") != null) {
                this.place = mapper.toJavaObject(dataObject.get("seller").toString(), Place.class);
            }
            if (dataObject.get("recommendation_type") != null) {
                try {
                    String typeString = dataObject.get("recommendation_type").asString();
                    this.recommendationType = RecommendationType.valueOf(typeString.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getPublishTime() {
        return this.publishTime;
    }

    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    @Override
    public NamedFacebookType getFrom() {
        return this.from;
    }

    public void setFrom(NamedFacebookType from) {
        this.from = from;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Boolean getNoFeedStory() {
        return this.noFeedStory;
    }

    public void setNoFeedStory(Boolean noFeedStory) {
        this.noFeedStory = noFeedStory;
    }

    @Override
    public Comments getComments() {
        return this.comments;
    }

    public void setComments(Comments comments) {
        this.comments = comments;
    }

    public Likes getLikes() {
        return this.likes;
    }

    public void setLikes(Likes likes) {
        this.likes = likes;
    }

    public Double getRatingValue() {
        return this.ratingValue;
    }

    public void setRatingValue(Double ratingValue) {
        this.ratingValue = ratingValue;
    }

    public Long getRatingScale() {
        return this.ratingScale;
    }

    public void setRatingScale(Long ratingScale) {
        this.ratingScale = ratingScale;
    }

    public String getReviewText() {
        return this.reviewText;
    }

    public void setReviewText(String reviewText) {
        this.reviewText = reviewText;
    }

    public Boolean getIsDraft() {
        return this.isDraft;
    }

    public void setIsDraft(Boolean isDraft) {
        this.isDraft = isDraft;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public Place getPlace() {
        return this.place;
    }

    public void setPlace(Place place) {
        this.place = place;
    }

    public RecommendationType getRecommendationType() {
        return this.recommendationType;
    }

    public void setRecommendationType(RecommendationType recommendationType) {
        this.recommendationType = recommendationType;
    }
}

