/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.annotation.GraphAPI;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.json.JsonObject;
import com.restfb.types.AbstractFacebookType;
import com.restfb.types.Album;
import com.restfb.types.CategorizedFacebookType;
import com.restfb.types.Comments;
import com.restfb.types.EntityAtTextRange;
import com.restfb.types.Event;
import com.restfb.types.Likes;
import com.restfb.types.NamedFacebookType;
import com.restfb.types.Place;
import com.restfb.types.Reactions;
import com.restfb.types.features.HasComments;
import com.restfb.types.features.HasCreatedTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Photo
extends NamedFacebookType
implements HasComments,
HasCreatedTime {
    @Facebook
    private CategorizedFacebookType from;
    @Facebook
    private String picture;
    @Facebook(value="page_story_id")
    private String pageStoryId;
    @Facebook
    private Reactions reactions;
    @Facebook
    @Deprecated
    private String source;
    @Facebook
    private Integer height;
    @Facebook
    private Integer width;
    @Facebook
    private String link;
    @Facebook
    private String icon;
    @Facebook
    private Album album;
    @Facebook(value="can_delete")
    private Boolean canDelete;
    @Facebook(value="can_tag")
    private Boolean canTag;
    @Deprecated
    @Facebook
    private Integer position;
    @Facebook
    @GraphAPI(since="2.3")
    private Event event;
    @Facebook(value="updated_time")
    private Date updatedTime;
    @Facebook(value="created_time")
    private Date createdTime;
    @Facebook
    private Comments comments;
    @Facebook
    private List<Tag> tags = new ArrayList<Tag>();
    @Facebook
    private Likes likes;
    @Facebook
    private List<Image> images = new ArrayList<Image>();
    @Facebook(value="name_tags")
    private transient String rawNameTags;
    private List<EntityAtTextRange> nameTags = new ArrayList<EntityAtTextRange>();
    @Facebook
    private Place place;
    @Facebook(value="backdated_time")
    private Date backdatedTime;
    @Facebook(value="backdated_time_granularity")
    private String backdatedTimeGranularity;
    private static final long serialVersionUID = 1L;

    public List<Tag> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    public boolean addTag(Tag tag) {
        return this.tags.add(tag);
    }

    public boolean removeTag(Tag tag) {
        return this.tags.remove(tag);
    }

    public List<EntityAtTextRange> getNameTags() {
        return Collections.unmodifiableList(this.nameTags);
    }

    public boolean addNameTag(EntityAtTextRange nameTag) {
        return this.nameTags.add(nameTag);
    }

    public boolean removeNameTag(EntityAtTextRange nameTag) {
        return this.nameTags.remove(nameTag);
    }

    public List<Image> getImages() {
        return Collections.unmodifiableList(this.images);
    }

    public boolean addImage(Image image) {
        return this.images.add(image);
    }

    public boolean removeImage(Image image) {
        return this.images.remove(image);
    }

    @JsonMapper.JsonMappingCompleted
    protected void jsonMappingCompleted(JsonMapper jsonMapper) {
        if (this.rawNameTags == null) {
            return;
        }
        try {
            this.nameTags = jsonMapper.toJavaList(this.rawNameTags, EntityAtTextRange.class);
            return;
        }
        catch (FacebookJsonMappingException facebookJsonMappingException) {
            try {
                JsonObject rawMessageTagsObject = jsonMapper.toJavaObject(this.rawNameTags, JsonObject.class);
                for (String key : rawMessageTagsObject.names()) {
                    String tagArrayString = rawMessageTagsObject.get(key).toString();
                    this.nameTags.addAll(jsonMapper.toJavaList(tagArrayString, EntityAtTextRange.class));
                }
            }
            catch (FacebookJsonMappingException facebookJsonMappingException2) {
                // empty catch block
            }
            return;
        }
    }

    public CategorizedFacebookType getFrom() {
        return this.from;
    }

    public void setFrom(CategorizedFacebookType from) {
        this.from = from;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getPageStoryId() {
        return this.pageStoryId;
    }

    public void setPageStoryId(String pageStoryId) {
        this.pageStoryId = pageStoryId;
    }

    public Reactions getReactions() {
        return this.reactions;
    }

    public void setReactions(Reactions reactions) {
        this.reactions = reactions;
    }

    @Deprecated
    public String getSource() {
        return this.source;
    }

    @Deprecated
    public void setSource(String source) {
        this.source = source;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Album getAlbum() {
        return this.album;
    }

    public void setAlbum(Album album) {
        this.album = album;
    }

    public Boolean getCanDelete() {
        return this.canDelete;
    }

    public void setCanDelete(Boolean canDelete) {
        this.canDelete = canDelete;
    }

    public Boolean getCanTag() {
        return this.canTag;
    }

    public void setCanTag(Boolean canTag) {
        this.canTag = canTag;
    }

    @Deprecated
    public Integer getPosition() {
        return this.position;
    }

    @Deprecated
    public void setPosition(Integer position) {
        this.position = position;
    }

    @GraphAPI(since="2.3")
    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Date updatedTime) {
        this.updatedTime = updatedTime;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    @Override
    public Comments getComments() {
        return this.comments;
    }

    public void setComments(Comments comments) {
        this.comments = comments;
    }

    public Likes getLikes() {
        return this.likes;
    }

    public void setLikes(Likes likes) {
        this.likes = likes;
    }

    public Place getPlace() {
        return this.place;
    }

    public void setPlace(Place place) {
        this.place = place;
    }

    public Date getBackdatedTime() {
        return this.backdatedTime;
    }

    public void setBackdatedTime(Date backdatedTime) {
        this.backdatedTime = backdatedTime;
    }

    public String getBackdatedTimeGranularity() {
        return this.backdatedTimeGranularity;
    }

    public void setBackdatedTimeGranularity(String backdatedTimeGranularity) {
        this.backdatedTimeGranularity = backdatedTimeGranularity;
    }

    public static class Image
    extends AbstractFacebookType {
        @Facebook
        private Integer height;
        @Facebook
        private Integer width;
        @Facebook
        private String source;
        private static final long serialVersionUID = 1L;

        public Integer getHeight() {
            return this.height;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }

        public Integer getWidth() {
            return this.width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }
    }

    public static class Tag
    extends NamedFacebookType
    implements HasCreatedTime {
        @Facebook
        private Double x;
        @Facebook
        private Double y;
        @Facebook(value="created_time")
        private Date createdTime;
        private static final long serialVersionUID = 1L;

        public Double getX() {
            return this.x;
        }

        public void setX(Double x) {
            this.x = x;
        }

        public Double getY() {
            return this.y;
        }

        public void setY(Double y) {
            this.y = y;
        }

        @Override
        public Date getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(Date createdTime) {
            this.createdTime = createdTime;
        }
    }
}

