/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.Version;
import com.restfb.types.AbstractFacebookType;
import java.util.List;
import java.util.stream.Collectors;

public class Subscription
extends AbstractFacebookType {
    private static final long serialVersionUID = 1L;
    @Facebook
    private String object;
    @Facebook(value="callback_url")
    private String callbackUrl;
    @Facebook
    private List<SubscriptionField> fields;
    @Facebook(value="fields")
    private List<String> compatFields;
    @Facebook
    private Boolean active;

    @JsonMapper.JsonMappingCompleted
    private void convertCompatFields() {
        if (this.compatFields != null && this.fields == null) {
            this.fields = this.compatFields.stream().map(x$0 -> new SubscriptionField((String)x$0)).collect(Collectors.toList());
        }
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public List<SubscriptionField> getFields() {
        return this.fields;
    }

    public void setFields(List<SubscriptionField> fields) {
        this.fields = fields;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public static class SubscriptionField
    extends AbstractFacebookType {
        private static final long serialVersionUID = 1L;
        @Facebook
        private String name;
        private Version version;
        @Facebook(value="version")
        private String versionAsString;

        public SubscriptionField() {
        }

        private SubscriptionField(String name) {
            this.name = name;
            this.version = Version.UNVERSIONED;
        }

        @JsonMapper.JsonMappingCompleted
        public void convertVersion() {
            this.version = Version.getVersionFromString(this.versionAsString);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Version getVersion() {
            return this.version;
        }

        public void setVersion(Version version) {
            this.version = version;
        }
    }
}

