/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types.ads;

import com.restfb.json.JsonArray;
import com.restfb.json.JsonObject;
import com.restfb.json.JsonValue;
import com.restfb.types.ads.Rule;
import com.restfb.types.ads.RuleData;
import com.restfb.types.ads.RuleOp;
import com.restfb.types.ads.RuleOpAnd;
import com.restfb.types.ads.RuleOpOr;
import java.util.List;

public class RuleFactory {
    public static JsonObject createJsonFromRule(Rule rule) {
        if (rule == null) {
            return null;
        }
        JsonObject result = new JsonObject();
        if (rule instanceof RuleOpAnd) {
            RuleOpAnd ruleOpAnd = (RuleOpAnd)rule;
            List<Rule> ruleList = ruleOpAnd.getRuleList();
            JsonArray jsonValues = new JsonArray();
            for (Rule ruleListItem : ruleList) {
                JsonObject obj = RuleFactory.createJsonFromRule(ruleListItem);
                if (obj == null) continue;
                jsonValues.add(obj);
            }
            result.add(ruleOpAnd.getType(), jsonValues);
            return result;
        }
        if (rule instanceof RuleOpOr) {
            RuleOpOr ruleOpOr = (RuleOpOr)rule;
            List<Rule> ruleList = ruleOpOr.getRuleList();
            JsonArray jsonValues = new JsonArray();
            for (Rule ruleListItem : ruleList) {
                JsonObject obj = RuleFactory.createJsonFromRule(ruleListItem);
                if (obj == null) continue;
                jsonValues.add(obj);
            }
            result.add(ruleOpOr.getType(), jsonValues);
            return result;
        }
        if (rule instanceof RuleData) {
            RuleData ruleData = (RuleData)rule;
            result.add(ruleData.getType(), RuleFactory.createJsonFromRule(ruleData.getOperator()));
            return result;
        }
        if (rule instanceof RuleOp) {
            RuleOp ruleOp = (RuleOp)rule;
            result.add(ruleOp.getType(), ruleOp.getValue());
            return result;
        }
        if (result.names().isEmpty()) {
            throw new IllegalArgumentException("unknown rule found");
        }
        return result;
    }

    public static Rule createRuleFromJson(JsonObject ruleJson) {
        if (ruleJson == null) {
            return null;
        }
        if (ruleJson.names().size() > 1) {
            throw new IllegalArgumentException("only one key is supported, found " + ruleJson.names().size());
        }
        String key = ruleJson.names().get(0);
        if (RuleFactory.isCreateData(key)) {
            return RuleFactory.createRuleData(ruleJson, key);
        }
        if (RuleFactory.isCreateSimpleOperator(key)) {
            return RuleFactory.createRuleOperator(ruleJson, key);
        }
        if ("and".equals(key)) {
            JsonValue andList = ruleJson.get(key);
            RuleOpAnd rOp = new RuleOpAnd(key);
            if (andList.isArray()) {
                for (JsonValue item : andList.asArray()) {
                    Rule r = RuleFactory.createRuleFromJson(item.asObject());
                    rOp.getRuleList().add(r);
                }
            }
            return rOp;
        }
        if ("or".equals(key)) {
            JsonValue andList = ruleJson.get(key);
            RuleOpOr rOp = new RuleOpOr(key);
            if (andList.isArray()) {
                for (JsonValue item : andList.asArray()) {
                    Rule r = RuleFactory.createRuleFromJson(item.asObject());
                    rOp.getRuleList().add(r);
                }
            }
            return rOp;
        }
        return RuleFactory.createRuleData(ruleJson, key);
    }

    private static boolean isCreateData(String key) {
        return "url".equals(key) || "event".equals(key) || "path".equals(key) || "domain".equals(key) || "device_type".equals(key);
    }

    private static boolean isCreateSimpleOperator(String key) {
        return "i_contains".equals(key) || "contains".equals(key) || "i_not_contains".equals(key) || "not_contains".equals(key) || "gte".equals(key) || "gt".equals(key) || "lte".equals(key) || "lt".equals(key) || "neq".equals(key) || "eq".equals(key) || "regex_match".equals(key);
    }

    private static Rule createRuleData(JsonObject ruleJson, String key) {
        RuleData rData = new RuleData(key);
        rData.setOperator((RuleOp)RuleFactory.createRuleFromJson(ruleJson.get(key).asObject()));
        return rData;
    }

    private static Rule createRuleOperator(JsonObject ruleJson, String key) {
        RuleOp rOp = new RuleOp(key);
        if (ruleJson.get(key).isString()) {
            rOp.setValue(ruleJson.get(key).asString());
        } else {
            rOp.setValue(ruleJson.get(key).toString());
        }
        return rOp;
    }
}

