/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types.send;

import com.restfb.Facebook;
import com.restfb.exception.FacebookPreconditionException;
import com.restfb.types.AbstractFacebookType;
import com.restfb.types.send.AbstractButton;
import com.restfb.types.send.DefaultAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListViewElement
extends AbstractFacebookType {
    @Facebook
    private String title;
    @Facebook
    private String subtitle;
    @Facebook(value="image_url")
    private String imageUrl;
    @Facebook(value="default_action")
    private DefaultAction defaultAction;
    @Facebook
    private List<AbstractButton> buttons;

    public ListViewElement(String title) {
        this.title = title;
    }

    public boolean addButton(AbstractButton button) {
        if (this.buttons == null) {
            this.buttons = new ArrayList<AbstractButton>();
        }
        if (this.buttons.size() == 1) {
            throw new FacebookPreconditionException("maximum of associated buttons is 1");
        }
        return this.buttons.add(button);
    }

    public List<AbstractButton> getButtons() {
        if (this.buttons == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.buttons);
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public DefaultAction getDefaultAction() {
        return this.defaultAction;
    }

    public void setDefaultAction(DefaultAction defaultAction) {
        this.defaultAction = defaultAction;
    }
}

