/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types.send;

import com.restfb.Facebook;
import com.restfb.exception.FacebookPreconditionException;
import com.restfb.types.AbstractFacebookType;
import com.restfb.types.send.MessageAttachment;
import com.restfb.types.send.QuickReply;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Message
extends AbstractFacebookType {
    private static final int QUICK_REPLY_ITEM_LIMIT = 13;
    @Facebook
    private String text;
    @Facebook(value="quick_replies")
    private List<QuickReply> quickReplies;
    @Facebook
    private String metadata;
    @Facebook
    private MessageAttachment attachment;

    public Message(String text) {
        this.text = text;
    }

    public Message(MessageAttachment attachment) {
        this.attachment = attachment;
    }

    public boolean addQuickReply(QuickReply quickReply) {
        if (this.quickReplies == null) {
            this.quickReplies = new ArrayList<QuickReply>();
        }
        this.checkPrecondition(1);
        return this.quickReplies.add(quickReply);
    }

    public boolean addQuickReplies(List<QuickReply> quickReplyList) {
        if (this.quickReplies == null) {
            this.quickReplies = new ArrayList<QuickReply>();
        }
        this.checkPrecondition(quickReplyList.size());
        return this.quickReplies.addAll(quickReplyList);
    }

    public List<QuickReply> getQuickReplies() {
        if (this.quickReplies == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.quickReplies);
    }

    private void checkPrecondition(int addingRepliesSize) {
        if (this.quickReplies.size() + addingRepliesSize > 13) {
            String message = "You cannot have more than 13 replies in one message, current size/try adding: " + this.quickReplies.size() + "/" + addingRepliesSize;
            throw new FacebookPreconditionException(message);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public MessageAttachment getAttachment() {
        return this.attachment;
    }
}

