/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types.webhook;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.types.webhook.ChangeValue;
import com.restfb.types.webhook.ChangeValueFactory;
import com.restfb.types.webhook.PermissionChangeValue;
import com.restfb.types.webhook.messaging.UserVerbValue;

public class Change {
    @Facebook
    private String field;
    private ChangeValue value = null;
    @Facebook(value="verb")
    private ChangeValue.Verb userObjectVerb = null;
    @Facebook(value="value")
    private String rawValue;

    @JsonMapper.JsonMappingCompleted
    private void convertChangeValue(JsonMapper mapper) {
        if (this.rawValue != null) {
            ChangeValueFactory factory = new ChangeValueFactory().setField(this.field).setUserObjectVerb(this.userObjectVerb).setValue(this.rawValue);
            this.value = factory.buildWithMapper(mapper);
            if (this.value instanceof UserVerbValue && this.userObjectVerb != null) {
                ((UserVerbValue)this.value).setVerb(this.userObjectVerb);
            }
        } else if (this.userObjectVerb == ChangeValue.Verb.GRANTED || this.userObjectVerb == ChangeValue.Verb.REVOKED) {
            PermissionChangeValue pcv = new PermissionChangeValue();
            pcv.setVerb(this.userObjectVerb);
            pcv.setVerbAsString(this.userObjectVerb.name().toLowerCase());
            this.value = pcv;
        }
    }

    public String toString() {
        return "Change(field=" + this.getField() + ", value=" + this.getValue() + ", userObjectVerb=" + (Object)((Object)this.userObjectVerb) + ", rawValue=" + this.rawValue + ")";
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public ChangeValue getValue() {
        return this.value;
    }

    public void setValue(ChangeValue value) {
        this.value = value;
    }
}

