/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types.webhook;

import com.restfb.JsonMapper;
import com.restfb.json.Json;
import com.restfb.json.JsonObject;
import com.restfb.json.JsonValue;
import com.restfb.logging.RestFBLogger;
import com.restfb.types.webhook.ChangeValue;
import com.restfb.types.webhook.FallBackChangeValue;
import com.restfb.types.webhook.FeedAlbumAddValue;
import com.restfb.types.webhook.FeedAlbumEditedValue;
import com.restfb.types.webhook.FeedCommentValue;
import com.restfb.types.webhook.FeedEventValue;
import com.restfb.types.webhook.FeedLikeValue;
import com.restfb.types.webhook.FeedPhotoAddValue;
import com.restfb.types.webhook.FeedPhotoRemoveValue;
import com.restfb.types.webhook.FeedPostValue;
import com.restfb.types.webhook.FeedReactionValue;
import com.restfb.types.webhook.FeedShareValue;
import com.restfb.types.webhook.FeedStatusValue;
import com.restfb.types.webhook.FeedVideoBlockMute;
import com.restfb.types.webhook.FeedVideoRemoveValue;
import com.restfb.types.webhook.FeedVideoValue;
import com.restfb.types.webhook.ListJsonChangeValue;
import com.restfb.types.webhook.MentionPostAddValue;
import com.restfb.types.webhook.PageConversation;
import com.restfb.types.webhook.PageLeadgen;
import com.restfb.types.webhook.PermissionChangeValue;
import com.restfb.types.webhook.RatingsCommentValue;
import com.restfb.types.webhook.RatingsLikeValue;
import com.restfb.types.webhook.RatingsRatingValue;
import com.restfb.types.webhook.RatingsReactionValue;
import com.restfb.types.webhook.SimpleStringChangeValue;
import com.restfb.types.webhook.UserPageValue;
import com.restfb.types.webhook.instagram.InstagramCommentsValue;
import com.restfb.types.webhook.instagram.InstagramMentionsValue;
import com.restfb.types.webhook.instagram.InstagramStoryInsightsValue;

public class ChangeValueFactory {
    private String field;
    private JsonValue value;
    private ChangeValue.Verb userObjectVerb;

    public ChangeValueFactory setField(String field) {
        this.field = field;
        return this;
    }

    public ChangeValueFactory setValue(String value) {
        this.value = value != null && (value.startsWith("{") || value.startsWith("[")) ? Json.parse(value) : Json.value(value);
        return this;
    }

    public ChangeValueFactory setUserObjectVerb(ChangeValue.Verb userObjectVerb) {
        this.userObjectVerb = userObjectVerb;
        return this;
    }

    public ChangeValue buildWithMapper(JsonMapper mapper) {
        JsonObject objValue;
        if (this.value.isString()) {
            return new SimpleStringChangeValue(this.value.asString());
        }
        if (this.value.isArray()) {
            return new ListJsonChangeValue(this.value.asArray().values());
        }
        if (this.value.isObject() && (objValue = this.value.asObject()) != null && this.field != null) {
            String verbString;
            String classDefinition = this.field.toUpperCase();
            if (objValue.get("item") != null) {
                classDefinition = classDefinition + "_" + objValue.get("item").asString().toUpperCase();
            }
            if (objValue.get("verb") != null) {
                classDefinition = classDefinition + "_" + objValue.get("verb").asString().toUpperCase();
            }
            if (this.userObjectVerb != null) {
                classDefinition = classDefinition + "_" + this.userObjectVerb.name();
            }
            String string = verbString = objValue.get("verb") != null && objValue.get("verb").isString() ? objValue.get("verb").asString() : "";
            if (verbString.equals("granted") || verbString.equals("revoked")) {
                classDefinition = verbString.toUpperCase();
            }
            try {
                ChangeValueEnumeration changeValueEnum = ChangeValueEnumeration.valueOf(classDefinition);
                return mapper.toJavaObject(objValue.toString(), changeValueEnum.getValueClass());
            }
            catch (IllegalArgumentException iae) {
                RestFBLogger.VALUE_FACTORY_LOGGER.warn("undefined change value detected: {}", classDefinition);
                RestFBLogger.VALUE_FACTORY_LOGGER.warn("please provide this information to the restfb team: {}", objValue.toString());
                return new FallBackChangeValue(objValue);
            }
        }
        return null;
    }

    static enum ChangeValueEnumeration {
        FEED_ALBUM_ADD(FeedAlbumAddValue.class),
        FEED_ALBUM_EDITED(FeedAlbumEditedValue.class),
        FEED_COMMENT_ADD(FeedCommentValue.class),
        FEED_COMMENT_EDITED(FeedCommentValue.class),
        FEED_COMMENT_REMOVE(FeedCommentValue.class),
        FEED_COMMENT_HIDE(FeedCommentValue.class),
        FEED_COMMENT_UNHIDE(FeedCommentValue.class),
        FEED_EVENT_ADD(FeedEventValue.class),
        FEED_PHOTO_ADD(FeedPhotoAddValue.class),
        FEED_PHOTO_REMOVE(FeedPhotoRemoveValue.class),
        FEED_PHOTO_EDITED(FeedPhotoAddValue.class),
        FEED_PHOTO_HIDE(FeedPhotoAddValue.class),
        FEED_PHOTO_UNHIDE(FeedPhotoAddValue.class),
        FEED_VIDEO_ADD(FeedVideoValue.class),
        FEED_VIDEO_EDITED(FeedVideoValue.class),
        FEED_VIDEO_HIDE(FeedVideoValue.class),
        FEED_VIDEO_UNHIDE(FeedVideoValue.class),
        FEED_VIDEO_REMOVE(FeedVideoRemoveValue.class),
        FEED_VIDEO_UNBLOCK(FeedVideoBlockMute.class),
        FEED_VIDEO_BLOCK(FeedVideoBlockMute.class),
        FEED_VIDEO_MUTE(FeedVideoBlockMute.class),
        FEED_STATUS_ADD(FeedStatusValue.class),
        FEED_STATUS_EDITED(FeedStatusValue.class),
        FEED_STATUS_HIDE(FeedStatusValue.class),
        FEED_STATUS_UNHIDE(FeedStatusValue.class),
        FEED_POST_ADD(FeedPostValue.class),
        FEED_POST_EDITED(FeedPostValue.class),
        FEED_POST_EDIT(FeedPostValue.class),
        FEED_POST_HIDE(FeedPostValue.class),
        FEED_POST_REMOVE(FeedPostValue.class),
        FEED_POST_UNHIDE(FeedPostValue.class),
        FEED_REACTION_ADD(FeedReactionValue.class),
        FEED_REACTION_EDIT(FeedReactionValue.class),
        FEED_REACTION_REMOVE(FeedReactionValue.class),
        FEED_SHARE_ADD(FeedShareValue.class),
        FEED_SHARE_EDITED(FeedShareValue.class),
        FEED_SHARE_HIDE(FeedShareValue.class),
        FEED_SHARE_REMOVE(FeedShareValue.class),
        FEED_SHARE_UNHIDE(FeedShareValue.class),
        FEED_LIKE_ADD(FeedLikeValue.class),
        FEED_LIKE_REMOVE(FeedLikeValue.class),
        MENTION_POST_ADD(MentionPostAddValue.class),
        RATINGS_RATING_ADD(RatingsRatingValue.class),
        RATINGS_RATING_EDIT(RatingsRatingValue.class),
        RATINGS_RATING_REMOVE(RatingsRatingValue.class),
        RATINGS_COMMENT_ADD(RatingsCommentValue.class),
        RATINGS_COMMENT_EDITED(RatingsCommentValue.class),
        RATINGS_COMMENT_REMOVE(RatingsCommentValue.class),
        RATINGS_LIKE_ADD(RatingsLikeValue.class),
        RATINGS_LIKE_REMOVE(RatingsLikeValue.class),
        RATINGS_REACTION_ADD(RatingsReactionValue.class),
        RATINGS_REACTION_REMOVE(RatingsReactionValue.class),
        RATINGS_REACTION_EDIT(RatingsReactionValue.class),
        CONVERSATIONS(PageConversation.class),
        LEADGEN(PageLeadgen.class),
        STORY_INSIGHTS(InstagramStoryInsightsValue.class),
        MENTIONS(InstagramMentionsValue.class),
        COMMENTS(InstagramCommentsValue.class),
        HOMETOWN_ADD(UserPageValue.class),
        MOVIES_ADD(UserPageValue.class),
        LIKES_ADD(UserPageValue.class),
        LOCATION_ADD(UserPageValue.class),
        TELEVISION_ADD(UserPageValue.class),
        GRANTED(PermissionChangeValue.class),
        REVOKED(PermissionChangeValue.class);

        private Class<ChangeValue> valueClass;

        private ChangeValueEnumeration(Class valueClass) {
            this.valueClass = valueClass;
        }

        public Class<ChangeValue> getValueClass() {
            return this.valueClass;
        }
    }
}

