/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types.webhook.messaging;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.json.JsonObject;
import com.restfb.json.JsonValue;
import com.restfb.types.webhook.messaging.AccountLinkingItem;
import com.restfb.types.webhook.messaging.AppRoles;
import com.restfb.types.webhook.messaging.CheckoutUpdateItem;
import com.restfb.types.webhook.messaging.DeliveryItem;
import com.restfb.types.webhook.messaging.InnerMessagingItem;
import com.restfb.types.webhook.messaging.MessageItem;
import com.restfb.types.webhook.messaging.MessageReaction;
import com.restfb.types.webhook.messaging.MessagingParticipant;
import com.restfb.types.webhook.messaging.OptinItem;
import com.restfb.types.webhook.messaging.PassThreadControlItem;
import com.restfb.types.webhook.messaging.PaymentItem;
import com.restfb.types.webhook.messaging.PolicyEnforcementItem;
import com.restfb.types.webhook.messaging.PostbackItem;
import com.restfb.types.webhook.messaging.PriorMessage;
import com.restfb.types.webhook.messaging.ReadItem;
import com.restfb.types.webhook.messaging.ReferralItem;
import com.restfb.types.webhook.messaging.RequestThreadControlItem;
import com.restfb.types.webhook.messaging.TakeThreadControlItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MessagingItem {
    @Facebook
    private MessagingParticipant sender;
    @Facebook
    private MessagingParticipant recipient;
    @Facebook(value="timestamp")
    private Long rawTimestamp;
    private Date timestamp;
    @Facebook
    private DeliveryItem delivery;
    @Facebook
    private ReadItem read;
    @Facebook
    private MessageItem message;
    @Facebook
    private PostbackItem postback;
    @Facebook
    private OptinItem optin;
    @Facebook(value="account_linking")
    private AccountLinkingItem accountLinking;
    @Facebook(value="checkout_update")
    private CheckoutUpdateItem checkoutUpdate;
    @Facebook
    private PaymentItem payment;
    @Facebook
    private ReferralItem referral;
    @Facebook(value="policy-enforcement")
    private PolicyEnforcementItem policyEnforcement;
    @Facebook(value="pass_thread_control")
    private PassThreadControlItem passThreadControl;
    @Facebook(value="take_thread_control")
    private TakeThreadControlItem takeThreadControl;
    @Facebook(value="request_thread_control")
    private RequestThreadControlItem requestThreadControl;
    private AppRoles appRoles;
    @Facebook(value="prior_message")
    private PriorMessage priorMessage;
    @Facebook
    private MessageReaction reaction;
    @Facebook(value="app_roles")
    private JsonObject rawAppRoles;

    public InnerMessagingItem getItem() {
        if (this.optin != null) {
            return this.optin;
        }
        if (this.postback != null) {
            return this.postback;
        }
        if (this.delivery != null) {
            return this.delivery;
        }
        if (this.read != null) {
            return this.read;
        }
        if (this.accountLinking != null) {
            return this.accountLinking;
        }
        if (this.message != null) {
            return this.message;
        }
        if (this.checkoutUpdate != null) {
            return this.checkoutUpdate;
        }
        if (this.payment != null) {
            return this.payment;
        }
        if (this.referral != null) {
            return this.referral;
        }
        if (this.policyEnforcement != null) {
            return this.policyEnforcement;
        }
        if (this.passThreadControl != null) {
            return this.passThreadControl;
        }
        if (this.takeThreadControl != null) {
            return this.takeThreadControl;
        }
        if (this.requestThreadControl != null) {
            return this.requestThreadControl;
        }
        if (this.appRoles != null) {
            return this.appRoles;
        }
        if (this.reaction != null) {
            return this.reaction;
        }
        return null;
    }

    public boolean isDelivery() {
        return this.getItem() instanceof DeliveryItem;
    }

    public boolean isRead() {
        return this.getItem() instanceof ReadItem;
    }

    public boolean isMessage() {
        return this.getItem() instanceof MessageItem;
    }

    public boolean isPostback() {
        return this.getItem() instanceof PostbackItem;
    }

    public boolean isOptin() {
        return this.getItem() instanceof OptinItem;
    }

    public boolean isAccountLinking() {
        return this.getItem() instanceof AccountLinkingItem;
    }

    public boolean isCheckoutUpdate() {
        return this.getItem() instanceof CheckoutUpdateItem;
    }

    public boolean isPayment() {
        return this.getItem() instanceof PaymentItem;
    }

    public boolean isReferral() {
        return this.getItem() instanceof ReferralItem;
    }

    public boolean isPolicyEnforcement() {
        return this.getItem() instanceof PolicyEnforcementItem;
    }

    public boolean isPassThreadControl() {
        return this.getItem() instanceof PassThreadControlItem;
    }

    public boolean isTakeThreadControl() {
        return this.getItem() instanceof TakeThreadControlItem;
    }

    public boolean isRequestThreadControl() {
        return this.getItem() instanceof RequestThreadControlItem;
    }

    public boolean isAppRoles() {
        return this.getItem() instanceof AppRoles;
    }

    public boolean hasPriorMessage() {
        return this.priorMessage != null;
    }

    public boolean isReaction() {
        return this.getItem() instanceof MessageReaction;
    }

    @JsonMapper.JsonMappingCompleted
    private void convertDate() {
        if (this.rawTimestamp != null) {
            this.timestamp = new Date(this.rawTimestamp);
        }
    }

    @JsonMapper.JsonMappingCompleted
    private void convertAppRoles() {
        if (this.rawAppRoles != null) {
            AppRoles appRoles = new AppRoles();
            for (String appId : this.rawAppRoles.names()) {
                List<JsonValue> rawRoles = this.rawAppRoles.get(appId).asArray().values();
                ArrayList<String> roles = new ArrayList<String>();
                for (JsonValue rawValue : rawRoles) {
                    roles.add(rawValue.asString());
                }
                appRoles.addRoles(appId, roles);
            }
            this.appRoles = appRoles;
        }
    }

    public String toString() {
        return "MessagingItem(sender=" + this.getSender() + ", recipient=" + this.getRecipient() + ", rawTimestamp=" + this.rawTimestamp + ", timestamp=" + this.getTimestamp() + ", delivery=" + this.getDelivery() + ", read=" + this.getRead() + ", message=" + this.getMessage() + ", postback=" + this.getPostback() + ", optin=" + this.getOptin() + ", accountLinking=" + this.getAccountLinking() + ", checkoutUpdate=" + this.getCheckoutUpdate() + ", payment=" + this.getPayment() + ", referral=" + this.getReferral() + ", policyEnforcement=" + this.getPolicyEnforcement() + ", passThreadControl=" + this.getPassThreadControl() + ", takeThreadControl=" + this.getTakeThreadControl() + ", requestThreadControl=" + this.getRequestThreadControl() + ", appRoles=" + this.getAppRoles() + ", priorMessage=" + this.getPriorMessage() + ", reaction=" + this.getReaction() + ", rawAppRoles=" + this.rawAppRoles + ")";
    }

    public MessagingParticipant getSender() {
        return this.sender;
    }

    public void setSender(MessagingParticipant sender) {
        this.sender = sender;
    }

    public MessagingParticipant getRecipient() {
        return this.recipient;
    }

    public void setRecipient(MessagingParticipant recipient) {
        this.recipient = recipient;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public DeliveryItem getDelivery() {
        return this.delivery;
    }

    public void setDelivery(DeliveryItem delivery) {
        this.delivery = delivery;
    }

    public ReadItem getRead() {
        return this.read;
    }

    public void setRead(ReadItem read) {
        this.read = read;
    }

    public MessageItem getMessage() {
        return this.message;
    }

    public void setMessage(MessageItem message) {
        this.message = message;
    }

    public PostbackItem getPostback() {
        return this.postback;
    }

    public void setPostback(PostbackItem postback) {
        this.postback = postback;
    }

    public OptinItem getOptin() {
        return this.optin;
    }

    public void setOptin(OptinItem optin) {
        this.optin = optin;
    }

    public AccountLinkingItem getAccountLinking() {
        return this.accountLinking;
    }

    public void setAccountLinking(AccountLinkingItem accountLinking) {
        this.accountLinking = accountLinking;
    }

    public CheckoutUpdateItem getCheckoutUpdate() {
        return this.checkoutUpdate;
    }

    public void setCheckoutUpdate(CheckoutUpdateItem checkoutUpdate) {
        this.checkoutUpdate = checkoutUpdate;
    }

    public PaymentItem getPayment() {
        return this.payment;
    }

    public void setPayment(PaymentItem payment) {
        this.payment = payment;
    }

    public ReferralItem getReferral() {
        return this.referral;
    }

    public void setReferral(ReferralItem referral) {
        this.referral = referral;
    }

    public PolicyEnforcementItem getPolicyEnforcement() {
        return this.policyEnforcement;
    }

    public void setPolicyEnforcement(PolicyEnforcementItem policyEnforcement) {
        this.policyEnforcement = policyEnforcement;
    }

    public PassThreadControlItem getPassThreadControl() {
        return this.passThreadControl;
    }

    public void setPassThreadControl(PassThreadControlItem passThreadControl) {
        this.passThreadControl = passThreadControl;
    }

    public TakeThreadControlItem getTakeThreadControl() {
        return this.takeThreadControl;
    }

    public void setTakeThreadControl(TakeThreadControlItem takeThreadControl) {
        this.takeThreadControl = takeThreadControl;
    }

    public RequestThreadControlItem getRequestThreadControl() {
        return this.requestThreadControl;
    }

    public void setRequestThreadControl(RequestThreadControlItem requestThreadControl) {
        this.requestThreadControl = requestThreadControl;
    }

    public AppRoles getAppRoles() {
        return this.appRoles;
    }

    public void setAppRoles(AppRoles appRoles) {
        this.appRoles = appRoles;
    }

    public PriorMessage getPriorMessage() {
        return this.priorMessage;
    }

    public void setPriorMessage(PriorMessage priorMessage) {
        this.priorMessage = priorMessage;
    }

    public MessageReaction getReaction() {
        return this.reaction;
    }

    public void setReaction(MessageReaction reaction) {
        this.reaction = reaction;
    }
}

