/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types.webhook.messaging.nlp;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.types.AbstractFacebookType;
import com.restfb.types.webhook.messaging.nlp.BaseNlpEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;

public class NlpLocation
extends BaseNlpEntity {
    @Facebook
    private List<Place> resolved = new ArrayList<Place>();

    public List<Place> getResolved() {
        return Collections.unmodifiableList(this.resolved);
    }

    public static class External
    extends AbstractFacebookType {
        @Facebook
        private String geonames;
        @Facebook
        private String wikidata;
        @Facebook
        private String wikipedia;

        public String getGeonames() {
            return this.geonames;
        }

        public void setGeonames(String geonames) {
            this.geonames = geonames;
        }

        public String getWikidata() {
            return this.wikidata;
        }

        public void setWikidata(String wikidata) {
            this.wikidata = wikidata;
        }

        public String getWikipedia() {
            return this.wikipedia;
        }

        public void setWikipedia(String wikipedia) {
            this.wikipedia = wikipedia;
        }
    }

    public static class Coords
    extends AbstractFacebookType {
        @Facebook(value="lat")
        private Double latitude;
        @Facebook(value="long")
        private Double longitude;

        public Double getLatitude() {
            return this.latitude;
        }

        public void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        public void setLongitude(Double longitude) {
            this.longitude = longitude;
        }
    }

    public static class Place
    extends AbstractFacebookType {
        @Facebook
        private String name;
        @Facebook
        private String grain;
        @Facebook
        private String type;
        @Facebook(value="timezone")
        private String timezoneAsString;
        private TimeZone timeZone;
        @Facebook
        private Coords coords;
        @Facebook
        private External external;

        @JsonMapper.JsonMappingCompleted
        protected void convertTimezone() {
            if (this.timezoneAsString != null) {
                try {
                    this.timeZone = TimeZone.getTimeZone(this.timezoneAsString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getGrain() {
            return this.grain;
        }

        public void setGrain(String grain) {
            this.grain = grain;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getTimezoneAsString() {
            return this.timezoneAsString;
        }

        public void setTimezoneAsString(String timezoneAsString) {
            this.timezoneAsString = timezoneAsString;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        public Coords getCoords() {
            return this.coords;
        }

        public void setCoords(Coords coords) {
            this.coords = coords;
        }

        public External getExternal() {
            return this.external;
        }

        public void setExternal(External external) {
            this.external = external;
        }
    }
}

