/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class EncodingUtils {
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();

    private EncodingUtils() {
    }

    public static byte[] decodeBase64(String base64) {
        return Base64.getDecoder().decode(Optional.ofNullable(base64).map(EncodingUtils::padBase64).orElseThrow(() -> new NullPointerException("Parameter 'base64' cannot be null.")));
    }

    private static String padBase64(String base64) {
        String padding = "";
        int remainder = base64.length() % 4;
        if (remainder > 0) {
            padding = IntStream.range(0, 4 - remainder).mapToObj(i -> "=").collect(Collectors.joining());
        }
        return base64 + padding;
    }

    public static byte[] encodeHex(byte[] data) {
        Objects.requireNonNull(data, "Parameter 'data' cannot be null.");
        char[] out = new char[data.length << 1];
        for (int j = 0; j < data.length; ++j) {
            int v = data[j] & 0xFF;
            out[j * 2] = HEX_ARRAY[v >>> 4];
            out[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(out).getBytes(StandardCharsets.UTF_8);
    }

    public static String encodeAppSecretProof(String appSecret, String accessToken) {
        try {
            byte[] key = appSecret.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            byte[] raw = mac.doFinal(accessToken.getBytes());
            byte[] hex = EncodingUtils.encodeHex(raw);
            return new String(hex, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IllegalStateException("Creation of appsecret_proof has failed", e);
        }
    }
}

