/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import com.restfb.util.StringUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class ObjectUtil {
    private ObjectUtil() {
    }

    public static String requireNotEmpty(String obj, String errorText) {
        if (StringUtils.isBlank(obj)) {
            throw new IllegalArgumentException(errorText);
        }
        return obj;
    }

    public static <T extends Exception> void requireNotNull(Object obj, Supplier<T> exceptionSupplier) throws T {
        if (obj == null) {
            throw (Exception)exceptionSupplier.get();
        }
    }

    public static boolean isEmptyCollectionOrMap(Object obj) {
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        return obj instanceof Map && ((Map)obj).isEmpty();
    }

    public static void verifyParameterPresence(String parameterName, String parameter) {
        ObjectUtil.verifyParameterPresence(parameterName, (Object)parameter);
        ObjectUtil.requireNotEmpty(parameter, "The '" + parameterName + "' parameter cannot be an empty string.");
    }

    public static void verifyParameterPresence(String parameterName, Object parameter) {
        Objects.requireNonNull(parameter, "The '" + parameterName + "' parameter cannot be null.");
    }
}

