/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.stream.Collectors;

public final class StringUtils {
    public static final Charset ENCODING_CHARSET = StandardCharsets.UTF_8;

    private StringUtils() {
    }

    public static boolean isBlank(String string) {
        return string == null || "".equals(string.trim());
    }

    public static String trimToNull(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        return string.trim();
    }

    public static String trimToEmpty(String string) {
        if (StringUtils.isBlank(string)) {
            return "";
        }
        return string.trim();
    }

    public static byte[] toBytes(String string) {
        return Optional.ofNullable(string).orElseThrow(() -> new NullPointerException("Parameter 'string' cannot be null.")).getBytes(ENCODING_CHARSET);
    }

    public static String toString(byte[] data) {
        return new String(Optional.ofNullable(data).orElseThrow(() -> new NullPointerException("Parameter 'data' cannot be null.")), ENCODING_CHARSET);
    }

    public static String fromInputStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, ENCODING_CHARSET));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    public static Integer toInteger(String string) {
        try {
            return Optional.ofNullable(string).map(Integer::parseInt).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

