/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.webhook;

import com.restfb.types.webhook.FeedAlbumAddValue;
import com.restfb.types.webhook.FeedAlbumEditedValue;
import com.restfb.types.webhook.FeedCommentValue;
import com.restfb.types.webhook.FeedEventValue;
import com.restfb.types.webhook.FeedLikeValue;
import com.restfb.types.webhook.FeedPhotoAddValue;
import com.restfb.types.webhook.FeedPhotoRemoveValue;
import com.restfb.types.webhook.FeedPostValue;
import com.restfb.types.webhook.FeedReactionValue;
import com.restfb.types.webhook.FeedShareValue;
import com.restfb.types.webhook.FeedStatusValue;
import com.restfb.types.webhook.FeedVideoBlockMute;
import com.restfb.types.webhook.FeedVideoRemoveValue;
import com.restfb.types.webhook.FeedVideoValue;
import com.restfb.types.webhook.MentionPostAddValue;
import com.restfb.types.webhook.PageLeadgen;
import com.restfb.types.webhook.PermissionChangeValue;
import com.restfb.types.webhook.RatingsCommentValue;
import com.restfb.types.webhook.RatingsLikeValue;
import com.restfb.types.webhook.RatingsRatingValue;
import com.restfb.types.webhook.RatingsReactionValue;
import com.restfb.types.webhook.UserPageValue;
import com.restfb.types.webhook.WebhookObject;
import com.restfb.types.webhook.instagram.InstagramCommentsValue;
import com.restfb.types.webhook.instagram.InstagramMentionsValue;
import com.restfb.types.webhook.instagram.InstagramStoryInsightsValue;
import com.restfb.webhook.WebhookChangeListener;
import com.restfb.webhook.WebhookMessagingListener;

public class Webhook {
    private WebhookMessagingListener messagingListener;
    private WebhookChangeListener eventListener;

    public void registerListener(WebhookMessagingListener listener) {
        this.messagingListener = listener;
    }

    public void registerListener(WebhookChangeListener listener) {
        this.eventListener = listener;
    }

    public void process(WebhookObject webhookObject) {
        if (this.messagingListener != null) {
            this.handleMessaging(webhookObject);
        }
        if (this.eventListener != null) {
            this.handleEvents(webhookObject);
        }
    }

    private void handleEvents(WebhookObject webhookObject) {
        webhookObject.getEntryList().stream().flatMap(entry -> entry.getChanges().stream()).forEach(change -> {
            if (change.getValue() instanceof FeedCommentValue) {
                this.eventListener.feedCommentValue(change.getValue().convertChangeValue(FeedCommentValue.class));
            }
            if (change.getValue() instanceof FeedPhotoAddValue) {
                this.eventListener.feedPhotoAddValue(change.getValue().convertChangeValue(FeedPhotoAddValue.class));
            }
            if (change.getValue() instanceof FeedPhotoRemoveValue) {
                this.eventListener.feedPhotoRemoveValue(change.getValue().convertChangeValue(FeedPhotoRemoveValue.class));
            }
            if (change.getValue() instanceof FeedVideoValue) {
                this.eventListener.feedVideoValue(change.getValue().convertChangeValue(FeedVideoValue.class));
            }
            if (change.getValue() instanceof FeedVideoRemoveValue) {
                this.eventListener.feedVideoRemoveValue(change.getValue().convertChangeValue(FeedVideoRemoveValue.class));
            }
            if (change.getValue() instanceof FeedStatusValue) {
                this.eventListener.feedStatusValue(change.getValue().convertChangeValue(FeedStatusValue.class));
            }
            if (change.getValue() instanceof FeedPostValue) {
                this.eventListener.feedPostValue(change.getValue().convertChangeValue(FeedPostValue.class));
            }
            if (change.getValue() instanceof FeedVideoBlockMute) {
                this.eventListener.feedVideoBlockMute(change.getValue().convertChangeValue(FeedVideoBlockMute.class));
            }
            if (change.getValue() instanceof FeedReactionValue) {
                this.eventListener.feedReactionValue(change.getValue().convertChangeValue(FeedReactionValue.class));
            }
            if (change.getValue() instanceof FeedShareValue) {
                this.eventListener.feedShareValue(change.getValue().convertChangeValue(FeedShareValue.class));
            }
            if (change.getValue() instanceof FeedAlbumEditedValue) {
                this.eventListener.feedAlbumEditedValue(change.getValue().convertChangeValue(FeedAlbumEditedValue.class));
            }
            if (change.getValue() instanceof FeedEventValue) {
                this.eventListener.feedEventValue(change.getValue().convertChangeValue(FeedEventValue.class));
            }
            if (change.getValue() instanceof FeedLikeValue) {
                this.eventListener.feedLikeValue(change.getValue().convertChangeValue(FeedLikeValue.class));
            }
            if (change.getValue() instanceof FeedAlbumAddValue) {
                this.eventListener.feedAlbumAddValue(change.getValue().convertChangeValue(FeedAlbumAddValue.class));
            }
            if (change.getValue() instanceof RatingsRatingValue) {
                this.eventListener.ratingsRatingValue(change.getValue().convertChangeValue(RatingsRatingValue.class));
            }
            if (change.getValue() instanceof MentionPostAddValue) {
                this.eventListener.mentionPostAddValue(change.getValue().convertChangeValue(MentionPostAddValue.class));
            }
            if (change.getValue() instanceof RatingsCommentValue) {
                this.eventListener.ratingsCommentValue(change.getValue().convertChangeValue(RatingsCommentValue.class));
            }
            if (change.getValue() instanceof RatingsLikeValue) {
                this.eventListener.ratingsLikeValue(change.getValue().convertChangeValue(RatingsLikeValue.class));
            }
            if (change.getValue() instanceof RatingsReactionValue) {
                this.eventListener.ratingsReactionValue(change.getValue().convertChangeValue(RatingsReactionValue.class));
            }
            if (change.getValue() instanceof UserPageValue) {
                this.eventListener.userPageValue(change.getValue().convertChangeValue(UserPageValue.class));
            }
            if (change.getValue() instanceof PermissionChangeValue) {
                this.eventListener.permissionChangeValue(change.getValue().convertChangeValue(PermissionChangeValue.class));
            }
            if (change.getValue() instanceof PageLeadgen) {
                this.eventListener.pageLeadgen(change.getValue().convertChangeValue(PageLeadgen.class));
            }
            if (change.getValue() instanceof InstagramStoryInsightsValue) {
                this.eventListener.instagramStoryInsightsValue(change.getValue().convertChangeValue(InstagramStoryInsightsValue.class));
            }
            if (change.getValue() instanceof InstagramMentionsValue) {
                this.eventListener.instagramMentionsValue(change.getValue().convertChangeValue(InstagramMentionsValue.class));
            }
            if (change.getValue() instanceof InstagramCommentsValue) {
                this.eventListener.instagramCommentsValue(change.getValue().convertChangeValue(InstagramCommentsValue.class));
            }
        });
    }

    private void handleMessaging(WebhookObject webhookObject) {
        webhookObject.getEntryList().stream().flatMap(entry -> entry.getMessaging().stream()).forEach(messagingItem -> {
            if (messagingItem.isAccountLinking()) {
                this.messagingListener.accountLinking(messagingItem.getAccountLinking(), messagingItem.getRecipient(), messagingItem.getSender());
            }
            if (messagingItem.isAppRoles()) {
                this.messagingListener.appRoles(messagingItem.getAppRoles(), messagingItem.getRecipient(), messagingItem.getSender());
            }
            if (messagingItem.isCheckoutUpdate()) {
                this.messagingListener.checkoutUpdate(messagingItem.getCheckoutUpdate(), messagingItem.getRecipient(), messagingItem.getSender());
            }
            if (messagingItem.isDelivery()) {
                this.messagingListener.delivery(messagingItem.getDelivery(), messagingItem.getRecipient(), messagingItem.getSender());
            }
            if (messagingItem.isMessage()) {
                this.messagingListener.message(messagingItem.getMessage(), messagingItem.getRecipient(), messagingItem.getSender());
            }
            if (messagingItem.isOptin()) {
                this.messagingListener.optin(messagingItem.getOptin(), messagingItem.getRecipient(), messagingItem.getSender());
            }
            if (messagingItem.isPassThreadControl()) {
                this.messagingListener.passThreadControl(messagingItem.getPassThreadControl(), messagingItem.getRecipient(), messagingItem.getSender());
            }
            if (messagingItem.isPayment()) {
                this.messagingListener.payment(messagingItem.getPayment(), messagingItem.getRecipient(), messagingItem.getSender());
            }
            if (messagingItem.isPolicyEnforcement()) {
                this.messagingListener.policyEnforcement(messagingItem.getPolicyEnforcement(), messagingItem.getRecipient(), messagingItem.getSender());
            }
            if (messagingItem.isPostback()) {
                this.messagingListener.postback(messagingItem.getPostback(), messagingItem.getRecipient(), messagingItem.getSender());
            }
            if (messagingItem.isReaction()) {
                this.messagingListener.reaction(messagingItem.getReaction(), messagingItem.getRecipient(), messagingItem.getSender());
            }
            if (messagingItem.isRead()) {
                this.messagingListener.read(messagingItem.getRead(), messagingItem.getRecipient(), messagingItem.getSender());
            }
            if (messagingItem.isReferral()) {
                this.messagingListener.referral(messagingItem.getReferral(), messagingItem.getRecipient(), messagingItem.getSender());
            }
            if (messagingItem.isRequestThreadControl()) {
                this.messagingListener.requestThreadControl(messagingItem.getRequestThreadControl(), messagingItem.getRecipient(), messagingItem.getSender());
            }
            if (messagingItem.isTakeThreadControl()) {
                this.messagingListener.takeThreadControl(messagingItem.getTakeThreadControl(), messagingItem.getRecipient(), messagingItem.getSender());
            }
        });
    }
}

