/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import com.networknt.client.ClientConfig;
import com.networknt.client.ServerExchangeCarrier;
import com.networknt.cluster.Cluster;
import com.networknt.config.ConfigException;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.router.HostWhitelist;
import com.networknt.service.SingletonServiceFactory;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.undertow.client.UndertowClient;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.ConnectionPoolErrorHandler;
import io.undertow.server.handlers.proxy.ConnectionPoolManager;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.server.handlers.proxy.ProxyConnectionPool;
import io.undertow.util.AttachmentKey;
import io.undertow.util.AttachmentList;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HeaderMap;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;
import org.xnio.ssl.XnioSsl;

public class LoadBalancingRouterProxyClient
implements ProxyClient {
    private static Logger logger = LoggerFactory.getLogger(LoadBalancingRouterProxyClient.class);
    private static final AttachmentKey<AttachmentList<Host>> ATTEMPTED_HOSTS = AttachmentKey.createList(Host.class);
    private static Cluster cluster = SingletonServiceFactory.getBean(Cluster.class);
    private static final HostWhitelist HOST_WHITELIST = new HostWhitelist();
    private volatile int problemServerRetry = 10;
    private volatile int connectionsPerThread = 10;
    private volatile int maxQueueSize = 0;
    private volatile int softMaxConnectionsPerThread = 5;
    private volatile int ttl = -1;
    private volatile Map<String, Host[]> hosts = new CopyOnWriteMap<String, Host[]>();
    private final HostSelector hostSelector;
    private final UndertowClient client;
    private XnioSsl ssl;
    private OptionMap options;
    private InetSocketAddress bindAddress;
    private static final ProxyClient.ProxyTarget PROXY_TARGET = new ProxyClient.ProxyTarget(){};

    public LoadBalancingRouterProxyClient() {
        this(UndertowClient.getInstance());
    }

    public LoadBalancingRouterProxyClient(UndertowClient client) {
        this(client, null);
    }

    public LoadBalancingRouterProxyClient(UndertowClient client, HostSelector hostSelector) {
        this.client = client;
        this.hostSelector = hostSelector == null ? new RoundRobinHostSelector() : hostSelector;
    }

    public LoadBalancingRouterProxyClient setSsl(XnioSsl ssl) {
        this.ssl = ssl;
        return this;
    }

    public LoadBalancingRouterProxyClient setOptionMap(OptionMap options) {
        this.options = options;
        return this;
    }

    public LoadBalancingRouterProxyClient setProblemServerRetry(int problemServerRetry) {
        this.problemServerRetry = problemServerRetry;
        return this;
    }

    public int getProblemServerRetry() {
        return this.problemServerRetry;
    }

    public int getConnectionsPerThread() {
        return this.connectionsPerThread;
    }

    public LoadBalancingRouterProxyClient setConnectionsPerThread(int connectionsPerThread) {
        this.connectionsPerThread = connectionsPerThread;
        return this;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public LoadBalancingRouterProxyClient setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    public LoadBalancingRouterProxyClient setTtl(int ttl) {
        this.ttl = ttl;
        return this;
    }

    public LoadBalancingRouterProxyClient setSoftMaxConnectionsPerThread(int softMaxConnectionsPerThread) {
        this.softMaxConnectionsPerThread = softMaxConnectionsPerThread;
        return this;
    }

    public synchronized void addHosts(String serviceId, String envTag) {
        String key = serviceId + envTag;
        List<URI> uris = cluster.services(this.ssl == null ? "http" : "https", serviceId, envTag);
        this.hosts.remove(key);
        Host[] newHosts = new Host[uris.size()];
        for (int i = 0; i < uris.size(); ++i) {
            Host h;
            newHosts[i] = h = new Host(serviceId, this.bindAddress, uris.get(i), this.ssl, this.options);
        }
        this.hosts.put(key, newHosts);
    }

    @Override
    public ProxyClient.ProxyTarget findTarget(HttpServerExchange exchange) {
        return PROXY_TARGET;
    }

    @Override
    public void getConnection(ProxyClient.ProxyTarget target, HttpServerExchange exchange, ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit) {
        try {
            Host host = this.selectHost(exchange);
            if (host == null) {
                host = this.selectHost(exchange);
            }
            if (host == null) {
                callback.couldNotResolveBackend(exchange);
            } else {
                exchange.addToAttachmentList(ATTEMPTED_HOSTS, host);
                host.connectionPool.connect(target, exchange, callback, timeout, timeUnit, false);
            }
        }
        catch (Exception ex) {
            logger.error("Failed to get connection", ex);
            exchange.setReasonPhrase(ex.getMessage());
            callback.failed(exchange);
        }
    }

    protected Host selectHost(HttpServerExchange exchange) {
        int host;
        HeaderMap headers = exchange.getRequestHeaders();
        String serviceId = headers.getFirst(HttpStringConstants.SERVICE_ID);
        String serviceUrl = headers.getFirst(HttpStringConstants.SERVICE_URL);
        if (serviceUrl != null) {
            headers.remove(HttpStringConstants.SERVICE_URL);
        }
        String envTag = headers.getFirst(HttpStringConstants.ENV_TAG);
        String key = (serviceUrl != null ? serviceUrl : serviceId) + envTag;
        AttachmentList<Host> attempted = exchange.getAttachment(ATTEMPTED_HOSTS);
        Host[] hostArray = this.hosts.get(key);
        if (hostArray == null || hostArray.length == 0) {
            if (serviceUrl != null) {
                try {
                    URI uri = new URI(serviceUrl);
                    if (HOST_WHITELIST != null) {
                        if (!HOST_WHITELIST.isHostAllowed(uri)) {
                            throw new RuntimeException(String.format("Route to %s is not allowed in the host whitelist", serviceUrl));
                        }
                    } else {
                        throw new ConfigException(String.format("Host Whitelist must be enabled to support route based on %s in Http header", HttpStringConstants.SERVICE_URL));
                    }
                    this.hosts.put(key, new Host[]{new Host(serviceId, this.bindAddress, uri, this.ssl, this.options)});
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.addHosts(serviceId, envTag);
            }
            hostArray = this.hosts.get(key);
        }
        int startHost = host = this.hostSelector.selectHost(hostArray);
        Host full = null;
        Host problem = null;
        do {
            Host selected = hostArray[host];
            if (attempted != null && attempted.contains(selected)) continue;
            ProxyConnectionPool.AvailabilityType available = selected.connectionPool.available();
            if (available == ProxyConnectionPool.AvailabilityType.AVAILABLE) {
                this.injectTracer(exchange, selected);
                return selected;
            }
            if (available == ProxyConnectionPool.AvailabilityType.FULL && full == null) {
                full = selected;
                continue;
            }
            if (available != ProxyConnectionPool.AvailabilityType.PROBLEM && available != ProxyConnectionPool.AvailabilityType.FULL_QUEUE || problem != null) continue;
            problem = selected;
        } while ((host = (host + 1) % hostArray.length) != startHost);
        if (full != null) {
            this.injectTracer(exchange, full);
            return full;
        }
        if (problem != null) {
            this.addHosts(serviceId, envTag);
        }
        return null;
    }

    private void injectTracer(HttpServerExchange exchange, Host host) {
        if (ClientConfig.get().isInjectOpenTracing()) {
            Tracer tracer = exchange.getAttachment(AttachmentConstants.EXCHANGE_TRACER);
            Span rootSpan = exchange.getAttachment(AttachmentConstants.ROOT_SPAN);
            if (tracer != null) {
                tracer.activateSpan(rootSpan);
                Tags.SPAN_KIND.set(tracer.activeSpan(), "client");
                Tags.HTTP_METHOD.set(tracer.activeSpan(), exchange.getRequestMethod().toString());
                Tags.HTTP_URL.set(tracer.activeSpan(), exchange.getRequestURI());
                Tags.PEER_PORT.set(tracer.activeSpan(), host.uri.getPort());
                Tags.PEER_HOSTNAME.set(tracer.activeSpan(), host.uri.getHost());
                tracer.inject(tracer.activeSpan().context(), Format.Builtin.HTTP_HEADERS, new ServerExchangeCarrier(exchange));
            }
        }
    }

    public void closeCurrentConnections() {
        for (Map.Entry<String, Host[]> entry : this.hosts.entrySet()) {
            for (Host host : entry.getValue()) {
                host.closeCurrentConnections();
            }
        }
    }

    static class RoundRobinHostSelector
    implements HostSelector {
        private final AtomicInteger currentHost = new AtomicInteger(0);

        RoundRobinHostSelector() {
        }

        @Override
        public int selectHost(Host[] availableHosts) {
            return this.currentHost.incrementAndGet() % availableHosts.length;
        }
    }

    public static interface HostSelector {
        public int selectHost(Host[] var1);
    }

    public final class Host
    extends ConnectionPoolErrorHandler.SimpleConnectionPoolErrorHandler
    implements ConnectionPoolManager {
        final ProxyConnectionPool connectionPool;
        final String serviceId;
        final URI uri;
        final XnioSsl ssl;

        private Host(String serviceId, InetSocketAddress bindAddress, URI uri, XnioSsl ssl, OptionMap options) {
            this.connectionPool = new ProxyConnectionPool(this, bindAddress, uri, ssl, LoadBalancingRouterProxyClient.this.client, options);
            this.serviceId = serviceId;
            this.uri = uri;
            this.ssl = ssl;
        }

        @Override
        public int getProblemServerRetry() {
            return LoadBalancingRouterProxyClient.this.problemServerRetry;
        }

        @Override
        public int getMaxConnections() {
            return LoadBalancingRouterProxyClient.this.connectionsPerThread;
        }

        @Override
        public int getMaxCachedConnections() {
            return LoadBalancingRouterProxyClient.this.connectionsPerThread;
        }

        @Override
        public int getSMaxConnections() {
            return LoadBalancingRouterProxyClient.this.softMaxConnectionsPerThread;
        }

        @Override
        public long getTtl() {
            return LoadBalancingRouterProxyClient.this.ttl;
        }

        @Override
        public int getMaxQueueSize() {
            return LoadBalancingRouterProxyClient.this.maxQueueSize;
        }

        public URI getUri() {
            return this.uri;
        }

        void closeCurrentConnections() {
            this.connectionPool.closeCurrentConnections();
        }
    }
}

