/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.logging.handler;

import ch.qos.logback.classic.Logger;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.config.Config;
import com.networknt.handler.LightHttpHandler;
import com.networknt.httpstring.ContentType;
import com.networknt.logging.model.LoggerConfig;
import com.networknt.logging.model.LoggerInfo;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Deque;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class LoggerGetHandler
implements LightHttpHandler {
    public static final String CONFIG_NAME = "logging";
    private static final String LOGGER_NAME = "loggerName";
    static final String STATUS_LOGGER_INFO_DISABLED = "ERR12108";
    private static final ObjectMapper mapper = Config.getInstance().getMapper();

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Map parameters = exchange.getQueryParameters();
        String loggerName = (String)((Deque)parameters.get(LOGGER_NAME)).getFirst();
        LoggerConfig config = (LoggerConfig)Config.getInstance().getJsonObjectConfig(CONFIG_NAME, LoggerConfig.class);
        if (config.isEnabled()) {
            Logger logger = (Logger)LoggerFactory.getLogger((String)loggerName);
            LoggerInfo loggerInfo = new LoggerInfo();
            loggerInfo.setName(logger.getName());
            loggerInfo.setLevel(logger.getLevel().toString());
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, ContentType.APPLICATION_JSON.value());
            exchange.getResponseSender().send(mapper.writeValueAsString((Object)loggerInfo));
        } else {
            logger.error("Logging is disabled in logging.yml");
            this.setExchangeStatus(exchange, STATUS_LOGGER_INFO_DISABLED, new Object[0]);
        }
    }
}

