/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.logging.handler;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.config.Config;
import com.networknt.handler.LightHttpHandler;
import com.networknt.httpstring.ContentType;
import com.networknt.logging.model.LoggerConfig;
import com.networknt.logging.model.LoggerInfo;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.ArrayList;
import org.slf4j.LoggerFactory;

public class LoggersGetHandler
implements LightHttpHandler {
    public static final String CONFIG_NAME = "logging";
    static final String STATUS_LOGGER_INFO_DISABLED = "ERR12108";
    private static final ObjectMapper mapper = Config.getInstance().getMapper();

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ArrayList<LoggerInfo> loggersList = new ArrayList<LoggerInfo>();
        LoggerConfig config = (LoggerConfig)Config.getInstance().getJsonObjectConfig(CONFIG_NAME, LoggerConfig.class);
        if (config.isEnabled()) {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            for (Logger log : lc.getLoggerList()) {
                if (log.getLevel() == null) continue;
                LoggerInfo loggerInfo = new LoggerInfo();
                loggerInfo.setName(log.getName());
                loggerInfo.setLevel(log.getLevel().toString());
                loggersList.add(loggerInfo);
            }
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, ContentType.APPLICATION_JSON.value());
            exchange.getResponseSender().send(mapper.writeValueAsString(loggersList));
        } else {
            logger.error("Logging is disabled in logging.yml");
            this.setExchangeStatus(exchange, STATUS_LOGGER_INFO_DISABLED, new Object[0]);
        }
    }
}

