/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.metrics;

import com.networknt.audit.AuditHandler;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.metrics.MetricsConfig;
import com.networknt.server.Server;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.Util;
import io.dropwizard.metrics.Clock;
import io.dropwizard.metrics.MetricFilter;
import io.dropwizard.metrics.MetricName;
import io.dropwizard.metrics.MetricRegistry;
import io.dropwizard.metrics.influxdb.InfluxDbHttpSender;
import io.dropwizard.metrics.influxdb.InfluxDbReporter;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsHandler
implements MiddlewareHandler {
    public static final String CONFIG_NAME = "metrics";
    public static MetricsConfig config;
    static final MetricRegistry registry;
    static final Logger logger;
    private volatile HttpHandler next;
    Map<String, String> commonTags = new HashMap<String, String>();

    public MetricsHandler() {
        this.commonTags.put("apiName", Server.config.getServiceId());
        this.commonTags.put("environment", Server.config.getEnvironment());
        InetAddress inetAddress = Util.getInetAddress();
        this.commonTags.put("ipAddress", inetAddress == null ? "unknown" : inetAddress.getHostAddress());
        this.commonTags.put("hostname", inetAddress == null ? "unknown" : inetAddress.getHostName());
        if (logger.isDebugEnabled()) {
            logger.debug(this.commonTags.toString());
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        long startTime = Clock.defaultClock().getTick();
        exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
            Map auditInfo = (Map)exchange1.getAttachment(AuditHandler.AUDIT_INFO);
            if (auditInfo != null) {
                HashMap<String, String> tags = new HashMap<String, String>();
                tags.put("endpoint", (String)auditInfo.get("endpoint"));
                tags.put("clientId", auditInfo.get("client_id") != null ? (String)auditInfo.get("client_id") : "unknown");
                long time = Clock.defaultClock().getTick() - startTime;
                MetricName metricName = new MetricName("response_time");
                metricName = metricName.tagged(this.commonTags);
                metricName = metricName.tagged(tags);
                registry.getOrAdd(metricName, MetricRegistry.MetricBuilder.TIMERS).update(time, TimeUnit.NANOSECONDS);
                this.incCounterForStatusCode(exchange1.getStatusCode(), this.commonTags, tags);
            }
            nextListener.proceed();
        });
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)MetricsHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }

    private void incCounterForStatusCode(int statusCode, Map<String, String> commonTags, Map<String, String> tags) {
        MetricName metricName = new MetricName("request").tagged(commonTags).tagged(tags);
        registry.getOrAdd(metricName, MetricRegistry.MetricBuilder.COUNTERS).inc();
        if (statusCode >= 200 && statusCode < 400) {
            metricName = new MetricName("success").tagged(commonTags).tagged(tags);
            registry.getOrAdd(metricName, MetricRegistry.MetricBuilder.COUNTERS).inc();
        } else if (statusCode == 401 || statusCode == 403) {
            metricName = new MetricName("auth_error").tagged(commonTags).tagged(tags);
            registry.getOrAdd(metricName, MetricRegistry.MetricBuilder.COUNTERS).inc();
        } else if (statusCode >= 400 && statusCode < 500) {
            metricName = new MetricName("request_error").tagged(commonTags).tagged(tags);
            registry.getOrAdd(metricName, MetricRegistry.MetricBuilder.COUNTERS).inc();
        } else if (statusCode >= 500) {
            metricName = new MetricName("server_error").tagged(commonTags).tagged(tags);
            registry.getOrAdd(metricName, MetricRegistry.MetricBuilder.COUNTERS).inc();
        }
    }

    static {
        registry = new MetricRegistry();
        logger = LoggerFactory.getLogger(MetricsHandler.class);
        config = (MetricsConfig)Config.getInstance().getJsonObjectConfig(CONFIG_NAME, MetricsConfig.class);
        if (MetricsHandler.config.enabled) {
            try {
                InfluxDbHttpSender influxDb = new InfluxDbHttpSender(MetricsHandler.config.influxdbProtocol, MetricsHandler.config.influxdbHost, MetricsHandler.config.influxdbPort, MetricsHandler.config.influxdbName, MetricsHandler.config.influxdbUser, MetricsHandler.config.influxdbPass);
                InfluxDbReporter reporter = InfluxDbReporter.forRegistry(registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(influxDb);
                reporter.start(config.getReportInMinutes(), TimeUnit.MINUTES);
                logger.info("metrics is enabled and reporter is started");
            }
            catch (Exception e) {
                logger.error("metrics is disabled as it cannot connect to the influxdb", (Throwable)e);
                config.setEnabled(false);
            }
        }
    }
}

