/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import io.dropwizard.metrics.Counting;
import io.dropwizard.metrics.LongAdder;
import io.dropwizard.metrics.LongAdderFactory;
import io.dropwizard.metrics.Metric;
import io.dropwizard.metrics.Reservoir;
import io.dropwizard.metrics.Sampling;
import io.dropwizard.metrics.Snapshot;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class Histogram
implements Metric,
Sampling,
Counting {
    private final Reservoir reservoir;
    private final LongAdder count;

    public Histogram(Reservoir reservoir) {
        this.reservoir = reservoir;
        this.count = LongAdderFactory.create();
    }

    public void update(int value) {
        this.update((long)value);
    }

    public void update(long value) {
        this.count.increment();
        this.reservoir.update(value);
    }

    @Override
    public long getCount() {
        return this.count.sum();
    }

    @Override
    public Snapshot getSnapshot() {
        return this.reservoir.getSnapshot();
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getSnapshot().dump(out);
        try {
            return out.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return super.toString();
        }
    }
}

