/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import io.dropwizard.metrics.LongAdder;
import io.dropwizard.metrics.LongAdderImpl;
import io.dropwizard.metrics.UnsafeLongAdderImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LongAdderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LongAdderFactory.class);
    private static final String LONG_ADDER_CLASS_NAME = "java.util.concurrent.atomic.LongAdder";
    private static final String JAVA8_LONG_ADDER_CLASS_NAME = LongAdderFactory.class.getPackage().getName() + ".Java8LongAdderImpl";
    private static final String UNSAFE_LONG_ADDER_CLASS_NAME = LongAdderFactory.class.getPackage().getName() + ".UnsafeLongAdderImpl";
    private static final boolean JAVA8 = LongAdderFactory.isClassLoaded("java.util.concurrent.atomic.LongAdder", false) && LongAdderFactory.isClassLoaded(JAVA8_LONG_ADDER_CLASS_NAME, true);
    private static final boolean UNSAFE = LongAdderFactory.isClassLoaded(UNSAFE_LONG_ADDER_CLASS_NAME, true);
    private static final Constructor<LongAdder> JAVA8_LONG_ADDER_CONSTRUCTOR = JAVA8 ? LongAdderFactory.getJava8LongAdderConstructor() : null;

    static LongAdder create() {
        if (JAVA8 && JAVA8_LONG_ADDER_CONSTRUCTOR != null) {
            try {
                return JAVA8_LONG_ADDER_CONSTRUCTOR.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                LOG.info("Error instantiating Java8LongAdderImpl", (Throwable)e);
            }
        }
        if (UNSAFE) {
            return new UnsafeLongAdderImpl();
        }
        return new LongAdderImpl();
    }

    private static boolean isClassLoaded(String className, boolean canInitialize) {
        Class<?> clazz;
        try {
            clazz = LongAdderFactory.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        if (canInitialize) {
            try {
                clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                LOG.info("Unable to instantiate class {}", (Object)className, (Object)t);
                return false;
            }
        }
        return true;
    }

    private static Constructor<LongAdder> getJava8LongAdderConstructor() {
        try {
            Class<?> clazz = LongAdderFactory.class.getClassLoader().loadClass(JAVA8_LONG_ADDER_CLASS_NAME);
            return clazz.getConstructor(new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            LOG.info("Unable to locate nullary constructor for {}", (Object)JAVA8_LONG_ADDER_CLASS_NAME, (Object)e);
            return null;
        }
    }

    private LongAdderFactory() {
    }
}

