/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import io.dropwizard.metrics.InstrumentedExecutorService;
import io.dropwizard.metrics.InstrumentedScheduledExecutorService;
import io.dropwizard.metrics.InstrumentedThreadFactory;
import io.dropwizard.metrics.MetricRegistry;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class InstrumentedExecutors {
    public static InstrumentedExecutorService newFixedThreadPool(int nThreads, MetricRegistry registry, String name) {
        return new InstrumentedExecutorService(Executors.newFixedThreadPool(nThreads), registry, name);
    }

    public static InstrumentedExecutorService newFixedThreadPool(int nThreads, MetricRegistry registry) {
        return new InstrumentedExecutorService(Executors.newFixedThreadPool(nThreads), registry);
    }

    public static InstrumentedExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory, MetricRegistry registry, String name) {
        return new InstrumentedExecutorService(Executors.newFixedThreadPool(nThreads, threadFactory), registry, name);
    }

    public static InstrumentedExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory, MetricRegistry registry) {
        return new InstrumentedExecutorService(Executors.newFixedThreadPool(nThreads, threadFactory), registry);
    }

    public static InstrumentedExecutorService newSingleThreadExecutor(MetricRegistry registry, String name) {
        return new InstrumentedExecutorService(Executors.newSingleThreadExecutor(), registry, name);
    }

    public static InstrumentedExecutorService newSingleThreadExecutor(MetricRegistry registry) {
        return new InstrumentedExecutorService(Executors.newSingleThreadExecutor(), registry);
    }

    public static InstrumentedExecutorService newSingleThreadExecutor(ThreadFactory threadFactory, MetricRegistry registry, String name) {
        return new InstrumentedExecutorService(Executors.newSingleThreadExecutor(threadFactory), registry, name);
    }

    public static InstrumentedExecutorService newSingleThreadExecutor(ThreadFactory threadFactory, MetricRegistry registry) {
        return new InstrumentedExecutorService(Executors.newSingleThreadExecutor(threadFactory), registry);
    }

    public static InstrumentedExecutorService newCachedThreadPool(MetricRegistry registry, String name) {
        return new InstrumentedExecutorService(Executors.newCachedThreadPool(), registry, name);
    }

    public static InstrumentedExecutorService newCachedThreadPool(MetricRegistry registry) {
        return new InstrumentedExecutorService(Executors.newCachedThreadPool(), registry);
    }

    public static InstrumentedExecutorService newCachedThreadPool(ThreadFactory threadFactory, MetricRegistry registry, String name) {
        return new InstrumentedExecutorService(Executors.newCachedThreadPool(threadFactory), registry, name);
    }

    public static InstrumentedExecutorService newCachedThreadPool(ThreadFactory threadFactory, MetricRegistry registry) {
        return new InstrumentedExecutorService(Executors.newCachedThreadPool(threadFactory), registry);
    }

    public static InstrumentedScheduledExecutorService newSingleThreadScheduledExecutor(MetricRegistry registry, String name) {
        return new InstrumentedScheduledExecutorService(Executors.newSingleThreadScheduledExecutor(), registry, name);
    }

    public static InstrumentedScheduledExecutorService newSingleThreadScheduledExecutor(MetricRegistry registry) {
        return new InstrumentedScheduledExecutorService(Executors.newSingleThreadScheduledExecutor(), registry);
    }

    public static InstrumentedScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory, MetricRegistry registry, String name) {
        return new InstrumentedScheduledExecutorService(Executors.newSingleThreadScheduledExecutor(threadFactory), registry, name);
    }

    public static InstrumentedScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory, MetricRegistry registry) {
        return new InstrumentedScheduledExecutorService(Executors.newSingleThreadScheduledExecutor(threadFactory), registry);
    }

    public static InstrumentedScheduledExecutorService newScheduledThreadPool(int corePoolSize, MetricRegistry registry, String name) {
        return new InstrumentedScheduledExecutorService(Executors.newScheduledThreadPool(corePoolSize), registry, name);
    }

    public static InstrumentedScheduledExecutorService newScheduledThreadPool(int corePoolSize, MetricRegistry registry) {
        return new InstrumentedScheduledExecutorService(Executors.newScheduledThreadPool(corePoolSize), registry);
    }

    public static InstrumentedScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory, MetricRegistry registry, String name) {
        return new InstrumentedScheduledExecutorService(Executors.newScheduledThreadPool(corePoolSize, threadFactory), registry, name);
    }

    public static InstrumentedScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory, MetricRegistry registry) {
        return new InstrumentedScheduledExecutorService(Executors.newScheduledThreadPool(corePoolSize, threadFactory), registry);
    }

    public static InstrumentedThreadFactory defaultThreadFactory(MetricRegistry registry, String name) {
        return new InstrumentedThreadFactory(Executors.defaultThreadFactory(), registry, name);
    }

    public static InstrumentedThreadFactory defaultThreadFactory(MetricRegistry registry) {
        return new InstrumentedThreadFactory(Executors.defaultThreadFactory(), registry);
    }

    public static InstrumentedThreadFactory privilegedThreadFactory(MetricRegistry registry, String name) {
        return new InstrumentedThreadFactory(Executors.privilegedThreadFactory(), registry, name);
    }

    public static InstrumentedThreadFactory privilegedThreadFactory(MetricRegistry registry) {
        return new InstrumentedThreadFactory(Executors.privilegedThreadFactory(), registry);
    }

    private InstrumentedExecutors() {
    }
}

