/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.github;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.client.Http2Client;
import com.networknt.config.Config;
import com.networknt.exception.ClientException;
import com.networknt.oauth.github.GithubConfig;
import com.networknt.oauth.github.GithubMetadata;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class GithubUtil {
    private static final Logger logger = LoggerFactory.getLogger(GithubUtil.class);
    private static final String CONFIG_GITHUB = "github";
    private static final String CONFIG_SECRET = "secret";
    private static final String GITHUB_TOKEN = "githubToken";
    private static final GithubConfig config = (GithubConfig)Config.getInstance().getJsonObjectConfig("github", GithubConfig.class);
    private static final Map<String, Object> secret = Config.getInstance().getJsonMapConfig("secret");
    private static final String githubToken = (String)secret.get("githubToken");

    public static Set<String> authorize(String username) throws Exception {
        HashSet<String> groups = new HashSet<String>();
        String apiURL = GithubUtil.config.protocol + "://" + GithubUtil.config.host;
        String contentsURL = GithubUtil.config.pathPrefix + "/repos/" + GithubUtil.config.owner + "/" + GithubUtil.config.repo + "/contents/" + GithubUtil.config.path;
        Http2Client client = Http2Client.getInstance();
        CountDownLatch latch = new CountDownLatch(1);
        ClientConnection connection = (ClientConnection)client.connect(new URI(apiURL), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.EMPTY).get();
        AtomicReference reference = new AtomicReference();
        try {
            logger.info("Create request to github path: " + contentsURL);
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(contentsURL);
            request.getRequestHeaders().put(Headers.AUTHORIZATION, "token " + githubToken);
            request.getRequestHeaders().put(Headers.HOST, GithubUtil.config.host);
            request.getRequestHeaders().put(Headers.ACCEPT, "application/vnd.github.v3.raw");
            request.getRequestHeaders().put(Headers.CACHE_CONTROL, "no-cache");
            request.getRequestHeaders().put(Headers.USER_AGENT, "stevehu");
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new ClientException((Throwable)e);
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
        int statusCode = ((ClientResponse)reference.get()).getResponseCode();
        String body = (String)((ClientResponse)reference.get()).getAttachment(Http2Client.RESPONSE_BODY);
        if (logger.isDebugEnabled()) {
            logger.debug("testHttp2Get: statusCode = " + statusCode + " body = " + body);
        }
        if (statusCode == 200) {
            ObjectMapper objectMapper = new ObjectMapper();
            List listMeta = (List)objectMapper.readValue(body, (TypeReference)new TypeReference<List<GithubMetadata>>(){});
            for (GithubMetadata meta : listMeta) {
                if (!meta.userID.equals(username)) continue;
                groups.add("primary." + meta.groups.primary);
                for (String group : meta.groups.secondary) {
                    groups.add("secondary." + group);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug(meta.userID + " is attached to the following primary group: " + meta.groups.primary + " and secondary groups: " + Arrays.toString(meta.groups.secondary));
            }
        }
        return groups;
    }
}

