/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.security;

import com.hazelcast.map.IMap;
import com.networknt.oauth.cache.CacheStartupHookProvider;
import com.networknt.oauth.cache.model.Client;
import com.networknt.oauth.security.LightPasswordCredential;
import io.undertow.UndertowMessages;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.FlexBase64;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightBasicAuthenticationMechanism
implements AuthenticationMechanism {
    private static Logger logger = LoggerFactory.getLogger(LightBasicAuthenticationMechanism.class);
    public static final String SILENT = "silent";
    public static final String CHARSET = "charset";
    public static final String USER_AGENT_CHARSETS = "user-agent-charsets";
    private final String name;
    private final String challenge;
    private static final String BASIC_PREFIX = Headers.BASIC + " ";
    private static final String LOWERCASE_BASIC_PREFIX = BASIC_PREFIX.toLowerCase(Locale.ENGLISH);
    private static final int PREFIX_LENGTH = BASIC_PREFIX.length();
    private static final String COLON = ":";
    private static final Map<Pattern, Charset> EMPTY_CHARSETS_MAP = Collections.emptyMap();
    private final boolean silent;
    private final IdentityManager identityManager;
    private final Charset charset;
    private final Map<Pattern, Charset> userAgentCharsets;

    public LightBasicAuthenticationMechanism(String realmName) {
        this(realmName, "BASIC");
    }

    public LightBasicAuthenticationMechanism(String realmName, String mechanismName) {
        this(realmName, mechanismName, false);
    }

    public LightBasicAuthenticationMechanism(String realmName, String mechanismName, boolean silent) {
        this(realmName, mechanismName, silent, null);
    }

    public LightBasicAuthenticationMechanism(String realmName, String mechanismName, boolean silent, IdentityManager identityManager) {
        this(realmName, mechanismName, silent, identityManager, StandardCharsets.UTF_8, EMPTY_CHARSETS_MAP);
    }

    public LightBasicAuthenticationMechanism(String realmName, String mechanismName, boolean silent, IdentityManager identityManager, Charset charset, Map<Pattern, Charset> userAgentCharsets) {
        this.challenge = BASIC_PREFIX + "realm=\"" + realmName + "\"";
        this.name = mechanismName;
        this.silent = silent;
        this.identityManager = identityManager;
        this.charset = charset;
        this.userAgentCharsets = Collections.unmodifiableMap(new LinkedHashMap<Pattern, Charset>(userAgentCharsets));
    }

    private IdentityManager getIdentityManager(SecurityContext securityContext) {
        return this.identityManager != null ? this.identityManager : securityContext.getIdentityManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        HeaderValues authHeaders = exchange.getRequestHeaders().get(Headers.AUTHORIZATION);
        if (authHeaders != null) {
            for (String current : authHeaders) {
                int colonPos;
                if (!current.toLowerCase(Locale.ENGLISH).startsWith(LOWERCASE_BASIC_PREFIX)) continue;
                String base64Challenge = current.substring(PREFIX_LENGTH);
                String plainChallenge = null;
                try {
                    String ua;
                    ByteBuffer decode = FlexBase64.decode((String)base64Challenge);
                    Charset charset = this.charset;
                    if (!this.userAgentCharsets.isEmpty() && (ua = exchange.getRequestHeaders().getFirst(Headers.USER_AGENT)) != null) {
                        for (Map.Entry<Pattern, Charset> entry : this.userAgentCharsets.entrySet()) {
                            if (!entry.getKey().matcher(ua).find()) continue;
                            charset = entry.getValue();
                            break;
                        }
                    }
                    plainChallenge = new String(decode.array(), decode.arrayOffset(), decode.limit(), charset);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Found basic auth header %s (decoded using charset %s) in %s", new Object[]{plainChallenge, charset, exchange});
                    }
                }
                catch (IOException e) {
                    logger.error("Failed to decode basic auth header " + base64Challenge + " in " + exchange, (Throwable)e);
                }
                if (plainChallenge != null && (colonPos = plainChallenge.indexOf(COLON)) > -1) {
                    Deque userTypeDeque;
                    String userName = plainChallenge.substring(0, colonPos);
                    char[] password = plainChallenge.substring(colonPos + 1).toCharArray();
                    String clientAuthClass = null;
                    String userType = null;
                    Map params = exchange.getQueryParameters();
                    Deque clientIdDeque = (Deque)params.get("client_id");
                    if (clientIdDeque != null) {
                        String clientId = (String)clientIdDeque.getFirst();
                        IMap clients = CacheStartupHookProvider.hz.getMap("clients");
                        Client client = (Client)clients.get((Object)clientId);
                        if (client != null) {
                            clientAuthClass = client.getAuthenticateClass();
                        }
                    }
                    if ((userTypeDeque = (Deque)params.get("user_type")) != null) {
                        userType = (String)userTypeDeque.getFirst();
                    }
                    IdentityManager idm = this.getIdentityManager(securityContext);
                    LightPasswordCredential credential = new LightPasswordCredential(password, clientAuthClass, userType, exchange);
                    try {
                        AuthenticationMechanism.AuthenticationMechanismOutcome result;
                        Account account = idm.verify(userName, (Credential)credential);
                        if (account != null) {
                            securityContext.authenticationComplete(account, this.name, false);
                            result = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                        } else {
                            securityContext.authenticationFailed(UndertowMessages.MESSAGES.authenticationFailed(userName), this.name);
                            result = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                        }
                        AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = result;
                        return authenticationMechanismOutcome;
                    }
                    finally {
                        LightBasicAuthenticationMechanism.clear(password);
                    }
                }
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        String authHeader;
        if (this.silent && (authHeader = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION)) == null) {
            return AuthenticationMechanism.ChallengeResult.NOT_SENT;
        }
        exchange.getResponseHeaders().add(Headers.WWW_AUTHENTICATE, this.challenge);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending basic auth challenge %s for %s", (Object)this.challenge, (Object)exchange);
        }
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(401));
    }

    private static void clear(char[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = '\u0000';
        }
    }

    public static class Factory
    implements AuthenticationMechanismFactory {
        private final IdentityManager identityManager;

        public Factory(IdentityManager identityManager) {
            this.identityManager = identityManager;
        }

        public AuthenticationMechanism create(String mechanismName, FormParserFactory formParserFactory, Map<String, String> properties) {
            String realm = properties.get("realm");
            String silent = properties.get(LightBasicAuthenticationMechanism.SILENT);
            String charsetString = properties.get(LightBasicAuthenticationMechanism.CHARSET);
            Charset charset = charsetString == null ? StandardCharsets.UTF_8 : Charset.forName(charsetString);
            HashMap<Pattern, Charset> userAgentCharsets = new HashMap<Pattern, Charset>();
            String userAgentString = properties.get(LightBasicAuthenticationMechanism.USER_AGENT_CHARSETS);
            if (userAgentString != null) {
                String[] parts = userAgentString.split(",");
                if (parts.length % 2 != 0) {
                    throw UndertowMessages.MESSAGES.userAgentCharsetMustHaveEvenNumberOfItems(userAgentString);
                }
                for (int i = 0; i < parts.length; i += 2) {
                    Pattern pattern = Pattern.compile(parts[i]);
                    Charset c = Charset.forName(parts[i + 1]);
                    userAgentCharsets.put(pattern, c);
                }
            }
            return new LightBasicAuthenticationMechanism(realm, mechanismName, silent != null && silent.equals("true"), this.identityManager, charset, userAgentCharsets);
        }
    }
}

