/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.security;

import com.hazelcast.map.IMap;
import com.networknt.oauth.cache.CacheStartupHookProvider;
import com.networknt.oauth.cache.model.Client;
import com.networknt.oauth.security.LightPasswordCredential;
import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.session.Session;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.RedirectBuilder;
import io.undertow.util.Sessions;
import java.io.IOException;

public class LightFormAuthenticationMechanism
implements AuthenticationMechanism {
    public static final String LOCATION_ATTRIBUTE = LightFormAuthenticationMechanism.class.getName() + ".LOCATION";
    public static final String DEFAULT_POST_LOCATION = "/j_security_check";
    private final String name;
    private final String loginPage;
    private final String errorPage;
    private final String postLocation;
    private final FormParserFactory formParserFactory;
    private final IdentityManager identityManager;

    public LightFormAuthenticationMechanism(String name, String loginPage, String errorPage) {
        this(FormParserFactory.builder().build(), name, loginPage, errorPage);
    }

    public LightFormAuthenticationMechanism(String name, String loginPage, String errorPage, String postLocation) {
        this(FormParserFactory.builder().build(), name, loginPage, errorPage, postLocation);
    }

    public LightFormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage) {
        this(formParserFactory, name, loginPage, errorPage, DEFAULT_POST_LOCATION);
    }

    public LightFormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage, IdentityManager identityManager) {
        this(formParserFactory, name, loginPage, errorPage, DEFAULT_POST_LOCATION, identityManager);
    }

    public LightFormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage, String postLocation) {
        this(formParserFactory, name, loginPage, errorPage, postLocation, null);
    }

    public LightFormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage, String postLocation, IdentityManager identityManager) {
        this.name = name;
        this.loginPage = loginPage;
        this.errorPage = errorPage;
        this.postLocation = postLocation;
        this.formParserFactory = formParserFactory;
        this.identityManager = identityManager;
    }

    private IdentityManager getIdentityManager(SecurityContext securityContext) {
        return this.identityManager != null ? this.identityManager : securityContext.getIdentityManager();
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        if (exchange.getRequestPath().endsWith(this.postLocation) && exchange.getRequestMethod().equals(Methods.POST)) {
            return this.runFormAuth(exchange, securityContext);
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationMechanism.AuthenticationMechanismOutcome runFormAuth(HttpServerExchange exchange, SecurityContext securityContext) {
        FormDataParser parser = this.formParserFactory.createParser(exchange);
        if (parser == null) {
            UndertowLogger.SECURITY_LOGGER.debug((Object)"Could not authenticate as no form parser is present");
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        try {
            FormData data = parser.parseBlocking();
            FormData.FormValue jUsername = data.getFirst("j_username");
            FormData.FormValue jPassword = data.getFirst("j_password");
            FormData.FormValue jClientId = data.getFirst("client_id");
            FormData.FormValue jUserType = data.getFirst("user_type");
            if (jUsername == null || jPassword == null) {
                UndertowLogger.SECURITY_LOGGER.debugf("Could not authenticate as username or password was not present in the posted result for %s", (Object)exchange);
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            String userName = jUsername.getValue();
            String password = jPassword.getValue();
            String userType = jUserType.getValue();
            String clientId = jClientId.getValue();
            String clientAuthClass = null;
            IMap clients = CacheStartupHookProvider.hz.getMap("clients");
            Client client = (Client)clients.get((Object)clientId);
            if (client != null) {
                clientAuthClass = client.getAuthenticateClass();
            }
            AuthenticationMechanism.AuthenticationMechanismOutcome outcome = null;
            LightPasswordCredential credential = new LightPasswordCredential(password.toCharArray(), clientAuthClass, userType, exchange);
            try {
                IdentityManager identityManager = this.getIdentityManager(securityContext);
                Account account = identityManager.verify(userName, (Credential)credential);
                if (account != null) {
                    securityContext.authenticationComplete(account, this.name, true);
                    UndertowLogger.SECURITY_LOGGER.debugf("Authenticated user %s using for auth for %s", (Object)account.getPrincipal().getName(), (Object)exchange);
                    outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                } else {
                    securityContext.authenticationFailed(UndertowMessages.MESSAGES.authenticationFailed(userName), this.name);
                }
                return outcome != null ? outcome : AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            catch (Throwable throwable) {
                return outcome != null ? outcome : AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        if (exchange.getRequestPath().endsWith(this.postLocation) && exchange.getRequestMethod().equals(Methods.POST)) {
            UndertowLogger.SECURITY_LOGGER.debugf("Serving form auth error page %s for %s", (Object)this.loginPage, (Object)exchange);
            Integer code = this.servePage(exchange, this.errorPage);
            return new AuthenticationMechanism.ChallengeResult(true, code);
        }
        UndertowLogger.SECURITY_LOGGER.debugf("Serving login form %s for %s", (Object)this.loginPage, (Object)exchange);
        this.storeInitialLocation(exchange);
        Integer code = this.servePage(exchange, this.loginPage);
        return new AuthenticationMechanism.ChallengeResult(true, code);
    }

    protected void storeInitialLocation(HttpServerExchange exchange) {
        Session session = Sessions.getOrCreateSession((HttpServerExchange)exchange);
        session.setAttribute(LOCATION_ATTRIBUTE, (Object)RedirectBuilder.redirect((HttpServerExchange)exchange, (String)exchange.getRelativePath()));
    }

    protected Integer servePage(HttpServerExchange exchange, String location) {
        LightFormAuthenticationMechanism.sendRedirect(exchange, location);
        return 307;
    }

    static void sendRedirect(HttpServerExchange exchange, String location) {
        String loc = exchange.getRequestScheme() + "://" + exchange.getHostAndPort() + location;
        exchange.getResponseHeaders().put(Headers.LOCATION, loc);
    }
}

