/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.security;

import com.hazelcast.map.IMap;
import com.networknt.oauth.cache.CacheStartupHookProvider;
import com.networknt.oauth.cache.model.Client;
import com.networknt.oauth.security.LightGSSContextCredential;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.GSSAPIServerSubjectFactory;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.proxy.ExclusivityChecker;
import io.undertow.util.AttachmentKey;
import io.undertow.util.FlexBase64;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Deque;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightGSSAPIAuthenticationMechanism
implements AuthenticationMechanism {
    private static Logger logger = LoggerFactory.getLogger(LightGSSAPIAuthenticationMechanism.class);
    public static final ExclusivityChecker EXCLUSIVITY_CHECKER = new ExclusivityChecker(){

        public boolean isExclusivityRequired(HttpServerExchange exchange) {
            HeaderValues authHeaders = exchange.getRequestHeaders().get(Headers.AUTHORIZATION);
            if (authHeaders != null) {
                for (String current : authHeaders) {
                    if (!current.startsWith(NEGOTIATE_PREFIX)) continue;
                    return true;
                }
            }
            return false;
        }
    };
    private static final String NEGOTIATION_PLAIN = Headers.NEGOTIATE.toString();
    private static final String NEGOTIATE_PREFIX = Headers.NEGOTIATE + " ";
    private static final Oid[] DEFAULT_MECHANISMS;
    private static final String name = "SPNEGO";
    private final IdentityManager identityManager;
    private final GSSAPIServerSubjectFactory subjectFactory;
    private final Oid[] mechanisms;

    public LightGSSAPIAuthenticationMechanism(GSSAPIServerSubjectFactory subjectFactory, IdentityManager identityManager, Oid ... supportedMechanisms) {
        this.subjectFactory = subjectFactory;
        this.identityManager = identityManager;
        this.mechanisms = supportedMechanisms;
    }

    public LightGSSAPIAuthenticationMechanism(GSSAPIServerSubjectFactory subjectFactory, Oid ... supportedMechanisms) {
        this(subjectFactory, (IdentityManager)null, supportedMechanisms);
    }

    public LightGSSAPIAuthenticationMechanism(GSSAPIServerSubjectFactory subjectFactory) {
        this(subjectFactory, DEFAULT_MECHANISMS);
    }

    private IdentityManager getIdentityManager(SecurityContext securityContext) {
        return this.identityManager != null ? this.identityManager : securityContext.getIdentityManager();
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        HeaderValues authHeaders;
        ServerConnection connection = exchange.getConnection();
        NegotiationContext negContext = (NegotiationContext)connection.getAttachment(NegotiationContext.ATTACHMENT_KEY);
        if (negContext != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Existing negotiation context found for %s", (Object)exchange);
            }
            exchange.putAttachment(NegotiationContext.ATTACHMENT_KEY, (Object)negContext);
            if (negContext.isEstablished()) {
                Account account;
                Deque userTypeDeque;
                IdentityManager identityManager = this.getIdentityManager(securityContext);
                String clientAuthClass = null;
                String userType = null;
                Map params = exchange.getQueryParameters();
                Deque clientIdDeque = (Deque)params.get("client_id");
                if (clientIdDeque != null) {
                    String clientId = (String)clientIdDeque.getFirst();
                    IMap clients = CacheStartupHookProvider.hz.getMap("clients");
                    Client client = (Client)clients.get((Object)clientId);
                    if (client != null) {
                        clientAuthClass = client.getAuthenticateClass();
                    }
                }
                if ((userTypeDeque = (Deque)params.get("user_type")) != null) {
                    userType = (String)userTypeDeque.getFirst();
                }
                if ((account = identityManager.verify((Credential)new LightGSSContextCredential(negContext.getGssContext(), clientAuthClass, userType))) != null) {
                    securityContext.authenticationComplete(account, name, false);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Authenticated as user %s with existing GSSAPI negotiation context for %s", (Object)account.getPrincipal().getName(), (Object)exchange);
                    }
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to authenticate with existing GSSAPI negotiation context for %s", (Object)exchange);
                }
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        }
        if ((authHeaders = exchange.getRequestHeaders().get(Headers.AUTHORIZATION)) != null) {
            for (String current : authHeaders) {
                if (!current.startsWith(NEGOTIATE_PREFIX)) continue;
                String base64Challenge = current.substring(NEGOTIATE_PREFIX.length());
                try {
                    ByteBuffer challenge = FlexBase64.decode((String)base64Challenge);
                    return this.runGSSAPI(exchange, challenge, securityContext);
                }
                catch (IOException iOException) {
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                }
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        NegotiationContext negContext = (NegotiationContext)exchange.getAttachment(NegotiationContext.ATTACHMENT_KEY);
        Object header = NEGOTIATION_PLAIN;
        if (negContext != null) {
            byte[] responseChallenge = negContext.useResponseToken();
            exchange.putAttachment(NegotiationContext.ATTACHMENT_KEY, null);
            if (responseChallenge != null) {
                header = NEGOTIATE_PREFIX + FlexBase64.encodeString((byte[])responseChallenge, (boolean)false);
            }
        } else {
            Subject server = null;
            try {
                server = this.subjectFactory.getSubjectForHost(this.getHostName(exchange));
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            if (server == null) {
                return AuthenticationMechanism.ChallengeResult.NOT_SENT;
            }
        }
        exchange.getResponseHeaders().add(Headers.WWW_AUTHENTICATE, (String)header);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending GSSAPI challenge for %s", (Object)exchange);
        }
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(401));
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome runGSSAPI(HttpServerExchange exchange, ByteBuffer challenge, SecurityContext securityContext) {
        try {
            Subject server = this.subjectFactory.getSubjectForHost(this.getHostName(exchange));
            return Subject.doAs(server, new AcceptSecurityContext(exchange, challenge, securityContext));
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
    }

    private String getHostName(HttpServerExchange exchange) {
        String hostName = exchange.getRequestHeaders().getFirst(Headers.HOST);
        if (hostName != null) {
            if (hostName.startsWith("[") && hostName.contains("]")) {
                hostName = hostName.substring(0, hostName.indexOf(93) + 1);
            } else if (hostName.contains(":")) {
                hostName = hostName.substring(0, hostName.indexOf(":"));
            }
            return hostName;
        }
        return null;
    }

    static {
        try {
            Oid spnego = new Oid("1.3.6.1.5.5.2");
            Oid kerberos = new Oid("1.2.840.113554.1.2.2");
            DEFAULT_MECHANISMS = new Oid[]{spnego, kerberos};
        }
        catch (GSSException e) {
            throw new RuntimeException(e);
        }
    }

    private static class NegotiationContext {
        static final AttachmentKey<NegotiationContext> ATTACHMENT_KEY = AttachmentKey.create(NegotiationContext.class);
        private GSSContext gssContext;
        private byte[] responseToken;
        private Principal principal;

        private NegotiationContext() {
        }

        GSSContext getGssContext() {
            return this.gssContext;
        }

        void setGssContext(GSSContext gssContext) {
            this.gssContext = gssContext;
        }

        byte[] useResponseToken() {
            try {
                byte[] byArray = this.responseToken;
                return byArray;
            }
            finally {
                this.responseToken = null;
            }
        }

        void setResponseToken(byte[] responseToken) {
            this.responseToken = responseToken;
        }

        boolean isEstablished() {
            return this.gssContext != null ? this.gssContext.isEstablished() : false;
        }

        Principal getPrincipal() {
            if (!this.isEstablished()) {
                throw new IllegalStateException("No established GSSContext to use for the Principal.");
            }
            if (this.principal == null) {
                try {
                    this.principal = new KerberosPrincipal(this.gssContext.getSrcName().toString());
                }
                catch (GSSException e) {
                    throw new IllegalStateException("Unable to create Principal", e);
                }
            }
            return this.principal;
        }
    }

    private class AcceptSecurityContext
    implements PrivilegedExceptionAction<AuthenticationMechanism.AuthenticationMechanismOutcome> {
        private final HttpServerExchange exchange;
        private final ByteBuffer challenge;
        private final SecurityContext securityContext;

        private AcceptSecurityContext(HttpServerExchange exchange, ByteBuffer challenge, SecurityContext securityContext) {
            this.exchange = exchange;
            this.challenge = challenge;
            this.securityContext = securityContext;
        }

        @Override
        public AuthenticationMechanism.AuthenticationMechanismOutcome run() throws GSSException {
            GSSContext gssContext;
            NegotiationContext negContext = (NegotiationContext)this.exchange.getAttachment(NegotiationContext.ATTACHMENT_KEY);
            if (negContext == null) {
                negContext = new NegotiationContext();
                this.exchange.putAttachment(NegotiationContext.ATTACHMENT_KEY, (Object)negContext);
                this.exchange.getConnection().putAttachment(NegotiationContext.ATTACHMENT_KEY, (Object)negContext);
            }
            if ((gssContext = negContext.getGssContext()) == null) {
                GSSManager manager = GSSManager.getInstance();
                GSSCredential credential = manager.createCredential(null, Integer.MAX_VALUE, LightGSSAPIAuthenticationMechanism.this.mechanisms, 2);
                gssContext = manager.createContext(credential);
                negContext.setGssContext(gssContext);
            }
            byte[] respToken = gssContext.acceptSecContext(this.challenge.array(), this.challenge.arrayOffset(), this.challenge.limit());
            negContext.setResponseToken(respToken);
            if (negContext.isEstablished()) {
                Account account;
                Deque userTypeDeque;
                if (respToken != null) {
                    this.exchange.getResponseHeaders().add(Headers.WWW_AUTHENTICATE, NEGOTIATE_PREFIX + FlexBase64.encodeString((byte[])respToken, (boolean)false));
                }
                IdentityManager identityManager = this.securityContext.getIdentityManager();
                String clientAuthClass = null;
                String userType = null;
                Map params = this.exchange.getQueryParameters();
                Deque clientIdDeque = (Deque)params.get("client_id");
                if (clientIdDeque != null) {
                    String clientId = (String)clientIdDeque.getFirst();
                    IMap clients = CacheStartupHookProvider.hz.getMap("clients");
                    Client client = (Client)clients.get((Object)clientId);
                    if (client != null) {
                        clientAuthClass = client.getAuthenticateClass();
                    }
                }
                if ((userTypeDeque = (Deque)params.get("user_type")) != null) {
                    userType = (String)userTypeDeque.getFirst();
                }
                if ((account = identityManager.verify((Credential)new LightGSSContextCredential(negContext.getGssContext(), clientAuthClass, userType))) != null) {
                    this.securityContext.authenticationComplete(account, LightGSSAPIAuthenticationMechanism.name, false);
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                }
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
    }
}

