/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.spnego;

import com.networknt.config.Config;
import com.networknt.oauth.spnego.SpnegoConfig;
import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class KerberosKDCUtil {
    static final String CONFIG_SPNEGO = "spnego";
    static final SpnegoConfig config = (SpnegoConfig)Config.getInstance().getJsonObjectConfig("spnego", SpnegoConfig.class);

    public static Subject login(String userName, char[] password) throws LoginException {
        Subject theSubject = new Subject();
        UsernamePasswordCBH cbh = new UsernamePasswordCBH(userName, password);
        LoginContext lc = new LoginContext("KDC", theSubject, cbh, KerberosKDCUtil.createJaasConfiguration());
        lc.login();
        return theSubject;
    }

    private static Configuration createJaasConfiguration() {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                if (!"KDC".equals(name)) {
                    throw new IllegalArgumentException("Unexpected name '" + name + "'");
                }
                AppConfigurationEntry[] entries = new AppConfigurationEntry[1];
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("debug", config.getDebug());
                options.put("refreshKrb5Config", "true");
                options.put("storeKey", "true");
                if ("true".equalsIgnoreCase(config.getUseKeyTab())) {
                    options.put("useKeyTab", config.getUseKeyTab());
                    options.put("keyTab", config.getKeyTab());
                    options.put("principal", config.getPrincipal());
                }
                options.put("isInitiator", "true");
                entries[0] = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                return entries;
            }
        };
    }

    private static class UsernamePasswordCBH
    implements CallbackHandler {
        private final String username;
        private final char[] password;

        private UsernamePasswordCBH(String username, char[] password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.username);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }
}

