/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.management.dto.ClientBwListEntryDTO;

public final class ClientBwListEntryCodec {
    private static final int TYPE_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 4;

    private ClientBwListEntryCodec() {
    }

    public static void encode(ClientMessage clientMessage, ClientBwListEntryDTO clientBwListEntry) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[4]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, clientBwListEntry.getType());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, clientBwListEntry.getValue());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static ClientBwListEntryDTO decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        int type = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        String value = StringCodec.decode(iterator2);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return CustomTypeFactory.createClientBwListEntry(type, value);
    }
}

