/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;

public final class FieldDescriptorCodec {
    private static final int KIND_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 4;

    private FieldDescriptorCodec() {
    }

    public static void encode(ClientMessage clientMessage, FieldDescriptor fieldDescriptor) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[4]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, fieldDescriptor.getKind());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, fieldDescriptor.getFieldName());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static FieldDescriptor decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        int kind = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        String fieldName = StringCodec.decode(iterator2);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return CustomTypeFactory.createFieldDescriptor(fieldName, kind);
    }
}

