/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.core;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.EventObject;
import java.util.UUID;

@SuppressFBWarnings(value={"SE_BAD_FIELD"})
public class DistributedObjectEvent
extends EventObject {
    private static final long serialVersionUID = -4532279189146831926L;
    protected DistributedObject distributedObject;
    private EventType eventType;
    private String serviceName;
    private String objectName;

    public DistributedObjectEvent(EventType eventType, String serviceName, String objectName, DistributedObject distributedObject, UUID source2) {
        super(source2);
        this.eventType = eventType;
        this.serviceName = serviceName;
        this.objectName = objectName;
        this.distributedObject = distributedObject;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public Object getObjectName() {
        return this.objectName;
    }

    public DistributedObject getDistributedObject() {
        if (EventType.DESTROYED.equals((Object)this.eventType)) {
            throw new DistributedObjectDestroyedException(this.objectName + " destroyed!");
        }
        return this.distributedObject;
    }

    @Override
    public String toString() {
        return "DistributedObjectEvent{distributedObject=" + this.distributedObject + ", eventType=" + (Object)((Object)this.eventType) + ", serviceName='" + this.serviceName + '\'' + ", objectName='" + this.objectName + '\'' + ", source=" + this.source + '}';
    }

    public static enum EventType {
        CREATED,
        DESTROYED;

    }
}

