/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal;

import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.cp.CPGroup;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.event.CPMembershipEvent;
import com.hazelcast.cp.event.impl.CPMembershipEventImpl;
import com.hazelcast.cp.exception.CPGroupDestroyedException;
import com.hazelcast.cp.internal.CPGroupInfo;
import com.hazelcast.cp.internal.CPGroupSummary;
import com.hazelcast.cp.internal.CPMemberInfo;
import com.hazelcast.cp.internal.MembershipChangeSchedule;
import com.hazelcast.cp.internal.MetadataRaftGroupSnapshot;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftGroupMembershipManager;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.exception.CannotCreateRaftGroupException;
import com.hazelcast.cp.internal.exception.CannotRemoveCPMemberException;
import com.hazelcast.cp.internal.exception.MetadataRaftGroupInitInProgressException;
import com.hazelcast.cp.internal.persistence.CPMetadataStore;
import com.hazelcast.cp.internal.raft.SnapshotAwareService;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.RaftNode;
import com.hazelcast.cp.internal.raft.impl.RaftNodeImpl;
import com.hazelcast.cp.internal.raftop.metadata.InitMetadataRaftGroupOp;
import com.hazelcast.cp.internal.raftop.metadata.PublishActiveCPMembersOp;
import com.hazelcast.cp.internal.raftop.metadata.TerminateRaftNodesOp;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class MetadataRaftGroupManager
implements SnapshotAwareService<MetadataRaftGroupSnapshot> {
    public static final RaftGroupId INITIAL_METADATA_GROUP_ID = new RaftGroupId("METADATA", 0L, 0L);
    private static final long DISCOVER_INITIAL_CP_MEMBERS_TASK_DELAY_MILLIS = 1000L;
    private static final long DISCOVER_INITIAL_CP_MEMBERS_TASK_LOGGING_DELAY_MILLIS = 5000L;
    private static final long BROADCAST_ACTIVE_CP_MEMBERS_TASK_PERIOD_SECONDS = 10L;
    private final NodeEngineImpl nodeEngine;
    private final RaftService raftService;
    private final RaftGroupMembershipManager membershipManager;
    private final ILogger logger;
    private final CPSubsystemConfig config;
    private final AtomicReference<CPMemberInfo> localCPMember = new AtomicReference();
    private final AtomicReference<RaftGroupId> metadataGroupIdRef = new AtomicReference<RaftGroupId>(INITIAL_METADATA_GROUP_ID);
    private final AtomicBoolean discoveryCompleted = new AtomicBoolean();
    private final boolean cpSubsystemEnabled;
    private volatile DiscoverInitialCPMembersTask currentDiscoveryTask;
    @Probe(name="groups")
    private final ConcurrentMap<CPGroupId, CPGroupInfo> groups = new ConcurrentHashMap<CPGroupId, CPGroupInfo>();
    @Probe(name="activeMembers")
    private volatile Collection<CPMemberInfo> activeMembers = Collections.emptySet();
    @Probe(name="activeMembersCommitIndex")
    private volatile long activeMembersCommitIndex;
    private volatile List<CPMemberInfo> initialCPMembers;
    private volatile MembershipChangeSchedule membershipChangeSchedule;
    private volatile MetadataRaftGroupInitStatus initializationStatus = MetadataRaftGroupInitStatus.IN_PROGRESS;
    private final Set<CPMemberInfo> initializedCPMembers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Long> initializationCommitIndices = Collections.newSetFromMap(new ConcurrentHashMap());

    MetadataRaftGroupManager(NodeEngineImpl nodeEngine, RaftService raftService, CPSubsystemConfig config) {
        this.nodeEngine = nodeEngine;
        this.raftService = raftService;
        this.membershipManager = new RaftGroupMembershipManager(nodeEngine, raftService);
        this.logger = nodeEngine.getLogger(this.getClass());
        this.config = config;
        this.cpSubsystemEnabled = raftService.isCpSubsystemEnabled();
    }

    boolean init() {
        if (this.cpSubsystemEnabled) {
            this.scheduleDiscoverInitialCPMembersTask(true);
        } else {
            this.disableDiscovery();
        }
        return this.cpSubsystemEnabled;
    }

    void initPromotedCPMember(CPMemberInfo member) {
        if (!this.localCPMember.compareAndSet(null, member)) {
            return;
        }
        try {
            this.getCpMetadataStore().persistLocalCPMember(member);
        }
        catch (IOException e) {
            throw new HazelcastException(e);
        }
        this.scheduleGroupMembershipManagementTasks();
    }

    private void scheduleGroupMembershipManagementTasks() {
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        executionService.scheduleWithRepetition("hz:cpSubsystemManagement", new BroadcastActiveCPMembersTask(), 0L, 10L, TimeUnit.SECONDS);
        this.membershipManager.init();
    }

    void restart(long seed) {
        this.activeMembers = Collections.emptySet();
        this.activeMembersCommitIndex = 0L;
        this.groups.clear();
        this.initialCPMembers = null;
        this.initializationStatus = MetadataRaftGroupInitStatus.IN_PROGRESS;
        this.initializedCPMembers.clear();
        this.initializationCommitIndices.clear();
        this.membershipChangeSchedule = null;
        this.localCPMember.set(null);
        DiscoverInitialCPMembersTask discoveryTask = this.currentDiscoveryTask;
        if (discoveryTask != null) {
            discoveryTask.cancelAndAwaitCompletion();
        }
        this.discoveryCompleted.set(false);
        RaftGroupId newMetadataGroupId = new RaftGroupId("METADATA", seed, 0L);
        this.logger.fine("New METADATA groupId: " + newMetadataGroupId);
        this.metadataGroupIdRef.set(newMetadataGroupId);
        try {
            this.getCpMetadataStore().persistMetadataGroupId(newMetadataGroupId);
        }
        catch (IOException e) {
            throw new HazelcastException(e);
        }
        this.scheduleDiscoverInitialCPMembersTask(false);
    }

    @Override
    public MetadataRaftGroupSnapshot takeSnapshot(CPGroupId groupId, long commitIndex) {
        if (!this.getMetadataGroupId().equals(groupId)) {
            return null;
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Taking snapshot for commit-index: " + commitIndex);
        }
        MetadataRaftGroupSnapshot snapshot = new MetadataRaftGroupSnapshot(this.activeMembers, this.activeMembersCommitIndex, this.groups.values(), this.membershipChangeSchedule, this.initialCPMembers, this.initializedCPMembers, this.initializationStatus, this.initializationCommitIndices);
        return snapshot;
    }

    @Override
    public void restoreSnapshot(CPGroupId groupId, long commitIndex, MetadataRaftGroupSnapshot snapshot) {
        this.ensureMetadataGroupId(groupId);
        Preconditions.checkNotNull(snapshot);
        HashSet<RaftGroupId> snapshotGroupIds = new HashSet<RaftGroupId>();
        for (CPGroupInfo group : snapshot.getGroups()) {
            this.groups.put(group.id(), group);
            snapshotGroupIds.add(group.id());
        }
        this.groups.keySet().removeIf(cpGroupId -> !snapshotGroupIds.contains(cpGroupId));
        this.doSetActiveMembers(snapshot.getMembersCommitIndex(), new LinkedHashSet<CPMemberInfo>(snapshot.getMembers()));
        this.membershipChangeSchedule = snapshot.getMembershipChangeSchedule();
        this.initialCPMembers = snapshot.getInitialCPMembers();
        this.initializedCPMembers.clear();
        this.initializedCPMembers.addAll(snapshot.getInitializedCPMembers());
        this.initializationStatus = snapshot.getInitializationStatus();
        this.initializationCommitIndices.clear();
        this.initializationCommitIndices.addAll(snapshot.getInitializationCommitIndices());
        for (CPGroupInfo group : snapshot.getGroups()) {
            if (group.status() != CPGroup.CPGroupStatus.DESTROYED) continue;
            this.terminateRaftNodeAsync(group.id());
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Restored snapshot at commit-index: " + commitIndex);
        }
    }

    private void ensureMetadataGroupId(CPGroupId groupId) {
        RaftGroupId metadataGroupId = this.getMetadataGroupId();
        Preconditions.checkTrue(((Object)metadataGroupId).equals(groupId), "Invalid RaftGroupId! Expected: " + metadataGroupId + ", Actual: " + groupId);
    }

    CPMemberInfo getLocalCPMember() {
        return this.localCPMember.get();
    }

    public RaftGroupId getMetadataGroupId() {
        return this.metadataGroupIdRef.get();
    }

    public void restoreMetadataGroupId(RaftGroupId restoredMetadataGroupId) {
        if (this.raftService.isStartCompleted()) {
            throw new IllegalStateException("Cannot set metadata groupId after start process is completed!");
        }
        RaftGroupId currentMetadataGroupId = this.getMetadataGroupId();
        if (restoredMetadataGroupId.getSeed() <= currentMetadataGroupId.getSeed()) {
            this.logger.fine("Not restoring METADATA groupId: " + restoredMetadataGroupId + " because the current METADATA groupId: " + currentMetadataGroupId + " is newer.");
            return;
        }
        if (currentMetadataGroupId.getSeed() != INITIAL_METADATA_GROUP_ID.getSeed() || this.initializationStatus != MetadataRaftGroupInitStatus.IN_PROGRESS || !this.initializedCPMembers.isEmpty() || !this.groups.isEmpty()) {
            throw new IllegalStateException("Metadata groupId is not allowed to be set!");
        }
        this.metadataGroupIdRef.set(restoredMetadataGroupId);
        this.logger.fine("Restored METADATA groupId: " + restoredMetadataGroupId);
    }

    public void restoreLocalCPMember(CPMemberInfo member) {
        Preconditions.checkNotNull(member);
        if (this.raftService.isStartCompleted()) {
            throw new IllegalStateException("Cannot set local CP member after start process is completed!");
        }
        if (!this.localCPMember.compareAndSet(null, member)) {
            throw new IllegalStateException("Local CP member is already set! Current: " + this.localCPMember.get());
        }
        this.scheduleGroupMembershipManagementTasks();
    }

    long getGroupIdSeed() {
        return this.getMetadataGroupId().getSeed();
    }

    public Collection<CPGroupId> getGroupIds() {
        ArrayList<CPGroupId> groupIds = new ArrayList<CPGroupId>(this.groups.keySet());
        groupIds.sort(new CPGroupIdComparator());
        return groupIds;
    }

    public Collection<CPGroupId> getActiveGroupIds() {
        ArrayList<CPGroupId> activeGroupIds = new ArrayList<CPGroupId>(1);
        for (CPGroupInfo group : this.groups.values()) {
            if (group.status() != CPGroup.CPGroupStatus.ACTIVE) continue;
            activeGroupIds.add(group.id());
        }
        activeGroupIds.sort(new CPGroupIdComparator());
        return activeGroupIds;
    }

    public CPGroupSummary getGroup(CPGroupId groupId) {
        Preconditions.checkNotNull(groupId);
        if (groupId instanceof RaftGroupId && ((RaftGroupId)groupId).getSeed() < this.getGroupIdSeed()) {
            throw new CPGroupDestroyedException(groupId);
        }
        CPGroupInfo group = (CPGroupInfo)this.groups.get(groupId);
        return group != null ? group.toSummary(this.activeMembers) : null;
    }

    public CPGroupSummary getActiveGroup(String groupName) {
        for (CPGroupInfo group : this.groups.values()) {
            if (group.status() != CPGroup.CPGroupStatus.ACTIVE || !group.name().equals(groupName)) continue;
            return group.toSummary(this.activeMembers);
        }
        return null;
    }

    public void rebalanceGroupLeaderships() {
        if (!this.isMetadataGroupLeader()) {
            return;
        }
        this.membershipManager.rebalanceGroupLeaderships();
    }

    public boolean initMetadataGroup(long commitIndex, CPMemberInfo callerCPMember, List<CPMemberInfo> discoveredCPMembers, long expectedGroupIdSeed) {
        long groupIdSeed;
        String msg;
        Preconditions.checkNotNull(discoveredCPMembers);
        if (this.initializationStatus == MetadataRaftGroupInitStatus.FAILED) {
            String msg2 = callerCPMember + "committed CP member list: " + discoveredCPMembers + " after CP Subsystem discovery has already failed.";
            this.logger.severe(msg2);
            throw new IllegalArgumentException(msg2);
        }
        if (discoveredCPMembers.size() != this.config.getCPMemberCount()) {
            msg = callerCPMember + "'s discovered CP member list: " + discoveredCPMembers + " must consist of " + this.config.getCPMemberCount() + " CP members";
            this.failMetadataRaftGroupInitializationIfNotCompletedAndThrow(msg);
        }
        if (!(this.initialCPMembers == null || this.initialCPMembers.size() == discoveredCPMembers.size() && this.initialCPMembers.containsAll(discoveredCPMembers))) {
            msg = "Invalid initial CP members! Expected: " + this.initialCPMembers + ", Actual: " + discoveredCPMembers;
            this.failMetadataRaftGroupInitializationIfNotCompletedAndThrow(msg);
        }
        if ((groupIdSeed = this.getGroupIdSeed()) != expectedGroupIdSeed) {
            String msg3 = "Cannot create METADATA CP group. Local groupId seed: " + groupIdSeed + ", expected groupId seed: " + expectedGroupIdSeed;
            this.failMetadataRaftGroupInitializationIfNotCompletedAndThrow(msg3);
        }
        ArrayList<RaftEndpoint> discoveredMetadataEndpoints = new ArrayList<RaftEndpoint>();
        for (CPMemberInfo member : discoveredCPMembers) {
            if (discoveredMetadataEndpoints.size() == this.config.getGroupSize()) break;
            discoveredMetadataEndpoints.add(member.toRaftEndpoint());
        }
        CPGroupInfo metadataGroup = new CPGroupInfo(this.getMetadataGroupId(), discoveredMetadataEndpoints);
        CPGroupInfo existingMetadataGroup = this.groups.putIfAbsent(this.getMetadataGroupId(), metadataGroup);
        if (existingMetadataGroup != null) {
            Collection<RaftEndpoint> metadataEndpoints = existingMetadataGroup.initialMembers();
            if (discoveredMetadataEndpoints.size() != metadataEndpoints.size() || !metadataEndpoints.containsAll(discoveredMetadataEndpoints)) {
                String msg4 = "Cannot create METADATA CP group with " + this.config.getCPMemberCount() + " because it already exists with a different member list: " + existingMetadataGroup;
                this.failMetadataRaftGroupInitializationIfNotCompletedAndThrow(msg4);
            }
        }
        if (this.initializationStatus == MetadataRaftGroupInitStatus.SUCCESSFUL) {
            return true;
        }
        this.initializationCommitIndices.add(commitIndex);
        if (!this.initializedCPMembers.add(callerCPMember)) {
            return false;
        }
        this.logger.fine("METADATA " + metadataGroup + " initialization is committed for " + callerCPMember + " with seed: " + expectedGroupIdSeed + " and discovered CP members: " + discoveredCPMembers);
        this.initialCPMembers = Collections.unmodifiableList(new ArrayList<CPMemberInfo>(discoveredCPMembers));
        this.doSetActiveMembers(commitIndex, new LinkedHashSet<CPMemberInfo>(discoveredCPMembers));
        if (this.initializedCPMembers.size() == this.config.getCPMemberCount()) {
            this.initializationCommitIndices.remove(commitIndex);
            this.logger.fine("METADATA " + metadataGroup + " initialization is completed with: " + this.initializedCPMembers);
            this.initializationStatus = MetadataRaftGroupInitStatus.SUCCESSFUL;
            ArrayList<Long> completed = new ArrayList<Long>(this.initializationCommitIndices);
            this.initializedCPMembers.clear();
            this.initializationCommitIndices.clear();
            this.raftService.updateInvocationManagerMembers(groupIdSeed, commitIndex, this.activeMembers);
            this.completeFutures(this.getMetadataGroupId(), completed, null);
            return true;
        }
        return false;
    }

    private void failMetadataRaftGroupInitializationIfNotCompletedAndThrow(String error) {
        this.logger.severe(error);
        IllegalArgumentException exception = new IllegalArgumentException(error);
        if (this.initializationStatus == MetadataRaftGroupInitStatus.IN_PROGRESS) {
            this.initializationStatus = MetadataRaftGroupInitStatus.FAILED;
            this.completeFutures(this.getMetadataGroupId(), this.initializationCommitIndices, exception);
            this.initializedCPMembers.clear();
            this.initializationCommitIndices.clear();
        }
        throw exception;
    }

    public CPGroupSummary createRaftGroup(String groupName, Collection<RaftEndpoint> groupEndpoints, long groupId) {
        Preconditions.checkFalse(StringUtil.equalsIgnoreCase("METADATA", groupName), groupName + " is reserved for internal usage!");
        this.checkMetadataGroupInitSuccessful();
        CPGroupInfo group = this.getRaftGroupByName(groupName);
        if (group != null) {
            if (group.memberCount() == groupEndpoints.size()) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("CP group " + groupName + " already exists.");
                }
                return group.toSummary(this.activeMembers);
            }
            String msg = group.id() + " already exists with a different size: " + group.memberCount();
            this.logger.severe(msg);
            throw new IllegalStateException(msg);
        }
        group = this.getRaftGroupById(groupId);
        if (group != null) {
            throw new CannotCreateRaftGroupException("Cannot create CP group: " + groupName + " with members: " + groupEndpoints + " because group index: " + groupId + " already belongs to " + group.name());
        }
        Map<UUID, CPMemberInfo> activeMembersMap = this.getActiveMembersMap();
        CPMemberInfo leavingMember = this.membershipChangeSchedule != null ? this.membershipChangeSchedule.getLeavingMember() : null;
        for (RaftEndpoint groupEndpoint : groupEndpoints) {
            if ((leavingMember == null || !groupEndpoint.getUuid().equals(leavingMember.getUuid())) && activeMembersMap.containsKey(groupEndpoint.getUuid())) continue;
            String msg = "Cannot create CP group: " + groupName + " since " + groupEndpoint + " is not active";
            if (this.logger.isFineEnabled()) {
                this.logger.fine(msg);
            }
            throw new CannotCreateRaftGroupException(msg);
        }
        return this.createRaftGroup(new CPGroupInfo(new RaftGroupId(groupName, this.getGroupIdSeed(), groupId), groupEndpoints));
    }

    private CPGroupSummary createRaftGroup(CPGroupInfo group) {
        this.addRaftGroup(group);
        Map<UUID, CPMemberInfo> activeMembersMap = this.getActiveMembersMap();
        ArrayList<CPMemberInfo> members = new ArrayList<CPMemberInfo>();
        for (RaftEndpoint member : group.members()) {
            members.add(activeMembersMap.get(member.getUuid()));
        }
        this.logger.info("New " + group.id() + " is created with " + members);
        return group.toSummary(this.activeMembers);
    }

    private void createRaftNodeAsync(CPGroupInfo group) {
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        executionService.execute("hz:cpSubsystem", () -> this.raftService.createRaftNode(group.id(), group.members()));
    }

    private Map<UUID, CPMemberInfo> getActiveMembersMap() {
        HashMap<UUID, CPMemberInfo> map = new HashMap<UUID, CPMemberInfo>();
        for (CPMemberInfo member : this.activeMembers) {
            map.put(member.getUuid(), member);
        }
        return map;
    }

    private void addRaftGroup(CPGroupInfo group) {
        RaftGroupId groupId = group.id();
        if (this.groups.containsKey(groupId)) {
            String msg = group + " already exists!";
            if (this.logger.isFineEnabled()) {
                this.logger.warning(msg);
            }
            throw new IllegalStateException(msg);
        }
        this.groups.put(groupId, group);
    }

    private CPGroupInfo getRaftGroupByName(String name) {
        for (CPGroupInfo group : this.groups.values()) {
            if (group.status() == CPGroup.CPGroupStatus.DESTROYED || !group.name().equals(name)) continue;
            return group;
        }
        return null;
    }

    private CPGroupInfo getRaftGroupById(long groupId) {
        for (CPGroupInfo group : this.groups.values()) {
            if (group.id().getId() != groupId) continue;
            return group;
        }
        return null;
    }

    public void triggerDestroyRaftGroup(CPGroupId groupId) {
        Preconditions.checkNotNull(groupId);
        this.checkMetadataGroupInitSuccessful();
        if (this.membershipChangeSchedule != null) {
            String msg = "Cannot destroy " + groupId + " while there are ongoing CP membership changes!";
            if (this.logger.isFineEnabled()) {
                this.logger.warning(msg);
            }
            throw new IllegalStateException(msg);
        }
        CPGroupInfo group = (CPGroupInfo)this.groups.get(groupId);
        if (group == null) {
            String msg = "No CP group exists for " + groupId + " to destroy!";
            if (this.logger.isFineEnabled()) {
                this.logger.warning(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        if (group.setDestroying()) {
            this.logger.info("Destroying " + groupId);
        } else if (this.logger.isFineEnabled()) {
            this.logger.fine(groupId + " is already " + (Object)((Object)group.status()));
        }
    }

    public void completeDestroyRaftGroups(Set<CPGroupId> groupIds) {
        Preconditions.checkNotNull(groupIds);
        for (CPGroupId groupId : groupIds) {
            Preconditions.checkNotNull(groupId);
            if (this.groups.containsKey(groupId)) continue;
            String msg = groupId + " does not exist to complete destroy";
            this.logger.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        for (CPGroupId groupId : groupIds) {
            this.completeDestroyRaftGroup((CPGroupInfo)this.groups.get(groupId));
        }
    }

    private void completeDestroyRaftGroup(CPGroupInfo group) {
        RaftGroupId groupId = group.id();
        if (group.setDestroyed()) {
            this.logger.info(groupId + " is destroyed.");
            this.sendTerminateRaftNodeOpsForDestroyedGroup(group);
        } else if (this.logger.isFineEnabled()) {
            this.logger.fine(groupId + " is already destroyed.");
        }
    }

    public void forceDestroyRaftGroup(String groupName) {
        Preconditions.checkNotNull(groupName);
        Preconditions.checkFalse(StringUtil.equalsIgnoreCase("METADATA", groupName), "Cannot force-destroy the METADATA CP group!");
        this.checkMetadataGroupInitSuccessful();
        boolean found = false;
        for (CPGroupInfo group : this.groups.values()) {
            if (!group.name().equals(groupName)) continue;
            if (group.forceSetDestroyed()) {
                this.logger.info(group.id() + " is force-destroyed.");
                this.sendTerminateRaftNodeOpsForDestroyedGroup(group);
            } else if (this.logger.isFineEnabled()) {
                this.logger.fine(group.id() + " is already force-destroyed.");
            }
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("CP group with name: " + groupName + " does not exist to force-destroy!");
        }
    }

    private void sendTerminateRaftNodeOpsForDestroyedGroup(CPGroupInfo group) {
        Map<UUID, CPMemberInfo> activeMembersMap = this.getActiveMembersMap();
        CPMemberInfo localCPMember = this.getLocalCPMember();
        if (localCPMember == null) {
            return;
        }
        RaftEndpoint localEndpoint = localCPMember.toRaftEndpoint();
        OperationServiceImpl operationService = this.nodeEngine.getOperationService();
        for (RaftEndpoint endpoint : group.members()) {
            if (endpoint.equals(localEndpoint)) {
                this.terminateRaftNodeAsync(group.id());
                continue;
            }
            TerminateRaftNodesOp op = new TerminateRaftNodesOp(Collections.singleton(group.id()));
            CPMemberInfo cpMember = activeMembersMap.get(endpoint.getUuid());
            operationService.invokeOnTarget("hz:core:raft", op, cpMember.getAddress());
        }
    }

    private void terminateRaftNodeAsync(CPGroupId groupId) {
        this.nodeEngine.getExecutionService().execute("hz:cpSubsystem", () -> this.raftService.terminateRaftNode(groupId, true));
    }

    public boolean removeMember(long commitIndex, CPMemberInfo leavingMember) {
        Preconditions.checkNotNull(leavingMember);
        this.checkMetadataGroupInitSuccessful();
        if (!this.activeMembers.contains(leavingMember)) {
            this.logger.fine("Not removing " + leavingMember + " since it is not an active CP member");
            return true;
        }
        if (this.membershipChangeSchedule != null) {
            if (leavingMember.equals(this.membershipChangeSchedule.getLeavingMember())) {
                this.membershipChangeSchedule = this.membershipChangeSchedule.addRetriedCommitIndex(commitIndex);
                if (this.logger.isFineEnabled()) {
                    this.logger.fine(leavingMember + " is already marked as leaving.");
                }
                return false;
            }
            String msg = "There is already an ongoing CP membership change process. Cannot process remove request of " + leavingMember;
            if (this.logger.isFineEnabled()) {
                this.logger.fine(msg);
            }
            throw new CannotRemoveCPMemberException(msg);
        }
        if (this.activeMembers.size() == 2) {
            this.logger.warning(leavingMember + " is directly removed as there are only " + this.activeMembers.size() + " CP members.");
            this.removeActiveMember(commitIndex, leavingMember);
            throw new RetryableHazelcastException();
        }
        if (this.activeMembers.size() == 1) {
            this.logger.fine("Not removing the last active CP member: " + leavingMember + " to help it complete its shutdown");
            return true;
        }
        return this.initMembershipChangeScheduleForLeavingMember(commitIndex, leavingMember);
    }

    private boolean initMembershipChangeScheduleForLeavingMember(long commitIndex, CPMemberInfo leavingMember) {
        ArrayList<RaftGroupId> leavingGroupIds = new ArrayList<RaftGroupId>();
        ArrayList<MembershipChangeSchedule.CPGroupMembershipChange> changes = new ArrayList<MembershipChangeSchedule.CPGroupMembershipChange>();
        for (CPGroupInfo group : this.groups.values()) {
            RaftGroupId groupId = group.id();
            if (!group.containsMember(leavingMember.toRaftEndpoint()) || group.status() == CPGroup.CPGroupStatus.DESTROYED) continue;
            CPMemberInfo substitute = this.findSubstitute(group);
            RaftEndpoint substituteEndpoint = substitute != null ? substitute.toRaftEndpoint() : null;
            leavingGroupIds.add(groupId);
            changes.add(new MembershipChangeSchedule.CPGroupMembershipChange(groupId, group.getMembersCommitIndex(), group.memberImpls(), substituteEndpoint, leavingMember.toRaftEndpoint()));
        }
        if (changes.isEmpty()) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Removing " + leavingMember + " directly since it is not present in any CP group.");
            }
            this.removeActiveMember(commitIndex, leavingMember);
            return true;
        }
        this.membershipChangeSchedule = MembershipChangeSchedule.forLeavingMember(Collections.singletonList(commitIndex), leavingMember, changes);
        if (this.logger.isFineEnabled()) {
            this.logger.info(leavingMember + " will be removed from " + changes);
        } else {
            this.logger.info(leavingMember + " will be removed from " + leavingGroupIds);
        }
        return false;
    }

    private CPMemberInfo findSubstitute(CPGroupInfo group) {
        for (CPMemberInfo substitute : this.activeMembers) {
            if (!this.activeMembers.contains(substitute) || group.containsMember(substitute.toRaftEndpoint())) continue;
            return substitute;
        }
        return null;
    }

    public MembershipChangeSchedule completeRaftGroupMembershipChanges(long commitIndex, Map<CPGroupId, BiTuple<Long, Long>> changedGroups) {
        Preconditions.checkNotNull(changedGroups);
        if (this.membershipChangeSchedule == null) {
            String msg = "Cannot apply CP membership changes: " + changedGroups + " since there is no membership change context!";
            this.logger.warning(msg);
            throw new IllegalStateException(msg);
        }
        for (MembershipChangeSchedule.CPGroupMembershipChange change : this.membershipChangeSchedule.getChanges()) {
            CPGroupId groupId = change.getGroupId();
            CPGroupInfo group = (CPGroupInfo)this.groups.get(groupId);
            Preconditions.checkState(group != null, groupId + "not found in CP groups: " + this.groups.keySet() + "to apply " + change);
            BiTuple<Long, Long> t2 = changedGroups.get(groupId);
            if (t2 != null) {
                if (this.applyMembershipChange(change, group, (Long)t2.element1, (Long)t2.element2)) continue;
                changedGroups.remove(groupId);
                continue;
            }
            if (group.status() != CPGroup.CPGroupStatus.DESTROYED || changedGroups.containsKey(groupId)) continue;
            if (this.logger.isFineEnabled()) {
                this.logger.warning(groupId + " is already destroyed so will skip: " + change);
            }
            changedGroups.put(groupId, BiTuple.of(0L, 0L));
        }
        this.membershipChangeSchedule = this.membershipChangeSchedule.excludeCompletedChanges(changedGroups.keySet());
        if (this.checkSafeToRemoveIfCPMemberLeaving(this.membershipChangeSchedule)) {
            CPMemberInfo leavingMember = this.membershipChangeSchedule.getLeavingMember();
            this.removeActiveMember(commitIndex, leavingMember);
            this.completeFutures(this.getMetadataGroupId(), this.membershipChangeSchedule.getMembershipChangeCommitIndices(), null);
            this.membershipChangeSchedule = null;
            this.logger.info(leavingMember + " is removed from CP Subsystem.");
        } else if (this.membershipChangeSchedule.getChanges().isEmpty()) {
            this.completeFutures(this.getMetadataGroupId(), this.membershipChangeSchedule.getMembershipChangeCommitIndices(), null);
            this.membershipChangeSchedule = null;
            this.logger.info("Rebalancing is completed.");
        }
        return this.membershipChangeSchedule;
    }

    private void completeFutures(CPGroupId groupId, Collection<Long> indices, Object result) {
        if (!indices.isEmpty()) {
            RaftNodeImpl raftNode = (RaftNodeImpl)this.raftService.getRaftNode(groupId);
            if (raftNode != null) {
                for (Long index : indices) {
                    raftNode.completeFuture(index, result);
                }
            } else {
                this.logger.severe("RaftNode not found for " + groupId + " to notify commit indices " + indices + " with " + result);
            }
        }
    }

    private boolean applyMembershipChange(MembershipChangeSchedule.CPGroupMembershipChange change, CPGroupInfo group, long expectedMembersCommitIndex, long newMembersCommitIndex) {
        RaftEndpoint addedMember = change.getMemberToAdd();
        RaftEndpoint removedMember = change.getMemberToRemove();
        if (group.applyMembershipChange(removedMember, addedMember, expectedMembersCommitIndex, newMembersCommitIndex)) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Applied add-member: " + (addedMember != null ? addedMember : "-") + " and remove-member: " + (removedMember != null ? removedMember : "-") + " in " + group.id() + " with new members commit index: " + newMembersCommitIndex);
            }
            return true;
        }
        this.logger.severe("Could not apply add-member: " + (addedMember != null ? addedMember : "-") + " and remove-member: " + (removedMember != null ? removedMember : "-") + " in " + group + " with new members commit index: " + newMembersCommitIndex + ", expected members commit index: " + expectedMembersCommitIndex + ", known members commit index: " + group.getMembersCommitIndex());
        return false;
    }

    private boolean checkSafeToRemoveIfCPMemberLeaving(MembershipChangeSchedule schedule2) {
        CPMemberInfo leavingMember = schedule2.getLeavingMember();
        if (leavingMember == null) {
            return false;
        }
        if (schedule2.getChanges().size() > 0) {
            return false;
        }
        RaftEndpoint leavingEndpoint = leavingMember.toRaftEndpoint();
        for (CPGroupInfo group : this.groups.values()) {
            if (!group.containsMember(leavingEndpoint)) continue;
            if (group.status() != CPGroup.CPGroupStatus.DESTROYED) {
                return false;
            }
            if (!this.logger.isFineEnabled()) continue;
            this.logger.warning("Leaving " + leavingMember + " was in the destroyed " + group.id());
        }
        return true;
    }

    private List<MembershipChangeSchedule.CPGroupMembershipChange> getGroupMembershipChangesForNewMember(CPMemberInfo newMember) {
        ArrayList<MembershipChangeSchedule.CPGroupMembershipChange> changes = new ArrayList<MembershipChangeSchedule.CPGroupMembershipChange>();
        for (CPGroupInfo group : this.groups.values()) {
            if (group.status() != CPGroup.CPGroupStatus.ACTIVE || group.initialMemberCount() <= group.memberCount()) continue;
            Preconditions.checkState(!group.memberImpls().contains(newMember.toRaftEndpoint()), group + " already contains: " + newMember);
            changes.add(new MembershipChangeSchedule.CPGroupMembershipChange(group.id(), group.getMembersCommitIndex(), group.memberImpls(), newMember.toRaftEndpoint(), null));
        }
        return changes;
    }

    public Collection<CPMemberInfo> getActiveMembers() {
        return this.activeMembers;
    }

    public void handleMetadataGroupId(RaftGroupId newMetadataGroupId) {
        Preconditions.checkNotNull(newMetadataGroupId);
        RaftGroupId metadataGroupId = this.getMetadataGroupId();
        CPMetadataStore metadataStore = this.getCpMetadataStore();
        if (!this.raftService.isStartCompleted() && metadataStore.containsLocalMemberFile()) {
            if (!metadataGroupId.equals(newMetadataGroupId)) {
                this.logger.severe("Restored METADATA groupId: " + metadataGroupId + " is different than received METADATA groupId: " + newMetadataGroupId + ". There must have been a CP Subsystem reset while this member was down...");
            }
            return;
        }
        if (metadataGroupId.getSeed() >= newMetadataGroupId.getSeed()) {
            return;
        }
        metadataGroupId = this.getMetadataGroupId();
        if (metadataGroupId.getSeed() >= newMetadataGroupId.getSeed()) {
            return;
        }
        this.metadataGroupIdRef.set(newMetadataGroupId);
        try {
            metadataStore.persistMetadataGroupId(newMetadataGroupId);
        }
        catch (IOException e) {
            throw new HazelcastException(e);
        }
    }

    public Collection<CPGroupId> getDestroyingGroupIds() {
        ArrayList<CPGroupId> groupIds = new ArrayList<CPGroupId>();
        for (CPGroupInfo group : this.groups.values()) {
            if (group.status() != CPGroup.CPGroupStatus.DESTROYING) continue;
            groupIds.add(group.id());
        }
        return groupIds;
    }

    public MembershipChangeSchedule getMembershipChangeSchedule() {
        return this.membershipChangeSchedule;
    }

    boolean isMetadataGroupLeader() {
        CPMemberInfo localCPMember = this.getLocalCPMember();
        if (localCPMember == null) {
            return false;
        }
        RaftNode raftNode = this.raftService.getRaftNode(this.getMetadataGroupId());
        return raftNode != null && !raftNode.isTerminatedOrSteppedDown() && localCPMember.toRaftEndpoint().equals(raftNode.getLeader());
    }

    public void verifyRestartedMember(long commitIndex, CPMemberInfo member) {
        Preconditions.checkNotNull(member);
        this.checkMetadataGroupInitSuccessful();
        LinkedHashSet<CPMemberInfo> newMembers = new LinkedHashSet<CPMemberInfo>(this.activeMembers.size());
        boolean found = false;
        for (CPMemberInfo existingMember : this.activeMembers) {
            if (existingMember.getUuid().equals(member.getUuid())) {
                if (existingMember.getAddress().equals(member.getAddress())) {
                    this.logger.fine(member + " already exists.");
                    return;
                }
                this.logger.info("Replaced " + existingMember + " with " + member);
                newMembers.add(member);
                found = true;
                continue;
            }
            newMembers.add(existingMember);
        }
        if (!found) {
            throw new IllegalStateException(member + " does not exist in the active CP members list!");
        }
        this.logger.info("New active CP members list: " + newMembers);
        this.doSetActiveMembers(commitIndex, newMembers);
    }

    public boolean addMember(long commitIndex, CPMemberInfo member) {
        Preconditions.checkNotNull(member);
        this.checkMetadataGroupInitSuccessful();
        for (CPMemberInfo existingMember : this.activeMembers) {
            if (!existingMember.getAddress().equals(member.getAddress())) continue;
            if (existingMember.getUuid().equals(member.getUuid())) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine(member + " already exists.");
                }
                if (this.membershipChangeSchedule != null && member.equals(this.membershipChangeSchedule.getAddedMember())) {
                    this.membershipChangeSchedule = this.membershipChangeSchedule.addRetriedCommitIndex(commitIndex);
                    this.logger.info("CP groups are already being rebalanced for " + member);
                    return false;
                }
                return true;
            }
            throw new IllegalStateException(member + " cannot be added to CP Subsystem because another " + existingMember + " exists with the same address!");
        }
        Preconditions.checkState(this.membershipChangeSchedule == null, "Cannot rebalance CP groups because there is ongoing " + this.membershipChangeSchedule);
        LinkedHashSet<CPMemberInfo> newMembers = new LinkedHashSet<CPMemberInfo>(this.activeMembers);
        newMembers.add(member);
        this.doSetActiveMembers(commitIndex, newMembers);
        this.logger.info("Added new " + member + ". New active CP members list: " + newMembers);
        List<MembershipChangeSchedule.CPGroupMembershipChange> changes = this.getGroupMembershipChangesForNewMember(member);
        if (changes.size() > 0) {
            this.membershipChangeSchedule = MembershipChangeSchedule.forJoiningMember(Collections.singletonList(commitIndex), member, changes);
            if (this.logger.isFineEnabled()) {
                this.logger.fine("CP group rebalancing is triggered for " + member + ", changes: " + this.membershipChangeSchedule);
            }
            return false;
        }
        return true;
    }

    private void removeActiveMember(long commitIndex, CPMemberInfo member) {
        LinkedHashSet<CPMemberInfo> newMembers = new LinkedHashSet<CPMemberInfo>(this.activeMembers);
        newMembers.remove(member);
        this.doSetActiveMembers(commitIndex, newMembers);
    }

    private void doSetActiveMembers(long commitIndex, LinkedHashSet<CPMemberInfo> members) {
        Collection<CPMemberInfo> currentMembers = this.activeMembers;
        this.activeMembers = Collections.unmodifiableCollection(members);
        this.activeMembersCommitIndex = commitIndex;
        try {
            this.logger.fine("Persisting active CP members " + this.activeMembers + " with commitIndex " + this.activeMembersCommitIndex);
            this.getCpMetadataStore().persistActiveCPMembers(this.activeMembers, this.activeMembersCommitIndex);
        }
        catch (IOException e) {
            throw new HazelcastException(e);
        }
        this.raftService.updateInvocationManagerMembers(this.getMetadataGroupId().getSeed(), commitIndex, this.activeMembers);
        this.raftService.updateMissingMembers();
        this.broadcastActiveCPMembers();
        this.sendMembershipEvents(currentMembers, members);
    }

    private void sendMembershipEvents(Collection<CPMemberInfo> currentMembers, Collection<CPMemberInfo> newMembers) {
        if (!this.isMetadataGroupLeader()) {
            return;
        }
        EventService eventService = this.nodeEngine.getEventService();
        LinkedHashSet<CPMemberInfo> addedMembers = new LinkedHashSet<CPMemberInfo>(newMembers);
        addedMembers.removeAll(currentMembers);
        for (CPMemberInfo member : addedMembers) {
            CPMembershipEventImpl event = new CPMembershipEventImpl((CPMember)member, CPMembershipEvent.EventType.ADDED);
            eventService.publishEvent("hz:core:raft", "membership", (Object)event, "membership".hashCode());
        }
        LinkedHashSet<CPMemberInfo> removedMembers = new LinkedHashSet<CPMemberInfo>(currentMembers);
        removedMembers.removeAll(newMembers);
        for (CPMemberInfo member : removedMembers) {
            CPMembershipEventImpl event = new CPMembershipEventImpl((CPMember)member, CPMembershipEvent.EventType.REMOVED);
            eventService.publishEvent("hz:core:raft", "membership", (Object)event, "membership".hashCode());
        }
    }

    public void checkMetadataGroupInitSuccessful() {
        switch (this.initializationStatus) {
            case SUCCESSFUL: {
                return;
            }
            case IN_PROGRESS: {
                throw new MetadataRaftGroupInitInProgressException();
            }
            case FAILED: {
                throw new IllegalStateException("CP Subsystem initialization failed!");
            }
        }
        throw new IllegalStateException("Illegal initialization status: " + (Object)((Object)this.initializationStatus));
    }

    void broadcastActiveCPMembers() {
        if (!this.isDiscoveryCompleted() || !this.isMetadataGroupLeader()) {
            return;
        }
        RaftGroupId metadataGroupId = this.getMetadataGroupId();
        long commitIndex = this.activeMembersCommitIndex;
        Collection<CPMemberInfo> cpMembers = this.activeMembers;
        if (cpMembers.isEmpty()) {
            return;
        }
        Set<Member> clusterMembers = this.nodeEngine.getClusterService().getMembers();
        OperationServiceImpl operationService = this.nodeEngine.getOperationService();
        PublishActiveCPMembersOp op = new PublishActiveCPMembersOp(metadataGroupId, commitIndex, cpMembers);
        for (Member member : clusterMembers) {
            if (member.localMember()) continue;
            operationService.send(op, member.getAddress());
        }
    }

    boolean isDiscoveryCompleted() {
        return this.discoveryCompleted.get();
    }

    List<CPMemberInfo> getInitialCPMembers() {
        return this.initialCPMembers;
    }

    MetadataRaftGroupInitStatus getInitializationStatus() {
        return this.initializationStatus;
    }

    Set<CPMemberInfo> getInitializedCPMembers() {
        return this.initializedCPMembers;
    }

    Set<Long> getInitializationCommitIndices() {
        return this.initializationCommitIndices;
    }

    public void disableDiscovery() {
        if (this.cpSubsystemEnabled) {
            this.logger.info("Disabling discovery of initial CP members since it is already completed...");
        }
        this.discoveryCompleted.set(true);
        try {
            this.getCpMetadataStore().tryMarkAPMember();
        }
        catch (IOException e) {
            throw new HazelcastException(e);
        }
    }

    private void scheduleDiscoverInitialCPMembersTask(boolean terminateOnDiscoveryFailure) {
        DiscoverInitialCPMembersTask task;
        this.currentDiscoveryTask = task = new DiscoverInitialCPMembersTask(terminateOnDiscoveryFailure);
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        executionService.schedule("hz:cpSubsystemManagement", task, 1000L, TimeUnit.MILLISECONDS);
    }

    private CPMetadataStore getCpMetadataStore() {
        return this.raftService.getCPPersistenceService().getCPMetadataStore();
    }

    @SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static class CPGroupIdComparator
    implements Comparator<CPGroupId> {
        private CPGroupIdComparator() {
        }

        @Override
        public int compare(CPGroupId o1, CPGroupId o2) {
            if (o1.getName().equals("METADATA")) {
                return -1;
            }
            if (o2.getName().equals("METADATA")) {
                return 1;
            }
            if (o1.getName().equals("default")) {
                return -1;
            }
            if (o2.getName().equals("default")) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    @SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static class CPMemberComparator
    implements Comparator<CPMemberInfo> {
        private CPMemberComparator() {
        }

        @Override
        public int compare(CPMemberInfo o1, CPMemberInfo o2) {
            return o1.getUuid().compareTo(o2.getUuid());
        }
    }

    private class DiscoverInitialCPMembersTask
    implements Runnable {
        private Collection<Member> latestMembers = Collections.emptySet();
        private final boolean terminateOnDiscoveryFailure;
        private long lastLoggingTime;
        private volatile boolean cancelled;
        private volatile DiscoveryTaskState state;

        DiscoverInitialCPMembersTask(boolean terminateOnDiscoveryFailure) {
            this.terminateOnDiscoveryFailure = terminateOnDiscoveryFailure;
            this.state = DiscoveryTaskState.SCHEDULED;
        }

        @Override
        public void run() {
            this.state = DiscoveryTaskState.RUNNING;
            try {
                this.doRun();
            }
            finally {
                if (this.state == DiscoveryTaskState.RUNNING) {
                    this.state = DiscoveryTaskState.COMPLETED;
                }
            }
        }

        private void doRun() {
            if (this.shouldRescheduleOrSkip()) {
                return;
            }
            boolean markedAPMember = MetadataRaftGroupManager.this.getCpMetadataStore().isMarkedAPMember();
            if (!markedAPMember && MetadataRaftGroupManager.this.localCPMember.get() == null) {
                MetadataRaftGroupManager.this.logger.fine("Starting CP discovery...");
                Collection<Member> members = MetadataRaftGroupManager.this.nodeEngine.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
                for (Member member : this.latestMembers) {
                    if (members.contains(member)) continue;
                    MetadataRaftGroupManager.this.logger.severe(member + " left the cluster while the CP discovery in progress!");
                    this.handleDiscoveryFailure();
                    return;
                }
                this.latestMembers = members;
                if (this.rescheduleIfCPMemberCountNotSatisfied(members)) {
                    return;
                }
                CPMemberInfo localMemberCandidate = new CPMemberInfo(MetadataRaftGroupManager.this.nodeEngine.getLocalMember());
                List<CPMemberInfo> discoveredCPMembers = this.getDiscoveredCPMembers(members);
                if (this.completeDiscoveryIfNotCPMember(discoveredCPMembers, localMemberCandidate)) {
                    return;
                }
                MetadataRaftGroupManager.this.raftService.updateInvocationManagerMembers(MetadataRaftGroupManager.this.getMetadataGroupId().getSeed(), 0L, discoveredCPMembers);
                if (!this.commitMetadataRaftGroupInit(localMemberCandidate, discoveredCPMembers)) {
                    this.handleDiscoveryFailure();
                    return;
                }
                MetadataRaftGroupManager.this.logger.info("CP Subsystem is initialized with: " + discoveredCPMembers);
            }
            MetadataRaftGroupManager.this.discoveryCompleted.set(true);
            if (MetadataRaftGroupManager.this.localCPMember.get() != null) {
                MetadataRaftGroupManager.this.scheduleGroupMembershipManagementTasks();
            }
        }

        private boolean shouldRescheduleOrSkip() {
            if (this.cancelled) {
                return true;
            }
            if (!MetadataRaftGroupManager.this.nodeEngine.getClusterService().isJoined()) {
                this.scheduleSelf();
                return true;
            }
            if (!MetadataRaftGroupManager.this.raftService.isStartCompleted()) {
                MetadataRaftGroupManager.this.logger.fine("Re-scheduling, startup is not completed yet!");
                this.scheduleSelf();
                return true;
            }
            return MetadataRaftGroupManager.this.isDiscoveryCompleted();
        }

        private boolean rescheduleIfCPMemberCountNotSatisfied(Collection<Member> members) {
            if (members.size() < MetadataRaftGroupManager.this.config.getCPMemberCount()) {
                long now = Clock.currentTimeMillis();
                if (now - this.lastLoggingTime >= 5000L) {
                    this.lastLoggingTime = now;
                    MetadataRaftGroupManager.this.logger.info("CP Subsystem is waiting for " + MetadataRaftGroupManager.this.config.getCPMemberCount() + " members to join the cluster. Current member count: " + members.size());
                }
                this.scheduleSelf();
                return true;
            }
            return false;
        }

        private void scheduleSelf() {
            this.state = DiscoveryTaskState.SCHEDULED;
            ExecutionService executionService = MetadataRaftGroupManager.this.nodeEngine.getExecutionService();
            executionService.schedule("hz:cpSubsystemManagement", this, 1000L, TimeUnit.MILLISECONDS);
        }

        private List<CPMemberInfo> getDiscoveredCPMembers(Collection<Member> members) {
            assert (members.size() >= MetadataRaftGroupManager.this.config.getCPMemberCount());
            List<Member> memberList = new ArrayList<Member>(members).subList(0, MetadataRaftGroupManager.this.config.getCPMemberCount());
            ArrayList<CPMemberInfo> cpMembers = new ArrayList<CPMemberInfo>(MetadataRaftGroupManager.this.config.getCPMemberCount());
            for (Member member : memberList) {
                cpMembers.add(new CPMemberInfo(member));
            }
            cpMembers.sort(new CPMemberComparator());
            return cpMembers;
        }

        private boolean completeDiscoveryIfNotCPMember(List<CPMemberInfo> cpMembers, CPMemberInfo localCPMemberCandidate) {
            if (!cpMembers.contains(localCPMemberCandidate)) {
                MetadataRaftGroupManager.this.logger.info("I am not a CP member! I'll serve as an AP member.");
                try {
                    boolean marked = MetadataRaftGroupManager.this.getCpMetadataStore().tryMarkAPMember();
                    assert (marked);
                    MetadataRaftGroupManager.this.discoveryCompleted.set(true);
                }
                catch (IOException e) {
                    throw new HazelcastException(e);
                }
                return true;
            }
            return false;
        }

        private boolean commitMetadataRaftGroupInit(CPMemberInfo localCPMemberCandidate, List<CPMemberInfo> discoveredCPMembers) {
            List<CPMemberInfo> metadataMembers = discoveredCPMembers.subList(0, MetadataRaftGroupManager.this.config.getGroupSize());
            RaftGroupId metadataGroupId = MetadataRaftGroupManager.this.getMetadataGroupId();
            try {
                MetadataRaftGroupManager.this.localCPMember.set(localCPMemberCandidate);
                MetadataRaftGroupManager.this.getCpMetadataStore().persistLocalCPMember(localCPMemberCandidate);
                if (metadataMembers.contains(localCPMemberCandidate)) {
                    ArrayList<RaftEndpoint> metadataEndpoints = new ArrayList<RaftEndpoint>();
                    for (CPMemberInfo member : metadataMembers) {
                        metadataEndpoints.add(member.toRaftEndpoint());
                    }
                    MetadataRaftGroupManager.this.raftService.createRaftNode(metadataGroupId, metadataEndpoints, localCPMemberCandidate.toRaftEndpoint());
                }
                InitMetadataRaftGroupOp op = new InitMetadataRaftGroupOp(localCPMemberCandidate, discoveredCPMembers, metadataGroupId.getSeed());
                MetadataRaftGroupManager.this.raftService.getInvocationManager().invoke(metadataGroupId, op).get();
            }
            catch (Exception e) {
                MetadataRaftGroupManager.this.logger.severe("Could not initialize METADATA CP group with CP members: " + metadataMembers, e);
                MetadataRaftGroupManager.this.raftService.terminateRaftNode(metadataGroupId, true);
                return false;
            }
            return true;
        }

        private void handleDiscoveryFailure() {
            if (this.terminateOnDiscoveryFailure) {
                MetadataRaftGroupManager.this.logger.warning("Terminating because of CP discovery failure...");
                this.terminateNode();
            } else {
                MetadataRaftGroupManager.this.logger.warning("Cancelling CP Subsystem discovery...");
                MetadataRaftGroupManager.this.discoveryCompleted.set(true);
            }
        }

        private void terminateNode() {
            MetadataRaftGroupManager.this.nodeEngine.getNode().shutdown(true);
        }

        void cancelAndAwaitCompletion() {
            this.cancelled = true;
            while (this.state != DiscoveryTaskState.COMPLETED) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }

    private static enum DiscoveryTaskState {
        RUNNING,
        SCHEDULED,
        COMPLETED;

    }

    private class BroadcastActiveCPMembersTask
    implements Runnable {
        private BroadcastActiveCPMembersTask() {
        }

        @Override
        public void run() {
            MetadataRaftGroupManager.this.broadcastActiveCPMembers();
        }
    }

    static enum MetadataRaftGroupInitStatus {
        IN_PROGRESS,
        FAILED,
        SUCCESSFUL;

    }
}

