/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.dataconnection.impl;

import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.dataconnection.DataConnection;
import com.hazelcast.dataconnection.DataConnectionRegistration;
import com.hazelcast.dataconnection.impl.InternalDataConnectionService;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.ServiceLoader;
import com.hazelcast.logging.ILogger;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DataConnectionServiceImpl
implements InternalDataConnectionService {
    private final Map<String, Class<? extends DataConnection>> typeToDataConnectionClass = new HashMap<String, Class<? extends DataConnection>>();
    private final Map<Class<? extends DataConnection>, String> dataConnectionClassToType = new HashMap<Class<? extends DataConnection>, String>();
    private final Map<String, DataConnectionEntry> dataConnections = new ConcurrentHashMap<String, DataConnectionEntry>();
    private final ClassLoader classLoader;
    private final ILogger logger;

    public DataConnectionServiceImpl(Node node, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.logger = node.getLogger(this.getClass());
        this.processDataConnectionRegistrations(classLoader);
        for (DataConnectionConfig config : node.getConfig().getDataConnectionConfigs().values()) {
            this.put(config, DataConnectionSource.CONFIG);
        }
    }

    private void processDataConnectionRegistrations(ClassLoader classLoader) {
        try {
            ServiceLoader.iterator(DataConnectionRegistration.class, DataConnectionRegistration.class.getName(), classLoader).forEachRemaining(registration -> {
                this.typeToDataConnectionClass.put(registration.type().toLowerCase(Locale.ROOT), registration.clazz());
                this.dataConnectionClassToType.put(registration.clazz(), registration.type().toLowerCase(Locale.ROOT));
            });
        }
        catch (Exception e) {
            throw new HazelcastException("Could not register data connections", e);
        }
    }

    @Override
    public void createConfigDataConnection(DataConnectionConfig config) {
        this.put(config, DataConnectionSource.CONFIG);
    }

    private void put(DataConnectionConfig config, DataConnectionSource source2) {
        this.dataConnections.compute(config.getName(), (key, current) -> {
            if (current != null) {
                if (((DataConnectionEntry)current).source == DataConnectionSource.CONFIG) {
                    throw new HazelcastException("Cannot replace a data connection created from configuration");
                }
                if (((DataConnectionEntry)current).instance.getConfig().equals(config)) {
                    return current;
                }
                this.logger.fine("Asynchronously closing the old data connection: " + config.getName());
                ForkJoinPool.commonPool().execute(() -> {
                    try {
                        ((DataConnectionEntry)current).instance.release();
                    }
                    catch (Throwable e) {
                        this.logger.severe("Error when closing data connection '" + config.getName() + "', ignoring it: " + e, e);
                    }
                });
            }
            return new DataConnectionEntry(this.createDataConnectionInstance(config), source2);
        });
    }

    @Override
    public void createOrReplaceSqlDataConnection(String name, String type, boolean shared, Map<String, String> options) {
        this.put(this.toConfig(name, type, shared, options), DataConnectionSource.SQL);
    }

    @Override
    public boolean existsConfigDataConnection(String name) {
        DataConnectionEntry dl = this.dataConnections.get(name);
        return dl != null && dl.source == DataConnectionSource.CONFIG;
    }

    @Override
    public boolean existsSqlDataConnection(String name) {
        DataConnectionEntry dl = this.dataConnections.get(name);
        return dl != null && dl.source == DataConnectionSource.SQL;
    }

    DataConnectionConfig toConfig(String name, String type, boolean shared, Map<String, String> options) {
        Properties properties = new Properties();
        properties.putAll(options);
        return new DataConnectionConfig(name).setType(type).setShared(shared).setProperties(properties);
    }

    private DataConnection createDataConnectionInstance(DataConnectionConfig config) {
        this.logger.finest("Creating '" + config.getName() + "' data connection");
        String type = config.getType();
        try {
            Class<? extends DataConnection> dataConnectionClass = this.typeToDataConnectionClass.get(type.toLowerCase(Locale.ROOT));
            if (dataConnectionClass == null) {
                throw new HazelcastException("Data connection '" + config.getName() + "' misconfigured: unknown type '" + type + "'");
            }
            Constructor<? extends DataConnection> constructor = dataConnectionClass.getConstructor(DataConnectionConfig.class);
            return constructor.newInstance(config);
        }
        catch (ClassCastException e) {
            throw new HazelcastException("Data connection '" + config.getName() + "' misconfigured: '" + type + "' must implement '" + DataConnection.class.getName() + "'", e);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public String typeForDataConnection(String name) {
        DataConnectionEntry dataConnection = this.dataConnections.get(name);
        if (dataConnection == null) {
            throw new HazelcastException("Data connection '" + name + "' not found");
        }
        String type = this.dataConnectionClassToType.get(dataConnection.instance.getClass());
        if (type == null) {
            throw new HazelcastException("Data connection type for class '" + dataConnection.getClass() + "' is not known");
        }
        return type;
    }

    @Override
    public Class<? extends DataConnection> classForDataConnectionType(String type) {
        String caseInsensitiveType = type.toLowerCase(Locale.ROOT);
        Class<? extends DataConnection> dataConnectionClass = this.typeToDataConnectionClass.get(caseInsensitiveType);
        if (dataConnectionClass == null) {
            throw new HazelcastException("Data connection type '" + type + "' is not known");
        }
        return dataConnectionClass;
    }

    @Override
    @Nonnull
    public <T extends DataConnection> T getAndRetainDataConnection(String name, Class<T> clazz) {
        DataConnectionEntry dataConnection = this.dataConnections.computeIfPresent(name, (k, v) -> {
            if (!clazz.isInstance(((DataConnectionEntry)v).instance)) {
                throw new HazelcastException("Data connection '" + name + "' must be an instance of " + clazz);
            }
            ((DataConnectionEntry)v).instance.retain();
            return v;
        });
        if (dataConnection == null) {
            throw new HazelcastException("Data connection '" + name + "' not found");
        }
        return (T)dataConnection.instance;
    }

    @Override
    public void removeDataConnection(String name) {
        this.dataConnections.computeIfPresent(name, (k, v) -> {
            if (DataConnectionSource.CONFIG.equals((Object)((DataConnectionEntry)v).source)) {
                throw new HazelcastException("Data connection '" + name + "' is configured via Config and can't be removed");
            }
            ((DataConnectionEntry)v).instance.release();
            return null;
        });
    }

    public List<DataConnection> getConfigCreatedDataConnections() {
        return this.dataConnections.values().stream().filter(dl -> ((DataConnectionEntry)dl).source == DataConnectionSource.CONFIG).map(dl -> ((DataConnectionEntry)dl).instance).collect(Collectors.toList());
    }

    public List<DataConnection> getSqlCreatedDataConnections() {
        return this.dataConnections.values().stream().filter(dl -> ((DataConnectionEntry)dl).source == DataConnectionSource.SQL).map(dl -> ((DataConnectionEntry)dl).instance).collect(Collectors.toList());
    }

    @Override
    public void shutdown() {
        for (Map.Entry<String, DataConnectionEntry> entry : this.dataConnections.entrySet()) {
            this.logger.finest("Closing '" + entry.getKey() + "' data connection");
            DataConnectionEntry dataConnection = entry.getValue();
            try {
                dataConnection.instance.destroy();
            }
            catch (Exception e) {
                this.logger.warning("Closing '" + entry.getKey() + "' data connection failed", e);
            }
        }
    }

    public static class DataConnectionEntry {
        private final DataConnection instance;
        private final DataConnectionSource source;

        DataConnectionEntry(DataConnection instance, DataConnectionSource source2) {
            this.instance = instance;
            this.source = source2;
        }

        public DataConnection getInstance() {
            return this.instance;
        }

        public DataConnectionSource getSource() {
            return this.source;
        }
    }

    public static enum DataConnectionSource {
        CONFIG,
        SQL;

    }
}

