/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.function;

import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import java.io.Serializable;
import java.util.function.BiPredicate;

@FunctionalInterface
public interface BiPredicateEx<T, U>
extends BiPredicate<T, U>,
Serializable {
    public boolean testEx(T var1, U var2) throws Exception;

    @Override
    default public boolean test(T t2, U u) {
        try {
            return this.testEx(t2, u);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    @Override
    default public BiPredicateEx<T, U> and(BiPredicateEx<? super T, ? super U> other) {
        Preconditions.checkNotNull(other, "other");
        return (t2, u) -> this.test(t2, u) && other.test(t2, u);
    }

    @Override
    default public BiPredicateEx<T, U> negate() {
        return (t2, u) -> !this.test(t2, u);
    }

    @Override
    default public BiPredicateEx<T, U> or(BiPredicateEx<? super T, ? super U> other) {
        Preconditions.checkNotNull(other, "other");
        return (t2, u) -> this.test(t2, u) || other.test(t2, u);
    }
}

