/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.config.OnJoinPermissionOperationName;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.impl.operations.AbstractJoinOperation;
import com.hazelcast.internal.management.operation.UpdatePermissionConfigOperation;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationAccessor;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandler;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandlerFactory;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.TargetAware;
import com.hazelcast.spi.impl.operationservice.UrgentSystemOperation;
import java.io.IOException;
import java.util.Collection;

public class OnJoinOp
extends AbstractJoinOperation
implements UrgentSystemOperation,
TargetAware {
    private Collection<Operation> operations;

    public OnJoinOp() {
    }

    public OnJoinOp(Collection<Operation> ops) {
        for (Operation op : ops) {
            Preconditions.checkNotNull(op, "op can't be null");
            Preconditions.checkNegative(op.getPartitionId(), "Post join operation can not have a partition ID!");
        }
        this.operations = ops;
    }

    @Override
    public String getServiceName() {
        return "hz:core:clusterService";
    }

    @Override
    public void beforeRun() throws Exception {
        if (!this.operations.isEmpty()) {
            NodeEngine nodeEngine = this.getNodeEngine();
            OperationResponseHandler responseHandler = OperationResponseHandlerFactory.createErrorLoggingResponseHandler(this.getLogger());
            for (Operation op : this.operations) {
                op.setNodeEngine(nodeEngine);
                op.setOperationResponseHandler(responseHandler);
                OperationAccessor.setCallerAddress(op, this.getCallerAddress());
                OperationAccessor.setConnection(op, this.getConnection());
            }
        }
    }

    @Override
    public void run() throws Exception {
        if (!this.operations.isEmpty()) {
            SecurityConfig securityConfig = this.getNodeEngine().getConfig().getSecurityConfig();
            boolean runPermissionUpdates = securityConfig.getOnJoinPermissionOperation() == OnJoinPermissionOperationName.RECEIVE;
            for (Operation op : this.operations) {
                if (op instanceof UpdatePermissionConfigOperation && !runPermissionUpdates) continue;
                try {
                    OperationRunner.runDirect(op);
                }
                catch (Exception e) {
                    this.getLogger().warning("Error while running post-join operation: " + op, e);
                }
            }
            ClusterService clusterService = (ClusterService)this.getService();
            if (clusterService.isMaster()) {
                OperationService operationService = this.getNodeEngine().getOperationService();
                for (Member member : clusterService.getMembers()) {
                    if (member.localMember() || member.getUuid().equals(this.getCallerUuid())) continue;
                    OnJoinOp operation = new OnJoinOp(this.operations);
                    operationService.invokeOnTarget(this.getServiceName(), operation, member.getAddress());
                }
            }
        }
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        for (Operation op : this.operations) {
            this.onOperationFailure(op, e);
        }
    }

    private void onOperationFailure(Operation op, Throwable e) {
        try {
            op.onExecutionFailure(e);
        }
        catch (Throwable t2) {
            this.getLogger().warning("While calling operation.onFailure(). op: " + op, t2);
        }
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        SerializationUtil.writeCollection(this.operations, out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.operations = SerializationUtil.readCollection(in);
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", operations=").append(this.operations);
    }

    @Override
    public int getClassId() {
        return 19;
    }

    @Override
    public void setTarget(Address address) {
        for (Operation op : this.operations) {
            if (!(op instanceof TargetAware)) continue;
            ((TargetAware)((Object)op)).setTarget(address);
        }
    }
}

