/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.DoubleGauge;
import com.hazelcast.internal.metrics.DoubleProbeFunction;
import com.hazelcast.internal.metrics.LongProbeFunction;
import com.hazelcast.internal.metrics.ProbeFunction;
import com.hazelcast.internal.metrics.impl.AbstractGauge;
import com.hazelcast.internal.metrics.impl.MetricValueCatcher;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.impl.ProbeInstance;

class DoubleGaugeImpl
extends AbstractGauge
implements DoubleGauge {
    static final double DEFAULT_VALUE = 0.0;
    private volatile DoubleGaugeSource gaugeSource;

    DoubleGaugeImpl(MetricsRegistryImpl metricsRegistry, String name) {
        super(metricsRegistry, name);
        ProbeInstance probeInstance = metricsRegistry.getProbeInstance(name);
        this.gaugeSource = probeInstance != null ? new ProbeInstanceGaugeSource(probeInstance) : new DoubleMetricValueCatcher();
    }

    @Override
    public void onProbeInstanceSet(ProbeInstance probeInstance) {
        this.gaugeSource = new ProbeInstanceGaugeSource(probeInstance);
    }

    @Override
    MetricValueCatcher getCatcherOrNull() {
        DoubleGaugeSource gaugeSourceCopy = this.gaugeSource;
        return gaugeSourceCopy instanceof DoubleMetricValueCatcher ? (DoubleMetricValueCatcher)gaugeSourceCopy : null;
    }

    @Override
    public double read() {
        return this.gaugeSource.read();
    }

    @Override
    public void render(StringBuilder stringBuilder) {
        stringBuilder.append(this.read());
    }

    private static double getMetricValue(String gaugeName, Object source2, ProbeFunction function, MetricsRegistryImpl metricsRegistry) {
        try {
            if (function instanceof LongProbeFunction) {
                LongProbeFunction longFunction = (LongProbeFunction)function;
                return longFunction.get(source2);
            }
            DoubleProbeFunction doubleFunction = (DoubleProbeFunction)function;
            return doubleFunction.get(source2);
        }
        catch (Exception e) {
            metricsRegistry.logger.warning("Failed to access the probe: " + gaugeName, e);
            return 0.0;
        }
    }

    private final class ProbeInstanceGaugeSource
    implements DoubleGaugeSource {
        private volatile ProbeInstance probeInstance;

        private ProbeInstanceGaugeSource(ProbeInstance probeInstance) {
            this.probeInstance = probeInstance;
        }

        @Override
        public double read() {
            ProbeFunction function = null;
            Object source2 = null;
            if (this.probeInstance != null) {
                function = this.probeInstance.function;
                source2 = this.probeInstance.source;
            }
            if (function == null || source2 == null) {
                this.probeInstance = null;
                return 0.0;
            }
            return DoubleGaugeImpl.getMetricValue(DoubleGaugeImpl.this.name, source2, function, DoubleGaugeImpl.this.metricsRegistry);
        }
    }

    private final class DoubleMetricValueCatcher
    extends AbstractGauge.AbstractMetricValueCatcher
    implements DoubleGaugeSource {
        private volatile double value = 0.0;

        private DoubleMetricValueCatcher() {
        }

        @Override
        public void catchMetricValue(long collectionId, long value) {
            DoubleGaugeImpl.this.lastCollectionId = collectionId;
            this.value = value;
            this.clearCachedMetricSourceRef();
        }

        @Override
        public void catchMetricValue(long collectionId, double value) {
            DoubleGaugeImpl.this.lastCollectionId = collectionId;
            this.value = value;
            this.clearCachedMetricSourceRef();
        }

        @Override
        public double read() {
            return this.readBase((x$0, x$1, x$2, x$3) -> DoubleGaugeImpl.getMetricValue(x$0, x$1, x$2, x$3), () -> this.value);
        }

        @Override
        void clearCachedValue() {
            this.value = 0.0;
        }
    }

    private static interface DoubleGaugeSource {
        public double read();
    }
}

