/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.nio;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.networking.ChannelErrorHandler;
import com.hazelcast.internal.networking.ChannelHandler;
import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.internal.networking.OutboundPipeline;
import com.hazelcast.internal.networking.nio.NioChannel;
import com.hazelcast.internal.networking.nio.NioPipeline;
import com.hazelcast.internal.networking.nio.NioThread;
import com.hazelcast.internal.networking.nio.iobalancer.IOBalancer;
import com.hazelcast.internal.util.ConcurrencyDetection;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.collection.ArrayUtils;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class NioOutboundPipeline
extends NioPipeline
implements Supplier<OutboundFrame>,
OutboundPipeline {
    @Probe(name="writeQueueSize", level=ProbeLevel.DEBUG)
    public final Queue<OutboundFrame> writeQueue = new ConcurrentLinkedQueue<OutboundFrame>();
    @Probe(name="priorityWriteQueueSize", level=ProbeLevel.DEBUG)
    public final Queue<OutboundFrame> priorityWriteQueue = new ConcurrentLinkedQueue<OutboundFrame>();
    private OutboundHandler[] handlers = new OutboundHandler[0];
    private ByteBuffer sendBuffer;
    private final AtomicReference<State> scheduled = new AtomicReference<State>(State.SCHEDULED);
    @Probe(name="bytesWritten", unit=ProbeUnit.BYTES, level=ProbeLevel.DEBUG)
    private final SwCounter bytesWritten = SwCounter.newSwCounter();
    @Probe(name="normalFramesWritten", level=ProbeLevel.DEBUG)
    private final SwCounter normalFramesWritten = SwCounter.newSwCounter();
    @Probe(name="priorityFramesWritten", level=ProbeLevel.DEBUG)
    private final SwCounter priorityFramesWritten = SwCounter.newSwCounter();
    private volatile long lastWriteTime;
    private long bytesWrittenLastPublish;
    private long normalFramesWrittenLastPublish;
    private long priorityFramesWrittenLastPublish;
    private long processCountLastPublish;
    private final ConcurrencyDetection concurrencyDetection;
    private final boolean writeThroughEnabled;
    private final boolean selectionKeyWakeupEnabled;

    NioOutboundPipeline(NioChannel channel, NioThread owner, ChannelErrorHandler errorHandler, ILogger logger2, IOBalancer balancer, ConcurrencyDetection concurrencyDetection, boolean writeThroughEnabled, boolean selectionKeyWakeupEnabled) {
        super(channel, owner, errorHandler, 4, logger2, balancer);
        this.concurrencyDetection = concurrencyDetection;
        this.writeThroughEnabled = writeThroughEnabled;
        this.selectionKeyWakeupEnabled = selectionKeyWakeupEnabled;
    }

    @Override
    public long load() {
        switch (this.loadType) {
            case 0: {
                return this.processCount.get();
            }
            case 1: {
                return this.bytesWritten.get();
            }
            case 2: {
                return this.normalFramesWritten.get() + this.priorityFramesWritten.get();
            }
        }
        throw new RuntimeException();
    }

    public int totalFramesPending() {
        return this.writeQueue.size() + this.priorityWriteQueue.size();
    }

    public long lastWriteTimeMillis() {
        return this.lastWriteTime;
    }

    @Probe(name="writeQueuePendingBytes", level=ProbeLevel.DEBUG, unit=ProbeUnit.BYTES)
    public long bytesPending() {
        return this.bytesPending(this.writeQueue);
    }

    @Probe(name="priorityWriteQueuePendingBytes", level=ProbeLevel.DEBUG, unit=ProbeUnit.BYTES)
    public long priorityBytesPending() {
        return this.bytesPending(this.priorityWriteQueue);
    }

    private long bytesPending(Queue<OutboundFrame> writeQueue) {
        long bytesPending = 0L;
        for (OutboundFrame frame : writeQueue) {
            bytesPending += (long)frame.getFrameLength();
        }
        return bytesPending;
    }

    @Probe(name="idleTimeMillis", unit=ProbeUnit.MS, level=ProbeLevel.DEBUG)
    private long idleTimeMillis() {
        return Math.max(System.currentTimeMillis() - this.lastWriteTime, 0L);
    }

    @Probe(name="scheduled", level=ProbeLevel.DEBUG)
    private long scheduled() {
        return this.scheduled.get().ordinal();
    }

    public void write(OutboundFrame frame) {
        State state;
        if (frame.isUrgent()) {
            this.priorityWriteQueue.offer(frame);
        } else {
            this.writeQueue.offer(frame);
        }
        while ((state = this.scheduled.get()) == State.UNSCHEDULED) {
            if (!this.scheduled.compareAndSet(State.UNSCHEDULED, State.SCHEDULED)) continue;
            this.executePipeline();
            return;
        }
        if (state == State.SCHEDULED || state == State.RESCHEDULE) {
            if (this.writeThroughEnabled) {
                this.concurrencyDetection.onDetected();
            }
            return;
        }
        if (state == State.BLOCKED) {
            return;
        }
        throw new IllegalStateException("Unexpected state:" + (Object)((Object)state));
    }

    private void executePipeline() {
        if (this.writeThroughEnabled && !this.concurrencyDetection.isDetected()) {
            try {
                this.process();
            }
            catch (Throwable t2) {
                this.onError(t2);
            }
        } else {
            SelectionKey selectionKey = this.selectionKey;
            if (this.selectionKeyWakeupEnabled && selectionKey != null) {
                try {
                    this.registerOp(4);
                    selectionKey.selector().wakeup();
                }
                catch (CancelledKeyException t3) {
                    EmptyStatement.ignore(t3);
                }
            } else {
                this.ownerAddTaskAndWakeup(this);
            }
        }
    }

    @Override
    public OutboundPipeline wakeup() {
        State prevState;
        while ((prevState = this.scheduled.get()) != State.RESCHEDULE) {
            if (!this.scheduled.compareAndSet(prevState, State.RESCHEDULE)) continue;
            if (prevState != State.UNSCHEDULED && prevState != State.BLOCKED) break;
            this.ownerAddTaskAndWakeup(this);
            break;
        }
        return this;
    }

    @Override
    public OutboundFrame get() {
        OutboundFrame frame = this.priorityWriteQueue.poll();
        if (frame == null) {
            frame = this.writeQueue.poll();
            if (frame == null) {
                return null;
            }
            this.normalFramesWritten.inc();
        } else {
            this.priorityFramesWritten.inc();
        }
        return frame;
    }

    @Override
    public void process() throws Exception {
        this.processCount.inc();
        OutboundHandler[] localHandlers = this.handlers;
        HandlerStatus pipelineStatus = HandlerStatus.CLEAN;
        for (int handlerIndex = 0; handlerIndex < localHandlers.length; ++handlerIndex) {
            OutboundHandler handler = localHandlers[handlerIndex];
            HandlerStatus handlerStatus = handler.onWrite();
            if (localHandlers != this.handlers) {
                localHandlers = this.handlers;
                pipelineStatus = HandlerStatus.CLEAN;
                handlerIndex = -1;
                continue;
            }
            if (handlerStatus == HandlerStatus.CLEAN) continue;
            pipelineStatus = handlerStatus;
        }
        this.flushToSocket();
        if (this.migrationRequested()) {
            this.startMigration();
            return;
        }
        if (this.sendBuffer.remaining() > 0) {
            pipelineStatus = HandlerStatus.DIRTY;
        }
        switch (pipelineStatus) {
            case CLEAN: {
                this.postProcessClean();
                break;
            }
            case DIRTY: {
                this.postProcessDirty();
                break;
            }
            case BLOCKED: {
                this.postProcessBlocked();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void postProcessBlocked() throws IOException {
        block4: {
            State state;
            this.unregisterOp(4);
            while ((state = this.scheduled.get()) == State.SCHEDULED) {
                if (!this.scheduled.compareAndSet(State.SCHEDULED, State.BLOCKED)) continue;
                break block4;
            }
            if (state != State.BLOCKED) {
                if (state == State.RESCHEDULE) {
                    this.scheduled.set(State.SCHEDULED);
                    this.owner().addTaskAndWakeup(this);
                } else {
                    throw new IllegalStateException("unexpected state:" + (Object)((Object)state));
                }
            }
        }
    }

    private void postProcessDirty() throws IOException {
        this.registerOp(4);
        if (this.writeThroughEnabled && !(Thread.currentThread() instanceof NioThread)) {
            this.owner.getSelector().wakeup();
            this.concurrencyDetection.onDetected();
        }
    }

    private void postProcessClean() throws IOException {
        State state;
        this.unregisterOp(4);
        do {
            if ((state = this.scheduled.get()) != State.RESCHEDULE) continue;
            this.scheduled.set(State.SCHEDULED);
            this.owner().addTaskAndWakeup(this);
            return;
        } while (!this.scheduled.compareAndSet(state, State.UNSCHEDULED));
        if (this.writeQueue.isEmpty() && this.priorityWriteQueue.isEmpty()) {
            return;
        }
        if (this.scheduled.compareAndSet(State.UNSCHEDULED, State.SCHEDULED)) {
            if (Thread.currentThread().getClass() == NioThread.class) {
                this.owner().addTask(this);
            } else {
                this.owner().addTaskAndWakeup(this);
            }
        }
    }

    private void flushToSocket() throws IOException {
        this.lastWriteTime = System.currentTimeMillis();
        int written = this.socketChannel.write(this.sendBuffer);
        this.bytesWritten.inc(written);
    }

    void drainWriteQueues() {
        this.writeQueue.clear();
        this.priorityWriteQueue.clear();
    }

    long bytesWritten() {
        return this.bytesWritten.get();
    }

    @Override
    protected void publishMetrics() {
        if (Thread.currentThread() != this.owner) {
            return;
        }
        this.owner.bytesTransceived += this.bytesWritten.get() - this.bytesWrittenLastPublish;
        this.owner.framesTransceived += this.normalFramesWritten.get() - this.normalFramesWrittenLastPublish;
        this.owner.priorityFramesTransceived += this.priorityFramesWritten.get() - this.priorityFramesWrittenLastPublish;
        this.owner.processCount += this.processCount.get() - this.processCountLastPublish;
        this.bytesWrittenLastPublish = this.bytesWritten.get();
        this.normalFramesWrittenLastPublish = this.normalFramesWritten.get();
        this.priorityFramesWrittenLastPublish = this.priorityFramesWritten.get();
        this.processCountLastPublish = this.processCount.get();
    }

    public String toString() {
        return this.channel + ".outboundPipeline";
    }

    @Override
    protected Iterable<? extends ChannelHandler> handlers() {
        return Arrays.asList(this.handlers);
    }

    @Override
    public OutboundPipeline remove(OutboundHandler handler) {
        return this.replace(handler, new OutboundHandler[0]);
    }

    @Override
    public OutboundPipeline addLast(OutboundHandler ... addedHandlers) {
        Preconditions.checkNotNull(addedHandlers, "addedHandlers can't be null");
        for (OutboundHandler addedHandler : addedHandlers) {
            ((ChannelHandler)addedHandler.setChannel(this.channel)).handlerAdded();
        }
        this.updatePipeline(ArrayUtils.append(this.handlers, addedHandlers));
        return this;
    }

    @Override
    public OutboundPipeline replace(OutboundHandler oldHandler, OutboundHandler ... addedHandlers) {
        Preconditions.checkNotNull(oldHandler, "oldHandler can't be null");
        Preconditions.checkNotNull(addedHandlers, "newHandler can't be null");
        OutboundHandler[] newHandlers = ArrayUtils.replaceFirst(this.handlers, oldHandler, addedHandlers);
        if (newHandlers == this.handlers) {
            throw new IllegalArgumentException("handler " + oldHandler + " isn't part of the pipeline");
        }
        for (OutboundHandler addedHandler : addedHandlers) {
            ((ChannelHandler)addedHandler.setChannel(this.channel)).handlerAdded();
        }
        this.updatePipeline(newHandlers);
        return this;
    }

    private void updatePipeline(OutboundHandler[] newHandlers) {
        this.handlers = newHandlers;
        this.sendBuffer = newHandlers.length == 0 ? null : (ByteBuffer)newHandlers[newHandlers.length - 1].dst();
        ChannelHandler prev = null;
        for (OutboundHandler handler : this.handlers) {
            if (prev == null) {
                handler.src(this);
            } else {
                Object src = prev.dst();
                if (src instanceof ByteBuffer) {
                    handler.src(src);
                }
            }
            prev = handler;
        }
    }

    private String pipelineToString() {
        StringBuilder sb = new StringBuilder("out-pipeline[");
        OutboundHandler[] handlers = this.handlers;
        for (int k = 0; k < handlers.length; ++k) {
            if (k > 0) {
                sb.append("->-");
            }
            sb.append(handlers[k].getClass().getSimpleName());
        }
        sb.append(']');
        return sb.toString();
    }

    public static enum State {
        UNSCHEDULED,
        SCHEDULED,
        BLOCKED,
        RESCHEDULE;

    }
}

